/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory;

import info.aduna.io.IOUtil;
import info.aduna.iteration.CloseableIteration;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.ReadMode;

class FileIO {
    private static final byte[] MAGIC_NUMBER = new byte[]{66, 77, 83, 70};
    private static final int BMSF_VERSION = 2;
    public static final int NAMESPACE_MARKER = 1;
    public static final int EXPL_TRIPLE_MARKER = 2;
    public static final int EXPL_QUAD_MARKER = 3;
    public static final int INF_TRIPLE_MARKER = 4;
    public static final int INF_QUAD_MARKER = 5;
    public static final int URI_MARKER = 6;
    public static final int BNODE_MARKER = 7;
    public static final int PLAIN_LITERAL_MARKER = 8;
    public static final int LANG_LITERAL_MARKER = 9;
    public static final int DATATYPE_LITERAL_MARKER = 10;
    public static final int EOF_MARKER = 127;
    private final MemoryStore store;
    private final CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
    private final CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
    private int formatVersion;

    public FileIO(MemoryStore store) {
        this.store = store;
    }

    public synchronized void write(File syncFile, File dataFile) throws IOException, SailException {
        this.write(syncFile);
        boolean renamed = syncFile.renameTo(dataFile);
        if (!renamed && syncFile.exists() && dataFile.exists()) {
            dataFile.delete();
            renamed = syncFile.renameTo(dataFile);
        }
        if (!renamed) {
            String path = syncFile.getAbsolutePath();
            String name = dataFile.getName();
            throw new IOException("Could not rename " + path + " to " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File dataFile) throws IOException, SailException {
        OutputStream out = new FileOutputStream(dataFile);
        try {
            out.write(MAGIC_NUMBER);
            out.write(2);
            DataOutputStream dataOut = new DataOutputStream(new GZIPOutputStream(out));
            out = dataOut;
            this.writeNamespaces(dataOut);
            this.writeStatements(dataOut);
            dataOut.writeByte(127);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read(File dataFile) throws IOException {
        InputStream in = new FileInputStream(dataFile);
        try {
            byte recordTypeMarker;
            byte[] magicNumber = IOUtil.readBytes(in, MAGIC_NUMBER.length);
            if (!Arrays.equals(magicNumber, MAGIC_NUMBER)) {
                throw new IOException("File is not a binary MemoryStore file");
            }
            this.formatVersion = in.read();
            if (this.formatVersion > 2 || this.formatVersion < 1) {
                throw new IOException("Incompatible format version: " + this.formatVersion);
            }
            DataInputStream dataIn = new DataInputStream(new GZIPInputStream(in));
            in = dataIn;
            block10: while ((recordTypeMarker = dataIn.readByte()) != 127) {
                switch (recordTypeMarker) {
                    case 1: {
                        this.readNamespace(dataIn);
                        continue block10;
                    }
                    case 2: {
                        this.readStatement(false, true, dataIn);
                        continue block10;
                    }
                    case 3: {
                        this.readStatement(true, true, dataIn);
                        continue block10;
                    }
                    case 4: {
                        this.readStatement(false, false, dataIn);
                        continue block10;
                    }
                    case 5: {
                        this.readStatement(true, false, dataIn);
                        continue block10;
                    }
                }
                throw new IOException("Invalid record type marker: " + recordTypeMarker);
            }
        }
        finally {
            in.close();
        }
    }

    private void writeNamespaces(DataOutputStream dataOut) throws IOException {
        for (NamespaceImpl ns : this.store.getNamespaceStore()) {
            dataOut.writeByte(1);
            this.writeString(ns.getPrefix(), dataOut);
            this.writeString(ns.getName(), dataOut);
        }
    }

    private void readNamespace(DataInputStream dataIn) throws IOException {
        String prefix = this.readString(dataIn);
        String name = this.readString(dataIn);
        if (this.formatVersion <= 1) {
            dataIn.readBoolean();
        }
        this.store.getNamespaceStore().setNamespace(prefix, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatements(DataOutputStream dataOut) throws IOException, SailException {
        CloseableIteration<MemStatement, SailException> stIter = this.store.createStatementIterator(SailException.class, null, null, null, false, this.store.getCurrentSnapshot(), ReadMode.COMMITTED, new Resource[0]);
        try {
            while (stIter.hasNext()) {
                MemStatement st = (MemStatement)stIter.next();
                MemResource context = st.getContext();
                if (st.isExplicit()) {
                    if (context == null) {
                        dataOut.writeByte(2);
                    } else {
                        dataOut.writeByte(3);
                    }
                } else if (context == null) {
                    dataOut.writeByte(4);
                } else {
                    dataOut.writeByte(5);
                }
                this.writeValue(st.getSubject(), dataOut);
                this.writeValue(st.getPredicate(), dataOut);
                this.writeValue(st.getObject(), dataOut);
                if (context == null) continue;
                this.writeValue(context, dataOut);
            }
        }
        finally {
            stIter.close();
        }
    }

    private void readStatement(boolean hasContext, boolean isExplicit, DataInputStream dataIn) throws IOException, ClassCastException {
        MemResource memSubj = (MemResource)this.readValue(dataIn);
        MemURI memPred = (MemURI)this.readValue(dataIn);
        MemValue memObj = (MemValue)this.readValue(dataIn);
        MemResource memContext = null;
        if (hasContext) {
            memContext = (MemResource)this.readValue(dataIn);
        }
        MemStatement st = new MemStatement(memSubj, memPred, memObj, memContext, isExplicit, this.store.getCurrentSnapshot());
        this.store.getStatements().add(st);
        st.addToComponentLists();
    }

    private void writeValue(Value value, DataOutputStream dataOut) throws IOException {
        if (value instanceof URI) {
            dataOut.writeByte(6);
            this.writeString(((Object)((URI)value)).toString(), dataOut);
        } else if (value instanceof BNode) {
            dataOut.writeByte(7);
            this.writeString(((BNode)value).getID(), dataOut);
        } else if (value instanceof Literal) {
            Literal lit = (Literal)value;
            String label = lit.getLabel();
            String language = lit.getLanguage();
            URI datatype = lit.getDatatype();
            if (datatype != null) {
                dataOut.writeByte(10);
                this.writeString(label, dataOut);
                this.writeValue(datatype, dataOut);
            } else if (language != null) {
                dataOut.writeByte(9);
                this.writeString(label, dataOut);
                this.writeString(language, dataOut);
            } else {
                dataOut.writeByte(8);
                this.writeString(label, dataOut);
            }
        } else {
            throw new IllegalArgumentException("unexpected value type: " + value.getClass());
        }
    }

    private Value readValue(DataInputStream dataIn) throws IOException, ClassCastException {
        byte valueTypeMarker = dataIn.readByte();
        if (valueTypeMarker == 6) {
            String uriString = this.readString(dataIn);
            return this.store.getValueFactory().createURI(uriString);
        }
        if (valueTypeMarker == 7) {
            String bnodeID = this.readString(dataIn);
            return this.store.getValueFactory().createBNode(bnodeID);
        }
        if (valueTypeMarker == 8) {
            String label = this.readString(dataIn);
            return this.store.getValueFactory().createLiteral(label);
        }
        if (valueTypeMarker == 9) {
            String label = this.readString(dataIn);
            String language = this.readString(dataIn);
            return this.store.getValueFactory().createLiteral(label, language);
        }
        if (valueTypeMarker == 10) {
            String label = this.readString(dataIn);
            URI datatype = (URI)this.readValue(dataIn);
            return this.store.getValueFactory().createLiteral(label, datatype);
        }
        throw new IOException("Invalid value type marker: " + valueTypeMarker);
    }

    private void writeString(String s, DataOutputStream dataOut) throws IOException {
        ByteBuffer byteBuf = this.charsetEncoder.encode(CharBuffer.wrap(s));
        dataOut.writeInt(byteBuf.remaining());
        dataOut.write(byteBuf.array(), 0, byteBuf.remaining());
    }

    private String readString(DataInputStream dataIn) throws IOException {
        if (this.formatVersion == 1) {
            return this.readStringV1(dataIn);
        }
        return this.readStringV2(dataIn);
    }

    private String readStringV1(DataInputStream dataIn) throws IOException {
        return dataIn.readUTF();
    }

    private String readStringV2(DataInputStream dataIn) throws IOException {
        int stringLength = dataIn.readInt();
        byte[] encodedString = IOUtil.readBytes((InputStream)dataIn, stringLength);
        if (encodedString.length != stringLength) {
            throw new EOFException("Attempted to read " + stringLength + " bytes but no more than " + encodedString.length + " were available");
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(encodedString);
        CharBuffer charBuf = this.charsetDecoder.decode(byteBuf);
        return charBuf.toString();
    }
}

