/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailConfigSchema;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.config.SailRegistry;

public class SailConfigUtil {
    public static SailImplConfig parseRepositoryImpl(Graph graph, Resource implNode) throws SailConfigException {
        try {
            Literal typeLit = GraphUtil.getOptionalObjectLiteral(graph, implNode, SailConfigSchema.SAILTYPE);
            if (typeLit != null) {
                SailFactory factory = (SailFactory)SailRegistry.getInstance().get(typeLit.getLabel());
                if (factory != null) {
                    SailImplConfig implConfig = factory.getConfig();
                    implConfig.parse(graph, implNode);
                    return implConfig;
                }
                throw new SailConfigException("Unsupported Sail type: " + typeLit.getLabel());
            }
            return null;
        }
        catch (GraphUtilException e2) {
            throw new SailConfigException(e2.getMessage(), e2);
        }
    }
}

