/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.sail.config.DelegatingSailImplConfig;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailConfigSchema;
import org.openrdf.sail.config.SailConfigUtil;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.config.SailImplConfigBase;

public class DelegatingSailImplConfigBase
extends SailImplConfigBase
implements DelegatingSailImplConfig {
    private SailImplConfig delegate;

    public DelegatingSailImplConfigBase() {
    }

    public DelegatingSailImplConfigBase(String type) {
        super(type);
    }

    public DelegatingSailImplConfigBase(String type, SailImplConfig delegate) {
        this(type);
        this.setDelegate(delegate);
    }

    public SailImplConfig getDelegate() {
        return this.delegate;
    }

    public void setDelegate(SailImplConfig delegate) {
        this.delegate = delegate;
    }

    public void validate() throws SailConfigException {
        super.validate();
        if (this.delegate == null) {
            throw new SailConfigException("No delegate specified for " + this.getType() + " Sail");
        }
        this.delegate.validate();
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (this.delegate != null) {
            Resource delegateNode = this.delegate.export(graph);
            graph.add(implNode, SailConfigSchema.DELEGATE, delegateNode, new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Resource delegateNode = GraphUtil.getOptionalObjectResource(graph, implNode, SailConfigSchema.DELEGATE);
            if (delegateNode != null) {
                this.setDelegate(SailConfigUtil.parseRepositoryImpl(graph, delegateNode));
            }
        }
        catch (GraphUtilException e2) {
            throw new SailConfigException(e2.getMessage(), e2);
        }
    }
}

