/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.ntriples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class NTriplesWriter
implements RDFWriter {
    private final Writer writer;
    private boolean writingStarted;

    public NTriplesWriter(OutputStream out) {
        this(new OutputStreamWriter(out, Charset.forName("US-ASCII")));
    }

    public NTriplesWriter(Writer writer) {
        this.writer = writer;
        this.writingStarted = false;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this.writingStarted = true;
    }

    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
        finally {
            this.writingStarted = false;
        }
    }

    public void handleNamespace(String prefix, String name) {
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            NTriplesUtil.append(st.getSubject(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append(st.getPredicate(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append(st.getObject(), (Appendable)this.writer);
            this.writer.write(" .\n");
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.writer.write("\n");
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
    }
}

