/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLParser;
import org.openrdf.repository.sparql.query.BackgroundTupleResult;
import org.openrdf.repository.sparql.query.InsertBindingSetCursor;
import org.openrdf.repository.sparql.query.SPARQLQuery;

public class SPARQLTupleQuery
extends SPARQLQuery
implements TupleQuery {
    private SPARQLResultsXMLParser parser = new SPARQLResultsXMLParser();

    public SPARQLTupleQuery(HttpClient client, String url, String base, String query2) {
        super(client, url, base, query2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TupleQueryResult evaluate() throws QueryEvaluationException {
        try {
            BackgroundTupleResult result = null;
            HttpMethodBase response = this.getResponse();
            try {
                InputStream in = response.getResponseBodyAsStream();
                result = new BackgroundTupleResult(this.parser, in, response);
                this.execute(result);
                InsertBindingSetCursor cursor = new InsertBindingSetCursor(result, this.getBindings());
                ArrayList<String> list = new ArrayList<String>(result.getBindingNames());
                list.addAll(this.getBindingNames());
                TupleQueryResultImpl tupleQueryResultImpl = new TupleQueryResultImpl(list, cursor);
                return tupleQueryResultImpl;
            }
            catch (HttpException e2) {
                throw new QueryEvaluationException(e2);
            }
            finally {
                if (result == null) {
                    response.abort();
                }
            }
        }
        catch (IOException e3) {
            throw new QueryEvaluationException(e3);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        try {
            boolean complete = false;
            HttpMethodBase response = this.getResponse();
            try {
                this.parser.setTupleQueryResultHandler(handler);
                this.parser.parse(response.getResponseBodyAsStream());
                complete = true;
            }
            catch (HttpException e2) {
                throw new QueryEvaluationException(e2);
            }
            catch (QueryResultParseException e3) {
                throw new QueryEvaluationException(e3);
            }
            catch (TupleQueryResultHandlerException e4) {
                throw new QueryEvaluationException(e4);
            }
            finally {
                if (!complete) {
                    response.abort();
                }
            }
        }
        catch (IOException e5) {
            throw new QueryEvaluationException(e5);
        }
    }

    protected String getAccept() {
        return this.parser.getTupleQueryResultFormat().getDefaultMIMEType();
    }
}

