/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import info.aduna.net.ParsedURI;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.sparql.SPARQLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SPARQLQuery
implements Query {
    private static Executor executor = Executors.newCachedThreadPool();
    private HttpClient client;
    private String url;
    private String query;
    private Dataset dataset = new DatasetImpl();
    private MapBindingSet bindings = new MapBindingSet();

    public SPARQLQuery(HttpClient client, String url, String base, String query2) {
        boolean abs;
        this.url = url;
        this.query = query2;
        this.client = client;
        boolean bl = abs = base != null && base.length() > 0 && new ParsedURI(base).isAbsolute();
        if (abs && !query2.toUpperCase().contains("BASE")) {
            this.query = "BASE <" + base + "> " + query2;
        }
    }

    @Override
    public BindingSet getBindings() {
        return this.bindings;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean getIncludeInferred() {
        return true;
    }

    @Override
    public int getMaxQueryTime() {
        return 0;
    }

    @Override
    public void removeBinding(String name) {
        this.bindings.removeBinding(name);
    }

    @Override
    public void setBinding(String name, Value value) {
        assert (value instanceof Literal || value instanceof URI);
        this.bindings.addBinding(name, value);
    }

    @Override
    public void clearBindings() {
        this.bindings.clear();
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public void setIncludeInferred(boolean inf) {
        if (!inf) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setMaxQueryTime(int maxQueryTime) {
        throw new UnsupportedOperationException();
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpMethodBase getResponse() throws HttpException, IOException, QueryEvaluationException {
        PostMethod post = new PostMethod(this.url);
        post.addParameter("query", this.getQueryString());
        if (this.dataset != null) {
            for (URI graph : this.dataset.getDefaultGraphs()) {
                post.addParameter("default-graph-uri", graph.stringValue());
            }
            for (URI graph : this.dataset.getNamedGraphs()) {
                post.addParameter("named-graph-uri", graph.stringValue());
            }
        }
        post.addRequestHeader("Accept", this.getAccept());
        Map additionalHeaders = (Map)this.client.getParams().getParameter(SPARQLConnection.ADDITIONAL_HEADER_NAME);
        if (additionalHeaders != null) {
            for (Map.Entry additionalHeader : additionalHeaders.entrySet()) {
                post.addRequestHeader((String)additionalHeader.getKey(), (String)additionalHeader.getValue());
            }
        }
        boolean completed = false;
        try {
            if (this.client.executeMethod(post) >= 400) {
                throw new QueryEvaluationException(post.getResponseBodyAsString());
            }
            completed = true;
            PostMethod postMethod = post;
            return postMethod;
        }
        finally {
            if (!completed) {
                post.abort();
            }
        }
    }

    protected void execute(Runnable command) {
        executor.execute(command);
    }

    protected Set<String> getBindingNames() {
        if (this.bindings.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> names = new HashSet<String>();
        String qry = this.query;
        int b = qry.indexOf(123);
        String select = qry.substring(0, b);
        for (String name : this.bindings.getBindingNames()) {
            String pattern;
            String replacement = this.getReplacement(this.bindings.getValue(name));
            if (replacement == null || !Pattern.compile(pattern = ".*[\\?\\$]" + name + "\\W.*", 40).matcher(select).matches()) continue;
            names.add(name);
        }
        return names;
    }

    protected abstract String getAccept();

    private String getQueryString() {
        if (this.bindings.size() == 0) {
            return this.query;
        }
        String qry = this.query;
        int b = qry.indexOf(123);
        String select = qry.substring(0, b);
        String where = qry.substring(b);
        for (String name : this.bindings.getBindingNames()) {
            String replacement = this.getReplacement(this.bindings.getValue(name));
            if (replacement == null) continue;
            String pattern = "[\\?\\$]" + name + "(?=\\W)";
            select = select.replaceAll(pattern, "");
            where = where.replaceAll(pattern, replacement);
        }
        return select + where;
    }

    private String getReplacement(Value value) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof URI) {
            return this.appendValue(sb, (URI)value).toString();
        }
        if (value instanceof Literal) {
            return this.appendValue(sb, (Literal)value).toString();
        }
        throw new IllegalArgumentException("BNode references not supported by SPARQL end-points");
    }

    private StringBuilder appendValue(StringBuilder sb, URI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    private StringBuilder appendValue(StringBuilder sb, Literal lit) {
        sb.append('\"');
        sb.append(lit.getLabel().replace("\"", "\\\""));
        sb.append('\"');
        if (lit.getLanguage() != null) {
            sb.append('@');
            sb.append(lit.getLanguage());
        }
        if (lit.getDatatype() != null) {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }
}

