/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql;

import info.aduna.io.MavenUtil;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.SingletonIteration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.Update;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.repository.sparql.SPARQLRepository;
import org.openrdf.repository.sparql.query.SPARQLBooleanQuery;
import org.openrdf.repository.sparql.query.SPARQLGraphQuery;
import org.openrdf.repository.sparql.query.SPARQLTupleQuery;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLConnection
extends RepositoryConnectionBase {
    private static final String EVERYTHING = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }";
    private static final String SOMETHING = "ASK { ?s ?p ?o }";
    private static final String NAMEDGRAPHS = "SELECT DISTINCT ?_ WHERE { GRAPH ?_ { ?s ?p ?o } }";
    private static final String APP_NAME = "OpenRDF.org SPARQLConnection";
    private static final String VERSION = MavenUtil.loadVersion("org.openrdf.sesame", "sesame-repository-sparql", "devel");
    public static String ADDITIONAL_HEADER_NAME = "additionalHTTPHeaders";
    private HttpClient client;
    private String queryEndpointUrl;
    private String updateEndpointUrl;

    public SPARQLConnection(SPARQLRepository repository, String queryEndpointUrl, String updateEndpointUrl) {
        super(repository);
        this.queryEndpointUrl = queryEndpointUrl;
        this.updateEndpointUrl = updateEndpointUrl;
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(20);
        params.setStaleCheckingEnabled(false);
        manager.setParams(params);
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setParameter("http.useragent", "OpenRDF.org SPARQLConnection/" + VERSION + " " + clientParams.getParameter("http.useragent"));
        if (repository.getAdditionalHttpHeaders() != null) {
            clientParams.setParameter(ADDITIONAL_HEADER_NAME, repository.getAdditionalHttpHeaders());
        }
        this.client = new HttpClient(clientParams, manager);
    }

    public String toString() {
        return this.queryEndpointUrl;
    }

    @Override
    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        try {
            GraphQuery query2 = this.prepareGraphQuery(QueryLanguage.SPARQL, EVERYTHING, "");
            this.setBindings(query2, subj, pred, obj, contexts);
            query2.evaluate(handler);
        }
        catch (MalformedQueryException e2) {
            throw new RepositoryException(e2);
        }
        catch (QueryEvaluationException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            TupleQuery query2 = this.prepareTupleQuery(QueryLanguage.SPARQL, NAMEDGRAPHS, "");
            TupleQueryResult result = query2.evaluate();
            return new RepositoryResult<Resource>(new ExceptionConvertingIteration<Resource, RepositoryException>((Iteration)new ConvertingIteration<BindingSet, Resource, QueryEvaluationException>((Iteration)result){

                @Override
                protected Resource convert(BindingSet bindings2) throws QueryEvaluationException {
                    return (Resource)bindings2.getValue("_");
                }
            }){

                @Override
                protected RepositoryException convert(Exception e2) {
                    return new RepositoryException(e2);
                }
            });
        }
        catch (MalformedQueryException e2) {
            throw new RepositoryException(e2);
        }
        catch (QueryEvaluationException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public String getNamespace(String prefix) throws RepositoryException {
        return null;
    }

    @Override
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        return new RepositoryResult<Namespace>(new EmptyIteration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        RepositoryResult<Statement> stmts = this.getStatements(null, null, null, true, contexts);
        try {
            long i = 0L;
            while (stmts.hasNext()) {
                stmts.next();
                ++i;
            }
            long l = i;
            return l;
        }
        finally {
            stmts.close();
        }
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            if (subj != null && pred != null && obj != null) {
                if (this.hasStatement(subj, pred, obj, includeInferred, contexts)) {
                    StatementImpl st = new StatementImpl(subj, pred, obj);
                    SingletonIteration cursor = new SingletonIteration(st);
                    return new RepositoryResult<Statement>(cursor);
                }
                return new RepositoryResult<Statement>(new EmptyIteration());
            }
            GraphQuery query2 = this.prepareGraphQuery(QueryLanguage.SPARQL, EVERYTHING, "");
            this.setBindings(query2, subj, pred, obj, contexts);
            GraphQueryResult result = query2.evaluate();
            return new RepositoryResult<Statement>(new ExceptionConvertingIteration<Statement, RepositoryException>((Iteration)result){

                @Override
                protected RepositoryException convert(Exception e2) {
                    return new RepositoryException(e2);
                }
            });
        }
        catch (MalformedQueryException e2) {
            throw new RepositoryException(e2);
        }
        catch (QueryEvaluationException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            BooleanQuery query2 = this.prepareBooleanQuery(QueryLanguage.SPARQL, SOMETHING, "");
            this.setBindings(query2, subj, pred, obj, contexts);
            return query2.evaluate();
        }
        catch (MalformedQueryException e2) {
            throw new RepositoryException(e2);
        }
        catch (QueryEvaluationException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query2, String base) throws RepositoryException, MalformedQueryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query2, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals(ql)) {
            return new SPARQLBooleanQuery(this.client, this.queryEndpointUrl, base, query2);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query2, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals(ql)) {
            return new SPARQLGraphQuery(this.client, this.queryEndpointUrl, base, query2);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query2, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals(ql)) {
            return new SPARQLTupleQuery(this.client, this.queryEndpointUrl, base, query2);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    @Override
    public void commit() throws RepositoryException {
    }

    @Override
    public boolean isAutoCommit() throws RepositoryException {
        return true;
    }

    @Override
    public void rollback() throws RepositoryException {
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        if (!autoCommit) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E extends Exception> void remove(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNamespace(String prefix, String name) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update2) throws RepositoryException, MalformedQueryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update2, String baseURI) throws RepositoryException, MalformedQueryException {
        throw new UnsupportedOperationException();
    }

    private void setBindings(Query query2, Resource subj, URI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (subj != null) {
            query2.setBinding("s", subj);
        }
        if (pred != null) {
            query2.setBinding("p", pred);
        }
        if (obj != null) {
            query2.setBinding("o", obj);
        }
        if (contexts != null && contexts.length > 0 && (contexts[0] != null || contexts.length > 1)) {
            DatasetImpl dataset = new DatasetImpl();
            for (Resource ctx : contexts) {
                if (!(ctx instanceof URI)) {
                    throw new RepositoryException("Contexts must be URIs");
                }
                dataset.addDefaultGraph((URI)ctx);
            }
            query2.setDataset(dataset);
        }
    }

    @Override
    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

