/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultUtil;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.GraphQueryResultImpl;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.repository.sail.SailQuery;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailGraphQuery
extends SailQuery
implements GraphQuery {
    protected SailGraphQuery(ParsedGraphQuery tupleQuery, SailRepositoryConnection con) {
        super(tupleQuery, con);
    }

    public ParsedGraphQuery getParsedQuery() {
        return (ParsedGraphQuery)super.getParsedQuery();
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
        try {
            SailConnection sailCon = this.getConnection().getSailConnection();
            CloseableIteration<BindingSet, QueryEvaluationException> bindingsIter = sailCon.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred());
            bindingsIter = new FilterIteration<BindingSet, QueryEvaluationException>(bindingsIter){

                @Override
                protected boolean accept(BindingSet bindingSet) {
                    Value context = bindingSet.getValue("context");
                    return bindingSet.getValue("subject") instanceof Resource && bindingSet.getValue("predicate") instanceof URI && bindingSet.getValue("object") instanceof Value && (context == null || context instanceof Resource);
                }
            };
            bindingsIter = this.enforceMaxQueryTime((CloseableIteration<? extends BindingSet, QueryEvaluationException>)bindingsIter);
            final ValueFactory vf = this.getConnection().getRepository().getValueFactory();
            ConvertingIteration<BindingSet, Statement, QueryEvaluationException> stIter = new ConvertingIteration<BindingSet, Statement, QueryEvaluationException>((Iteration)bindingsIter){

                @Override
                protected Statement convert(BindingSet bindingSet) {
                    Resource subject = (Resource)bindingSet.getValue("subject");
                    URI predicate = (URI)bindingSet.getValue("predicate");
                    Value object = bindingSet.getValue("object");
                    Resource context = (Resource)bindingSet.getValue("context");
                    if (context == null) {
                        return vf.createStatement(subject, predicate, object);
                    }
                    return vf.createStatement(subject, predicate, object, context);
                }
            };
            return new GraphQueryResultImpl(this.getParsedQuery().getQueryNamespaces(), (CloseableIteration<? extends Statement, ? extends QueryEvaluationException>)stIter);
        }
        catch (SailException e2) {
            throw new QueryEvaluationException(e2.getMessage(), e2);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        GraphQueryResult queryResult = this.evaluate();
        QueryResultUtil.report(queryResult, handler);
    }
}

