/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPQuery;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepositoryConnection;

public class HTTPTupleQuery
extends HTTPQuery
implements TupleQuery {
    public HTTPTupleQuery(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super(con, ql, queryString, baseURI);
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        HTTPClient client = this.httpCon.getRepository().getHTTPClient();
        try {
            return client.sendTupleQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.maxQueryTime, this.getBindingsArray());
        }
        catch (IOException e2) {
            throw new HTTPQueryEvaluationException(e2.getMessage(), e2);
        }
        catch (RepositoryException e3) {
            throw new HTTPQueryEvaluationException(e3.getMessage(), e3);
        }
        catch (MalformedQueryException e4) {
            throw new HTTPQueryEvaluationException(e4.getMessage(), e4);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        HTTPClient client = this.httpCon.getRepository().getHTTPClient();
        try {
            client.sendTupleQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.maxQueryTime, handler, this.getBindingsArray());
        }
        catch (IOException e2) {
            throw new HTTPQueryEvaluationException(e2.getMessage(), e2);
        }
        catch (RepositoryException e3) {
            throw new HTTPQueryEvaluationException(e3.getMessage(), e3);
        }
        catch (MalformedQueryException e4) {
            throw new HTTPQueryEvaluationException(e4.getMessage(), e4);
        }
    }
}

