/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import info.aduna.iteration.CloseableIteratorIteration;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.transaction.operations.AddStatementOperation;
import org.openrdf.http.protocol.transaction.operations.ClearNamespacesOperation;
import org.openrdf.http.protocol.transaction.operations.ClearOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveStatementsOperation;
import org.openrdf.http.protocol.transaction.operations.SetNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.repository.http.HTTPBooleanQuery;
import org.openrdf.repository.http.HTTPGraphQuery;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.repository.http.HTTPTupleQuery;
import org.openrdf.repository.http.HTTPUpdate;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.helpers.StatementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HTTPRepositoryConnection
extends RepositoryConnectionBase {
    private List<TransactionOperation> txn = Collections.synchronizedList(new ArrayList());
    private Throwable creatorTrace;

    private static boolean debugEnabled() {
        try {
            return System.getProperty("org.openrdf.repository.debug") != null;
        }
        catch (SecurityException e2) {
            return false;
        }
    }

    public HTTPRepositoryConnection(HTTPRepository repository) {
        super(repository);
        this.setParserConfig(new ParserConfig(true, true, true, RDFParser.DatatypeHandling.IGNORE));
        if (HTTPRepositoryConnection.debugEnabled()) {
            this.creatorTrace = new Throwable();
        }
    }

    @Override
    public void setParserConfig(ParserConfig parserConfig) {
        super.setParserConfig(parserConfig);
        this.getRepository().getHTTPClient().setParserConfig(parserConfig);
    }

    @Override
    public HTTPRepository getRepository() {
        return (HTTPRepository)super.getRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                if (this.creatorTrace != null) {
                    this.logger.warn("Closing connection due to garbage collection, connection was create in:", this.creatorTrace);
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String queryString, String baseURI) {
        if (QueryLanguage.SPARQL.equals(ql)) {
            String strippedQuery = this.stripSparqlQueryString(queryString).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, queryString, baseURI);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, queryString, baseURI);
            }
            return this.prepareGraphQuery(ql, queryString, baseURI);
        }
        if (QueryLanguage.SERQL.equals(ql)) {
            String strippedQuery = queryString;
            strippedQuery = strippedQuery.replace('(', ' ');
            if ((strippedQuery = strippedQuery.trim()).toUpperCase().startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, queryString, baseURI);
            }
            return this.prepareGraphQuery(ql, queryString, baseURI);
        }
        throw new UnsupportedOperationException("Operation not supported for query language " + ql);
    }

    private String stripSparqlQueryString(String queryString) {
        String normalizedQuery = queryString;
        Pattern pattern = Pattern.compile("prefix[^:]+:\\s*<[^>]*>\\s*", 2);
        Matcher matcher = pattern.matcher(queryString);
        int startIndexCorrection = 0;
        while (matcher.find()) {
            normalizedQuery = normalizedQuery.substring(matcher.end() - startIndexCorrection, normalizedQuery.length());
            startIndexCorrection += matcher.end() - startIndexCorrection;
        }
        pattern = Pattern.compile("base\\s+<[^>]*>\\s*", 2);
        matcher = pattern.matcher(normalizedQuery);
        if (matcher.find()) {
            normalizedQuery = normalizedQuery.substring(matcher.end(), normalizedQuery.length());
        }
        return normalizedQuery.trim();
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPTupleQuery(this, ql, queryString, baseURI);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPGraphQuery(this, ql, queryString, baseURI);
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPBooleanQuery(this, ql, queryString, baseURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            ArrayList<Resource> contextList = new ArrayList<Resource>();
            TupleQueryResult contextIDs = this.getRepository().getHTTPClient().getContextIDs();
            try {
                while (contextIDs.hasNext()) {
                    BindingSet bindingSet = (BindingSet)contextIDs.next();
                    Value context = bindingSet.getValue("contextID");
                    if (!(context instanceof Resource)) continue;
                    contextList.add((Resource)context);
                }
            }
            finally {
                contextIDs.close();
            }
            return this.createRepositoryResult(contextList);
        }
        catch (QueryEvaluationException e2) {
            throw new RepositoryException(e2);
        }
        catch (IOException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements(subj, pred, obj, includeInferred, collector, contexts);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, RepositoryException {
        try {
            this.getRepository().getHTTPClient().getStatements(subj, pred, obj, includeInferred, handler, contexts);
        }
        catch (IOException e2) {
            throw new RepositoryException(e2);
        }
        catch (QueryInterruptedException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        try {
            return this.getRepository().getHTTPClient().size(contexts);
        }
        catch (IOException e2) {
            throw new RepositoryException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RepositoryException {
        List<TransactionOperation> list = this.txn;
        synchronized (list) {
            if (this.txn.size() > 0) {
                try {
                    this.getRepository().getHTTPClient().sendTransaction(this.txn);
                    this.txn.clear();
                }
                catch (IOException e2) {
                    throw new RepositoryException(e2);
                }
            }
        }
    }

    @Override
    public void rollback() {
        this.txn.clear();
    }

    @Override
    public void close() throws RepositoryException {
        if (this.txn.size() > 0) {
            this.logger.warn("Rolling back transaction due to connection close", new Throwable());
            this.rollback();
        }
        super.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addInputStreamOrReader(Object inputStreamOrReader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isAutoCommit()) {
            HTTPClient httpClient = this.getRepository().getHTTPClient();
            if (inputStreamOrReader instanceof InputStream) {
                httpClient.upload((InputStream)inputStreamOrReader, baseURI, dataFormat, false, contexts);
                return;
            } else {
                if (!(inputStreamOrReader instanceof Reader)) throw new IllegalArgumentException("inputStreamOrReader must be an InputStream or a Reader, is a: " + inputStreamOrReader.getClass());
                httpClient.upload((Reader)inputStreamOrReader, baseURI, dataFormat, false, contexts);
            }
            return;
        } else {
            super.addInputStreamOrReader(inputStreamOrReader, baseURI, dataFormat, contexts);
        }
    }

    @Override
    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.txn.add(new AddStatementOperation(subject, predicate, object, contexts));
    }

    @Override
    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.txn.add(new RemoveStatementsOperation(subject, predicate, object, contexts));
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        this.txn.add(new ClearOperation(contexts));
        this.autoCommit();
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.txn.add(new RemoveNamespaceOperation(prefix));
        this.autoCommit();
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        this.txn.add(new ClearNamespacesOperation());
        this.autoCommit();
    }

    @Override
    public void setNamespace(String prefix, String name) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.txn.add(new SetNamespaceOperation(prefix, name));
        this.autoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            ArrayList<NamespaceImpl> namespaceList = new ArrayList<NamespaceImpl>();
            TupleQueryResult namespaces = this.getRepository().getHTTPClient().getNamespaces();
            try {
                while (namespaces.hasNext()) {
                    BindingSet bindingSet = (BindingSet)namespaces.next();
                    Value prefix = bindingSet.getValue("prefix");
                    Value namespace2 = bindingSet.getValue("namespace");
                    if (!(prefix instanceof Literal) || !(namespace2 instanceof Literal)) continue;
                    String prefixStr = ((Literal)prefix).getLabel();
                    String namespaceStr = ((Literal)namespace2).getLabel();
                    namespaceList.add(new NamespaceImpl(prefixStr, namespaceStr));
                }
            }
            finally {
                namespaces.close();
            }
            return this.createRepositoryResult(namespaceList);
        }
        catch (QueryEvaluationException e2) {
            throw new RepositoryException(e2);
        }
        catch (IOException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public String getNamespace(String prefix) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        try {
            return this.getRepository().getHTTPClient().getNamespace(prefix);
        }
        catch (IOException e2) {
            throw new RepositoryException(e2);
        }
    }

    protected <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> elements) {
        return new RepositoryResult<E>(new CloseableIteratorIteration(elements.iterator()));
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update2, String baseURI) throws RepositoryException, MalformedQueryException {
        return new HTTPUpdate(this, ql, update2, baseURI);
    }
}

