/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqljson;

import info.aduna.io.IndentingWriter;
import info.aduna.text.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLResultsJSONWriter
implements TupleQueryResultWriter {
    private IndentingWriter writer;
    private boolean firstTupleWritten;

    public SPARQLResultsJSONWriter(OutputStream out) {
        Writer w = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        w = new BufferedWriter(w, 1024);
        this.writer = new IndentingWriter(w);
    }

    @Override
    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.JSON;
    }

    @Override
    public void startQueryResult(List<String> columnHeaders) throws TupleQueryResultHandlerException {
        try {
            this.openBraces();
            this.writeKey("head");
            this.openBraces();
            this.writeKeyValue("vars", columnHeaders);
            this.closeBraces();
            this.writeComma();
            this.writeKey("results");
            this.openBraces();
            this.writeKey("bindings");
            this.openArray();
            this.firstTupleWritten = false;
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            this.closeArray();
            this.closeBraces();
            this.closeBraces();
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            if (this.firstTupleWritten) {
                this.writeComma();
            } else {
                this.firstTupleWritten = true;
            }
            this.openBraces();
            Iterator<Binding> bindingIter = bindingSet.iterator();
            while (bindingIter.hasNext()) {
                Binding binding = bindingIter.next();
                this.writeKeyValue(binding.getName(), binding.getValue());
                if (!bindingIter.hasNext()) continue;
                this.writeComma();
            }
            this.closeBraces();
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    private void writeKeyValue(String key, String value) throws IOException {
        this.writeKey(key);
        this.writeString(value);
    }

    private void writeKeyValue(String key, Value value) throws IOException, TupleQueryResultHandlerException {
        this.writeKey(key);
        this.writeValue(value);
    }

    private void writeKeyValue(String key, Iterable<String> array) throws IOException {
        this.writeKey(key);
        this.writeArray(array);
    }

    private void writeKey(String key) throws IOException {
        this.writeString(key);
        this.writer.write(": ");
    }

    private void writeValue(Value value) throws IOException, TupleQueryResultHandlerException {
        this.writer.write("{ ");
        if (value instanceof URI) {
            this.writeKeyValue("type", "uri");
            this.writer.write(", ");
            this.writeKeyValue("value", ((Object)((URI)value)).toString());
        } else if (value instanceof BNode) {
            this.writeKeyValue("type", "bnode");
            this.writer.write(", ");
            this.writeKeyValue("value", ((BNode)value).getID());
        } else if (value instanceof Literal) {
            Literal lit = (Literal)value;
            if (lit.getDatatype() != null) {
                this.writeKeyValue("type", "typed-literal");
                this.writer.write(", ");
                this.writeKeyValue("datatype", ((Object)lit.getDatatype()).toString());
            } else {
                this.writeKeyValue("type", "literal");
                if (lit.getLanguage() != null) {
                    this.writer.write(", ");
                    this.writeKeyValue("xml:lang", lit.getLanguage());
                }
            }
            this.writer.write(", ");
            this.writeKeyValue("value", lit.getLabel());
        } else {
            throw new TupleQueryResultHandlerException("Unknown Value object type: " + value.getClass());
        }
        this.writer.write(" }");
    }

    private void writeString(String value) throws IOException {
        value = StringUtil.gsub("\\", "\\\\", value);
        value = StringUtil.gsub("\"", "\\\"", value);
        value = StringUtil.gsub("/", "\\/", value);
        value = StringUtil.gsub("\b", "\\b", value);
        value = StringUtil.gsub("\f", "\\f", value);
        value = StringUtil.gsub("\n", "\\n", value);
        value = StringUtil.gsub("\r", "\\r", value);
        value = StringUtil.gsub("\t", "\\t", value);
        this.writer.write("\"");
        this.writer.write(value);
        this.writer.write("\"");
    }

    private void writeArray(Iterable<String> array) throws IOException {
        this.writer.write("[ ");
        Iterator<String> iter = array.iterator();
        while (iter.hasNext()) {
            String value = iter.next();
            this.writeString(value);
            if (!iter.hasNext()) continue;
            this.writer.write(", ");
        }
        this.writer.write(" ]");
    }

    private void openArray() throws IOException {
        this.writer.write("[");
        this.writer.writeEOL();
        this.writer.increaseIndentation();
    }

    private void closeArray() throws IOException {
        this.writer.writeEOL();
        this.writer.decreaseIndentation();
        this.writer.write("]");
    }

    private void openBraces() throws IOException {
        this.writer.write("{");
        this.writer.writeEOL();
        this.writer.increaseIndentation();
    }

    private void closeBraces() throws IOException {
        this.writer.writeEOL();
        this.writer.decreaseIndentation();
        this.writer.write("}");
    }

    private void writeComma() throws IOException {
        this.writer.write(", ");
        this.writer.writeEOL();
    }
}

