/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.algebra.Add;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.Clear;
import org.openrdf.query.algebra.Copy;
import org.openrdf.query.algebra.Create;
import org.openrdf.query.algebra.DeleteData;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.InsertData;
import org.openrdf.query.algebra.Load;
import org.openrdf.query.algebra.Modify;
import org.openrdf.query.algebra.Move;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;
import org.openrdf.query.parser.sparql.GraphPattern;
import org.openrdf.query.parser.sparql.TupleExprBuilder;
import org.openrdf.query.parser.sparql.ast.ASTAdd;
import org.openrdf.query.parser.sparql.ast.ASTClear;
import org.openrdf.query.parser.sparql.ast.ASTCopy;
import org.openrdf.query.parser.sparql.ast.ASTCreate;
import org.openrdf.query.parser.sparql.ast.ASTDeleteClause;
import org.openrdf.query.parser.sparql.ast.ASTDeleteData;
import org.openrdf.query.parser.sparql.ast.ASTDeleteWhere;
import org.openrdf.query.parser.sparql.ast.ASTDrop;
import org.openrdf.query.parser.sparql.ast.ASTGraphOrDefault;
import org.openrdf.query.parser.sparql.ast.ASTGraphPatternGroup;
import org.openrdf.query.parser.sparql.ast.ASTGraphRefAll;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTInsertClause;
import org.openrdf.query.parser.sparql.ast.ASTInsertData;
import org.openrdf.query.parser.sparql.ast.ASTLoad;
import org.openrdf.query.parser.sparql.ast.ASTModify;
import org.openrdf.query.parser.sparql.ast.ASTMove;
import org.openrdf.query.parser.sparql.ast.ASTQuadsNotTriples;
import org.openrdf.query.parser.sparql.ast.ASTUpdate;
import org.openrdf.query.parser.sparql.ast.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateExprBuilder
extends TupleExprBuilder {
    public UpdateExprBuilder(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public UpdateExpr visit(ASTUpdate node, Object data) throws VisitorException {
        if (node instanceof ASTModify) {
            return this.visit((ASTModify)node, data);
        }
        if (node instanceof ASTInsertData) {
            return this.visit((ASTInsertData)node, data);
        }
        return null;
    }

    @Override
    public InsertData visit(ASTInsertData node, Object data) throws VisitorException {
        QueryModelNodeBase result = new SingletonSet();
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContextVar());
        Object algebraExpr = node.jjtGetChild(0).jjtAccept(this, data);
        if (algebraExpr instanceof ValueExpr) {
            Var contextVar = this.valueExpr2Var((ValueExpr)algebraExpr);
            this.graphPattern.setContextVar(contextVar);
            this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        }
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        TupleExpr insertExpr = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        List<StatementPattern> statementPatterns = StatementPatternCollector.process(insertExpr);
        Set<Var> projectionVars = this.getProjectionVars(statementPatterns);
        HashMap<Var, ExtensionElem> extElemMap = new HashMap<Var, ExtensionElem>();
        for (Var var : projectionVars) {
            if (!var.isAnonymous() || extElemMap.containsKey(var)) continue;
            QueryModelNodeBase valueExpr = var.hasValue() ? new ValueConstant(var.getValue()) : new BNodeGenerator();
            extElemMap.put(var, new ExtensionElem((ValueExpr)((Object)valueExpr), var.getName()));
        }
        if (!extElemMap.isEmpty()) {
            result = new Extension((TupleExpr)((Object)result), extElemMap.values());
        }
        ArrayList<ProjectionElemList> projList = new ArrayList<ProjectionElemList>();
        for (StatementPattern sp : statementPatterns) {
            ProjectionElemList projElemList = new ProjectionElemList();
            projElemList.addElement(new ProjectionElem(sp.getSubjectVar().getName(), "subject"));
            projElemList.addElement(new ProjectionElem(sp.getPredicateVar().getName(), "predicate"));
            projElemList.addElement(new ProjectionElem(sp.getObjectVar().getName(), "object"));
            if (sp.getContextVar() != null) {
                projElemList.addElement(new ProjectionElem(sp.getContextVar().getName(), "context"));
            }
            projList.add(projElemList);
        }
        result = projList.size() == 1 ? new Projection((TupleExpr)((Object)result), (ProjectionElemList)projList.get(0)) : (projList.size() > 1 ? new MultiProjection((TupleExpr)((Object)result), (Iterable<ProjectionElemList>)projList) : new EmptySet());
        result = new Reduced((TupleExpr)((Object)result));
        return new InsertData((TupleExpr)((Object)result));
    }

    @Override
    public DeleteData visit(ASTDeleteData node, Object data) throws VisitorException {
        QueryModelNodeBase result = new SingletonSet();
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContextVar());
        Object algebraExpr = node.jjtGetChild(0).jjtAccept(this, data);
        if (algebraExpr instanceof ValueExpr) {
            Var contextVar = this.valueExpr2Var((ValueExpr)algebraExpr);
            this.graphPattern.setContextVar(contextVar);
            this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        }
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        TupleExpr deleteExpr = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        List<StatementPattern> statementPatterns = StatementPatternCollector.process(deleteExpr);
        Set<Var> projectionVars = this.getProjectionVars(statementPatterns);
        HashMap<Var, ExtensionElem> extElemMap = new HashMap<Var, ExtensionElem>();
        for (Var var : projectionVars) {
            if (!var.isAnonymous() || extElemMap.containsKey(var)) continue;
            QueryModelNodeBase valueExpr = var.hasValue() ? new ValueConstant(var.getValue()) : new BNodeGenerator();
            extElemMap.put(var, new ExtensionElem((ValueExpr)((Object)valueExpr), var.getName()));
        }
        if (!extElemMap.isEmpty()) {
            result = new Extension((TupleExpr)((Object)result), extElemMap.values());
        }
        ArrayList<ProjectionElemList> projList = new ArrayList<ProjectionElemList>();
        for (StatementPattern sp : statementPatterns) {
            ProjectionElemList projElemList = new ProjectionElemList();
            projElemList.addElement(new ProjectionElem(sp.getSubjectVar().getName(), "subject"));
            projElemList.addElement(new ProjectionElem(sp.getPredicateVar().getName(), "predicate"));
            projElemList.addElement(new ProjectionElem(sp.getObjectVar().getName(), "object"));
            if (sp.getContextVar() != null) {
                projElemList.addElement(new ProjectionElem(sp.getContextVar().getName(), "context"));
            }
            projList.add(projElemList);
        }
        result = projList.size() == 1 ? new Projection((TupleExpr)((Object)result), (ProjectionElemList)projList.get(0)) : (projList.size() > 1 ? new MultiProjection((TupleExpr)((Object)result), (Iterable<ProjectionElemList>)projList) : new EmptySet());
        result = new Reduced((TupleExpr)((Object)result));
        return new DeleteData((TupleExpr)((Object)result));
    }

    @Override
    public TupleExpr visit(ASTQuadsNotTriples node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        ValueExpr contextNode = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        Var contextVar = this.valueExpr2Var(contextNode);
        this.graphPattern.setContextVar(contextVar);
        this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        TupleExpr result = this.graphPattern.buildTupleExpr();
        parentGP.addRequiredTE(result);
        this.graphPattern = parentGP;
        return result;
    }

    @Override
    public Modify visit(ASTDeleteWhere node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContextVar());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        TupleExpr whereExpr = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        TupleExpr deleteExpr = whereExpr.clone();
        Modify modify = new Modify(deleteExpr, null, whereExpr);
        return modify;
    }

    @Override
    public Load visit(ASTLoad node, Object data) throws VisitorException {
        ValueConstant source = (ValueConstant)node.jjtGetChild(0).jjtAccept(this, data);
        Load load2 = new Load(source);
        load2.setSilent(node.isSilent());
        if (node.jjtGetNumChildren() > 1) {
            ValueConstant graph = (ValueConstant)node.jjtGetChild(1).jjtAccept(this, data);
            load2.setGraph(graph);
        }
        return load2;
    }

    @Override
    public Clear visit(ASTClear node, Object data) throws VisitorException {
        Clear clear = new Clear();
        clear.setSilent(node.isSilent());
        ASTGraphRefAll graphRef = node.jjtGetChild(ASTGraphRefAll.class);
        if (graphRef.jjtGetNumChildren() > 0) {
            ValueConstant graph = (ValueConstant)graphRef.jjtGetChild(0).jjtAccept(this, data);
            clear.setGraph(graph);
        } else if (graphRef.isDefault()) {
            clear.setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
        } else if (graphRef.isNamed()) {
            clear.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
        }
        return clear;
    }

    @Override
    public Clear visit(ASTDrop node, Object data) throws VisitorException {
        Clear clear = new Clear();
        clear.setSilent(node.isSilent());
        ASTGraphRefAll graphRef = node.jjtGetChild(ASTGraphRefAll.class);
        if (graphRef.jjtGetNumChildren() > 0) {
            ValueConstant graph = (ValueConstant)graphRef.jjtGetChild(0).jjtAccept(this, data);
            clear.setGraph(graph);
        } else if (graphRef.isDefault()) {
            clear.setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
        } else if (graphRef.isNamed()) {
            clear.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
        }
        return clear;
    }

    @Override
    public Create visit(ASTCreate node, Object data) throws VisitorException {
        ValueConstant graph = (ValueConstant)node.jjtGetChild(0).jjtAccept(this, data);
        Create create = new Create(graph);
        create.setSilent(node.isSilent());
        return create;
    }

    @Override
    public Copy visit(ASTCopy node, Object data) throws VisitorException {
        ASTGraphOrDefault destinationNode;
        Copy copy = new Copy();
        copy.setSilent(node.isSilent());
        ASTGraphOrDefault sourceNode = (ASTGraphOrDefault)node.jjtGetChild(0);
        if (sourceNode.jjtGetNumChildren() > 0) {
            ValueConstant sourceGraph = (ValueConstant)sourceNode.jjtGetChild(0).jjtAccept(this, data);
            copy.setSourceGraph(sourceGraph);
        }
        if ((destinationNode = (ASTGraphOrDefault)node.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ValueConstant destinationGraph = (ValueConstant)destinationNode.jjtGetChild(0).jjtAccept(this, data);
            copy.setDestinationGraph(destinationGraph);
        }
        return copy;
    }

    @Override
    public Move visit(ASTMove node, Object data) throws VisitorException {
        ASTGraphOrDefault destinationNode;
        Move move = new Move();
        move.setSilent(node.isSilent());
        ASTGraphOrDefault sourceNode = (ASTGraphOrDefault)node.jjtGetChild(0);
        if (sourceNode.jjtGetNumChildren() > 0) {
            ValueConstant sourceGraph = (ValueConstant)sourceNode.jjtGetChild(0).jjtAccept(this, data);
            move.setSourceGraph(sourceGraph);
        }
        if ((destinationNode = (ASTGraphOrDefault)node.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ValueConstant destinationGraph = (ValueConstant)destinationNode.jjtGetChild(0).jjtAccept(this, data);
            move.setDestinationGraph(destinationGraph);
        }
        return move;
    }

    @Override
    public Add visit(ASTAdd node, Object data) throws VisitorException {
        ASTGraphOrDefault destinationNode;
        Add add = new Add();
        add.setSilent(node.isSilent());
        ASTGraphOrDefault sourceNode = (ASTGraphOrDefault)node.jjtGetChild(0);
        if (sourceNode.jjtGetNumChildren() > 0) {
            ValueConstant sourceGraph = (ValueConstant)sourceNode.jjtGetChild(0).jjtAccept(this, data);
            add.setSourceGraph(sourceGraph);
        }
        if ((destinationNode = (ASTGraphOrDefault)node.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ValueConstant destinationGraph = (ValueConstant)destinationNode.jjtGetChild(0).jjtAccept(this, data);
            add.setDestinationGraph(destinationGraph);
        }
        return add;
    }

    @Override
    public Modify visit(ASTModify node, Object data) throws VisitorException {
        ValueConstant with = null;
        ASTIRI withNode = node.getWithClause();
        if (withNode != null) {
            with = (ValueConstant)withNode.jjtAccept(this, data);
        }
        if (with != null) {
            this.graphPattern.setContextVar(this.valueExpr2Var(with));
            this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        }
        ASTGraphPatternGroup whereClause = node.getWhereClause();
        TupleExpr where = null;
        if (whereClause != null) {
            where = (TupleExpr)whereClause.jjtAccept(this, data);
        }
        TupleExpr delete = null;
        ASTDeleteClause deleteNode = node.getDeleteClause();
        if (deleteNode != null) {
            delete = (TupleExpr)deleteNode.jjtAccept(this, data);
        }
        TupleExpr insert = null;
        ASTInsertClause insertNode = node.getInsertClause();
        if (insertNode != null) {
            insert = (TupleExpr)insertNode.jjtAccept(this, data);
        }
        Modify modifyExpr = new Modify(delete, insert, where);
        return modifyExpr;
    }

    @Override
    public TupleExpr visit(ASTDeleteClause node, Object data) throws VisitorException {
        TupleExpr result = (TupleExpr)data;
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContextVar());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        TupleExpr deleteExpr = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        return deleteExpr;
    }

    @Override
    public TupleExpr visit(ASTInsertClause node, Object data) throws VisitorException {
        TupleExpr result = (TupleExpr)data;
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContextVar());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        TupleExpr insertExpr = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        return insertExpr;
    }

    private Set<Var> getProjectionVars(Collection<StatementPattern> statementPatterns) {
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>(statementPatterns.size() * 2);
        for (StatementPattern sp : statementPatterns) {
            vars.add(sp.getSubjectVar());
            vars.add(sp.getPredicateVar());
            vars.add(sp.getObjectVar());
            if (sp.getContextVar() == null) continue;
            vars.add(sp.getContextVar());
        }
        return vars;
    }
}

