/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTOperationContainer;
import org.openrdf.query.parser.sparql.ast.ASTPrefixDecl;
import org.openrdf.query.parser.sparql.ast.ASTQName;
import org.openrdf.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.openrdf.query.parser.sparql.ast.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixDeclProcessor {
    public static Map<String, String> process(ASTOperationContainer qc) throws MalformedQueryException {
        List<ASTPrefixDecl> prefixDeclList = qc.getPrefixDeclList();
        LinkedHashMap<String, String> prefixMap = new LinkedHashMap<String, String>();
        for (ASTPrefixDecl prefixDecl : prefixDeclList) {
            String prefix = prefixDecl.getPrefix();
            String iri2 = prefixDecl.getIRI().getValue();
            if (prefixMap.containsKey(prefix)) {
                throw new MalformedQueryException("Multiple prefix declarations for prefix '" + prefix + "'");
            }
            prefixMap.put(prefix, iri2);
        }
        QNameProcessor visitor = new QNameProcessor(prefixMap);
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e2) {
            throw new MalformedQueryException(e2);
        }
        return prefixMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QNameProcessor
    extends ASTVisitorBase {
        private Map<String, String> prefixMap;

        public QNameProcessor(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap;
        }

        @Override
        public Object visit(ASTQName qnameNode, Object data) throws VisitorException {
            String qname = qnameNode.getValue();
            int colonIdx = qname.indexOf(58);
            assert (colonIdx >= 0) : "colonIdx should be >= 0: " + colonIdx;
            String prefix = qname.substring(0, colonIdx);
            String localName = qname.substring(colonIdx + 1);
            String namespace2 = this.prefixMap.get(prefix);
            if (namespace2 == null) {
                throw new VisitorException("QName '" + qname + "' uses an undefined prefix");
            }
            ASTIRI iriNode = new ASTIRI(43);
            iriNode.setValue(namespace2 + localName);
            qnameNode.jjtReplaceWith(iriNode);
            return null;
        }

        @Override
        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setPrefixDeclarations(this.prefixMap);
            return super.visit(node, data);
        }
    }
}

