/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetImpl
implements Dataset {
    protected Set<URI> defaultGraphs = new LinkedHashSet<URI>();
    protected Set<URI> namedGraphs = new LinkedHashSet<URI>();

    @Override
    public Set<URI> getDefaultGraphs() {
        return Collections.unmodifiableSet(this.defaultGraphs);
    }

    public void addDefaultGraph(URI graphURI) {
        this.defaultGraphs.add(graphURI);
    }

    public boolean removeDefaultGraph(URI graphURI) {
        return this.defaultGraphs.remove(graphURI);
    }

    @Override
    public Set<URI> getNamedGraphs() {
        return Collections.unmodifiableSet(this.namedGraphs);
    }

    public void addNamedGraph(URI graphURI) {
        this.namedGraphs.add(graphURI);
    }

    public boolean removeNamedGraph(URI graphURI) {
        return this.namedGraphs.remove(graphURI);
    }

    public void clear() {
        this.defaultGraphs.clear();
        this.namedGraphs.clear();
    }

    public String toString() {
        if (this.defaultGraphs.isEmpty() && this.namedGraphs.isEmpty()) {
            return "## empty dataset ##";
        }
        StringBuilder sb = new StringBuilder();
        for (URI uri : this.defaultGraphs) {
            sb.append("FROM ");
            this.appendURI(sb, uri);
        }
        for (URI uri : this.namedGraphs) {
            sb.append("FROM NAMED ");
            this.appendURI(sb, uri);
        }
        return sb.toString();
    }

    private void appendURI(StringBuilder sb, URI uri) {
        String str2 = ((Object)uri).toString();
        if (str2.length() > 50) {
            sb.append("<").append(str2, 0, 19).append("..");
            sb.append(str2, str2.length() - 29, str2.length()).append(">\n");
        } else {
            sb.append("<").append(uri).append(">\n");
        }
    }
}

