/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.Arrays;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.evaluation.iterator.ProjectionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiProjectionIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final List<ProjectionElemList> projections;
    private final CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private final BindingSet parentBindings;
    private final BindingSet[] previousBindings;
    private BindingSet currentBindings;
    private volatile int nextProjectionIdx;

    public MultiProjectionIterator(MultiProjection multiProjection, CloseableIteration<BindingSet, QueryEvaluationException> iter, BindingSet bindings2) {
        this.projections = multiProjection.getProjections();
        this.iter = iter;
        this.parentBindings = bindings2;
        this.previousBindings = new BindingSet[this.projections.size()];
        this.nextProjectionIdx = this.projections.size();
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        while (true) {
            int projIdx;
            if ((projIdx = this.nextProjectionIdx++) < this.projections.size()) {
                ProjectionElemList projection = this.projections.get(projIdx);
                BindingSet result = ProjectionIterator.project(projection, this.currentBindings, this.parentBindings);
                if (((Object)result).equals(this.previousBindings[projIdx])) continue;
                this.previousBindings[projIdx] = result;
                return result;
            }
            if (!this.iter.hasNext()) break;
            this.currentBindings = (BindingSet)this.iter.next();
            this.nextProjectionIdx = 0;
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        this.iter.close();
        this.nextProjectionIdx = this.projections.size();
        Arrays.fill(this.previousBindings, null);
    }
}

