/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class StrBefore
implements Function {
    public String getURI() {
        return ((Object)FN.SUBSTRING_BEFORE).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for STRBEFORE: " + args.length);
        }
        Value leftArg = args[0];
        Value rightArg = args[1];
        if (leftArg instanceof Literal && rightArg instanceof Literal) {
            Literal leftLit = (Literal)leftArg;
            Literal rightLit = (Literal)rightArg;
            String leftLanguage = leftLit.getLanguage();
            String rightLanguage = rightLit.getLanguage();
            URI leftDt = leftLit.getDatatype();
            URI rightDt = rightLit.getDatatype();
            if (!(leftLanguage == null && leftDt != null && !((Object)XMLSchema.STRING).equals(leftDt) || rightLanguage != null && !rightLanguage.equals(leftLanguage) || rightDt != null && !((Object)XMLSchema.STRING).equals(rightDt))) {
                String lexicalValue = leftLit.getLabel();
                String substring2 = rightLit.getLabel();
                int index = lexicalValue.indexOf(substring2);
                String substringBefore = "";
                if (index > -1) {
                    substringBefore = lexicalValue.substring(0, index);
                }
                if (leftLanguage != null) {
                    return valueFactory.createLiteral(substringBefore, leftLanguage);
                }
                if (leftDt != null) {
                    return valueFactory.createLiteral(substringBefore, leftDt);
                }
                return valueFactory.createLiteral(substringBefore);
            }
            throw new ValueExprEvaluationException("incompatible operands for STRBEFORE: " + leftArg + ", " + rightArg);
        }
        throw new ValueExprEvaluationException("incompatible operands for STRBEFORE: " + leftArg + ", " + rightArg);
    }
}

