/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import java.util.List;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceJoinConversionIteration
extends ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException> {
    protected final List<BindingSet> bindings;

    public ServiceJoinConversionIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, List<BindingSet> bindings2) {
        super(iter);
        this.bindings = bindings2;
    }

    @Override
    protected BindingSet convert(BindingSet bIn) throws QueryEvaluationException {
        QueryBindingSet res = new QueryBindingSet(bIn.size() + this.bindings.size());
        int bIndex = -1;
        for (Binding b : bIn) {
            String name = b.getName();
            if (name.equals("__rowIdx")) {
                bIndex = Integer.parseInt(b.getValue().stringValue());
                continue;
            }
            res.addBinding(b.getName(), b.getValue());
        }
        res.addAll(this.bindings.get(bIndex));
        return res;
    }
}

