/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.SingletonIteration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.ServiceFallbackIteration;
import org.openrdf.query.algebra.evaluation.federation.ServiceJoinConversionIteration;
import org.openrdf.query.algebra.evaluation.iterator.CollectionIteration;
import org.openrdf.query.algebra.evaluation.iterator.SilentIteration;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sparql.SPARQLRepository;
import org.openrdf.repository.sparql.query.InsertBindingSetCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLFederatedService
implements FederatedService {
    protected final SPARQLRepository rep;
    protected RepositoryConnection conn = null;

    public SPARQLFederatedService(String serviceUrl) {
        this.rep = new SPARQLRepository(serviceUrl);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(String sparqlQueryString, BindingSet bindings2, String baseUri, FederatedService.QueryType type, Service service) throws QueryEvaluationException {
        try {
            if (type == FederatedService.QueryType.SELECT) {
                TupleQuery query2 = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
                for (Binding b : bindings2) {
                    if (!service.getServiceVars().contains(b.getName())) continue;
                    query2.setBinding(b.getName(), b.getValue());
                }
                TupleQueryResult res = query2.evaluate();
                return new InsertBindingSetCursor(res, bindings2);
            }
            if (type == FederatedService.QueryType.ASK) {
                BooleanQuery query3 = this.getConnection().prepareBooleanQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
                for (Binding b : bindings2) {
                    if (!service.getServiceVars().contains(b.getName())) continue;
                    query3.setBinding(b.getName(), b.getValue());
                }
                boolean exists = query3.evaluate();
                if (exists) {
                    return new SingletonIteration<BindingSet, QueryEvaluationException>(bindings2);
                }
                return new EmptyIteration<BindingSet, QueryEvaluationException>();
            }
            throw new QueryEvaluationException("Unsupported QueryType: " + type.toString());
        }
        catch (MalformedQueryException e2) {
            throw new QueryEvaluationException(e2);
        }
        catch (RepositoryException e3) {
            throw new QueryEvaluationException("SPARQLRepository for endpoint " + this.rep.toString() + " could not be initialized.", e3);
        }
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings2, String baseUri) throws QueryEvaluationException {
        LinkedList<BindingSet> allBindings = new LinkedList<BindingSet>();
        while (bindings2.hasNext()) {
            allBindings.add((BindingSet)bindings2.next());
        }
        if (allBindings.size() == 0) {
            return new EmptyIteration<BindingSet, QueryEvaluationException>();
        }
        HashSet<String> projectionVars = new HashSet<String>(service.getServiceVars());
        projectionVars.removeAll(((BindingSet)allBindings.get(0)).getBindingNames());
        try {
            TupleQueryResult res;
            if (allBindings.size() == 1) {
                String queryString = service.getQueryString(projectionVars);
                SilentIteration result = this.evaluate(queryString, (BindingSet)allBindings.get(0), baseUri, FederatedService.QueryType.SELECT, service);
                result = service.isSilent() ? new SilentIteration(result) : result;
                return result;
            }
            projectionVars.add("__rowIdx");
            String queryString = service.getQueryString(projectionVars);
            queryString = queryString + this.buildBindingsClause(allBindings, service.getServiceVars());
            TupleQuery query2 = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, queryString, baseUri);
            try {
                res = query2.evaluate();
            }
            catch (QueryEvaluationException q) {
                String preparedQuery = service.getQueryString(projectionVars);
                ServiceFallbackIteration result = new ServiceFallbackIteration(service, preparedQuery, allBindings, this);
                result = service.isSilent() ? new SilentIteration(result) : result;
                return result;
            }
            ServiceJoinConversionIteration result = new ServiceJoinConversionIteration(res, allBindings);
            result = service.isSilent() ? new SilentIteration(result) : result;
            return result;
        }
        catch (RepositoryException e2) {
            if (service.isSilent()) {
                return new CollectionIteration<BindingSet, QueryEvaluationException>(allBindings);
            }
            throw new QueryEvaluationException("SPARQLRepository for endpoint " + this.rep.toString() + " could not be initialized.", e2);
        }
        catch (MalformedQueryException e3) {
            throw new QueryEvaluationException(e3);
        }
        catch (QueryEvaluationException e4) {
            if (service.isSilent()) {
                return new CollectionIteration<BindingSet, QueryEvaluationException>(allBindings);
            }
            throw e4;
        }
        catch (RuntimeException e5) {
            if (service.isSilent()) {
                return new CollectionIteration<BindingSet, QueryEvaluationException>(allBindings);
            }
            throw e5;
        }
    }

    @Override
    public void initialize() throws RepositoryException {
    }

    @Override
    public void shutdown() throws RepositoryException {
        if (this.conn != null) {
            this.conn.close();
        }
        this.rep.shutDown();
    }

    protected RepositoryConnection getConnection() throws RepositoryException {
        if (this.conn == null) {
            this.conn = this.rep.getConnection();
        }
        return this.conn;
    }

    protected String buildBindingsClause(List<BindingSet> bindings2, Set<String> serviceVars) throws QueryEvaluationException {
        ArrayList<String> relevantBindingNames = new ArrayList<String>(5);
        for (String bName : bindings2.get(0).getBindingNames()) {
            if (!serviceVars.contains(bName)) continue;
            relevantBindingNames.add(bName);
        }
        if (relevantBindingNames.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" BINDINGS ?__rowIdx");
        for (String bName : relevantBindingNames) {
            sb.append(" ?").append(bName);
        }
        sb.append(" { ");
        int rowIdx = 0;
        for (BindingSet b : bindings2) {
            sb.append(" (");
            sb.append("\"").append(rowIdx++).append("\" ");
            for (String bName : relevantBindingNames) {
                this.appendValueAsString(sb, b.getValue(bName)).append(" ");
            }
            sb.append(")");
        }
        sb.append(" }");
        return sb.toString();
    }

    protected StringBuilder appendValueAsString(StringBuilder sb, Value value) {
        if (value == null) {
            return sb.append("UNDEF");
        }
        if (value instanceof URI) {
            return SPARQLFederatedService.appendURI(sb, (URI)value);
        }
        if (value instanceof Literal) {
            return SPARQLFederatedService.appendLiteral(sb, (Literal)value);
        }
        throw new RuntimeException("Type not supported: " + value.getClass().getCanonicalName());
    }

    protected static StringBuilder appendURI(StringBuilder sb, URI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    protected static StringBuilder appendLiteral(StringBuilder sb, Literal lit) {
        sb.append('\"');
        sb.append(lit.getLabel().replace("\"", "\\\""));
        sb.append('\"');
        if (lit.getLanguage() != null) {
            sb.append('@');
            sb.append(lit.getLanguage());
        }
        if (lit.getDatatype() != null) {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }
}

