/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

public class URIUtil {
    public static int getLocalNameIndex(String uri) {
        int separatorIdx = uri.indexOf(35);
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(47);
        }
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(58);
        }
        if (separatorIdx < 0) {
            throw new IllegalArgumentException("No separator character founds in URI: " + uri);
        }
        return separatorIdx + 1;
    }

    public static boolean isCorrectURISplit(String namespace2, String localName) {
        assert (namespace2 != null) : "namespace must not be null";
        assert (localName != null) : "localName must not be null";
        if (namespace2.length() == 0) {
            return false;
        }
        int nsLength = namespace2.length();
        char lastNsChar = namespace2.charAt(nsLength - 1);
        if (lastNsChar == '#') {
            return namespace2.lastIndexOf(35, nsLength - 2) == -1;
        }
        if (lastNsChar == '/') {
            return localName.indexOf(47) == -1 && localName.indexOf(35) == -1 && namespace2.indexOf(35) == -1;
        }
        if (lastNsChar == ':') {
            return localName.indexOf(58) == -1 && localName.indexOf(35) == -1 && localName.indexOf(47) == -1 && namespace2.indexOf(35) == -1 && namespace2.indexOf(47) == -1;
        }
        return false;
    }
}

