/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryBase;

public class ValueFactoryImpl
extends ValueFactoryBase {
    private static final ValueFactoryImpl sharedInstance = new ValueFactoryImpl();

    public static ValueFactoryImpl getInstance() {
        return sharedInstance;
    }

    public URI createURI(String uri) {
        return new URIImpl(uri);
    }

    public URI createURI(String namespace2, String localName) {
        return this.createURI(namespace2 + localName);
    }

    public BNode createBNode(String nodeID) {
        return new BNodeImpl(nodeID);
    }

    public Literal createLiteral(String value) {
        return new LiteralImpl(value);
    }

    public Literal createLiteral(String value, String language) {
        return new LiteralImpl(value, language);
    }

    public Literal createLiteral(String value, URI datatype) {
        return new LiteralImpl(value, datatype);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object) {
        return new StatementImpl(subject, predicate, object);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object, Resource context) {
        return new ContextStatementImpl(subject, predicate, object, context);
    }
}

