/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.datatypes;

import info.aduna.text.ASCIIUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDateTime;
import org.openrdf.model.vocabulary.XMLSchema;

public class XMLDatatypeUtil {
    private static DatatypeFactory dtFactory;

    public static boolean isPrimitiveDatatype(URI datatype) {
        return ((Object)datatype).equals(XMLSchema.DURATION) || ((Object)datatype).equals(XMLSchema.DATETIME) || ((Object)datatype).equals(XMLSchema.TIME) || ((Object)datatype).equals(XMLSchema.DATE) || ((Object)datatype).equals(XMLSchema.GYEARMONTH) || ((Object)datatype).equals(XMLSchema.GYEAR) || ((Object)datatype).equals(XMLSchema.GMONTHDAY) || ((Object)datatype).equals(XMLSchema.GDAY) || ((Object)datatype).equals(XMLSchema.GMONTH) || ((Object)datatype).equals(XMLSchema.STRING) || ((Object)datatype).equals(XMLSchema.BOOLEAN) || ((Object)datatype).equals(XMLSchema.BASE64BINARY) || ((Object)datatype).equals(XMLSchema.HEXBINARY) || ((Object)datatype).equals(XMLSchema.FLOAT) || ((Object)datatype).equals(XMLSchema.DECIMAL) || ((Object)datatype).equals(XMLSchema.DOUBLE) || ((Object)datatype).equals(XMLSchema.ANYURI) || ((Object)datatype).equals(XMLSchema.QNAME) || ((Object)datatype).equals(XMLSchema.NOTATION);
    }

    public static boolean isDerivedDatatype(URI datatype) {
        return ((Object)datatype).equals(XMLSchema.NORMALIZEDSTRING) || ((Object)datatype).equals(XMLSchema.TOKEN) || ((Object)datatype).equals(XMLSchema.LANGUAGE) || ((Object)datatype).equals(XMLSchema.NMTOKEN) || ((Object)datatype).equals(XMLSchema.NMTOKENS) || ((Object)datatype).equals(XMLSchema.NAME) || ((Object)datatype).equals(XMLSchema.NCNAME) || ((Object)datatype).equals(XMLSchema.ID) || ((Object)datatype).equals(XMLSchema.IDREF) || ((Object)datatype).equals(XMLSchema.IDREFS) || ((Object)datatype).equals(XMLSchema.ENTITY) || ((Object)datatype).equals(XMLSchema.ENTITIES) || ((Object)datatype).equals(XMLSchema.INTEGER) || ((Object)datatype).equals(XMLSchema.LONG) || ((Object)datatype).equals(XMLSchema.INT) || ((Object)datatype).equals(XMLSchema.SHORT) || ((Object)datatype).equals(XMLSchema.BYTE) || ((Object)datatype).equals(XMLSchema.NON_POSITIVE_INTEGER) || ((Object)datatype).equals(XMLSchema.NEGATIVE_INTEGER) || ((Object)datatype).equals(XMLSchema.NON_NEGATIVE_INTEGER) || ((Object)datatype).equals(XMLSchema.POSITIVE_INTEGER) || ((Object)datatype).equals(XMLSchema.UNSIGNED_LONG) || ((Object)datatype).equals(XMLSchema.UNSIGNED_INT) || ((Object)datatype).equals(XMLSchema.UNSIGNED_SHORT) || ((Object)datatype).equals(XMLSchema.UNSIGNED_BYTE);
    }

    public static boolean isBuiltInDatatype(URI datatype) {
        return XMLDatatypeUtil.isPrimitiveDatatype(datatype) || XMLDatatypeUtil.isDerivedDatatype(datatype);
    }

    public static boolean isNumericDatatype(URI datatype) {
        return XMLDatatypeUtil.isDecimalDatatype(datatype) || XMLDatatypeUtil.isFloatingPointDatatype(datatype);
    }

    public static boolean isDecimalDatatype(URI datatype) {
        return ((Object)datatype).equals(XMLSchema.DECIMAL) || XMLDatatypeUtil.isIntegerDatatype(datatype);
    }

    public static boolean isIntegerDatatype(URI datatype) {
        return ((Object)datatype).equals(XMLSchema.INTEGER) || ((Object)datatype).equals(XMLSchema.LONG) || ((Object)datatype).equals(XMLSchema.INT) || ((Object)datatype).equals(XMLSchema.SHORT) || ((Object)datatype).equals(XMLSchema.BYTE) || ((Object)datatype).equals(XMLSchema.NON_POSITIVE_INTEGER) || ((Object)datatype).equals(XMLSchema.NEGATIVE_INTEGER) || ((Object)datatype).equals(XMLSchema.NON_NEGATIVE_INTEGER) || ((Object)datatype).equals(XMLSchema.POSITIVE_INTEGER) || ((Object)datatype).equals(XMLSchema.UNSIGNED_LONG) || ((Object)datatype).equals(XMLSchema.UNSIGNED_INT) || ((Object)datatype).equals(XMLSchema.UNSIGNED_SHORT) || ((Object)datatype).equals(XMLSchema.UNSIGNED_BYTE);
    }

    public static boolean isFloatingPointDatatype(URI datatype) {
        return ((Object)datatype).equals(XMLSchema.FLOAT) || ((Object)datatype).equals(XMLSchema.DOUBLE);
    }

    public static boolean isCalendarDatatype(URI datatype) {
        return ((Object)datatype).equals(XMLSchema.DATETIME) || ((Object)datatype).equals(XMLSchema.DATE) || ((Object)datatype).equals(XMLSchema.TIME) || ((Object)datatype).equals(XMLSchema.GYEARMONTH) || ((Object)datatype).equals(XMLSchema.GMONTHDAY) || ((Object)datatype).equals(XMLSchema.GYEAR) || ((Object)datatype).equals(XMLSchema.GMONTH) || ((Object)datatype).equals(XMLSchema.GDAY);
    }

    public static boolean isOrderedDatatype(URI datatype) {
        return XMLDatatypeUtil.isNumericDatatype(datatype) || XMLDatatypeUtil.isCalendarDatatype(datatype);
    }

    public static boolean isValidValue(String value, URI datatype) {
        boolean result = true;
        if (((Object)datatype).equals(XMLSchema.DECIMAL)) {
            result = XMLDatatypeUtil.isValidDecimal(value);
        } else if (((Object)datatype).equals(XMLSchema.INTEGER)) {
            result = XMLDatatypeUtil.isValidInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.NEGATIVE_INTEGER)) {
            result = XMLDatatypeUtil.isValidNegativeInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.NON_POSITIVE_INTEGER)) {
            result = XMLDatatypeUtil.isValidNonPositiveInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.NON_NEGATIVE_INTEGER)) {
            result = XMLDatatypeUtil.isValidNonNegativeInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.POSITIVE_INTEGER)) {
            result = XMLDatatypeUtil.isValidPositiveInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.LONG)) {
            result = XMLDatatypeUtil.isValidLong(value);
        } else if (((Object)datatype).equals(XMLSchema.INT)) {
            result = XMLDatatypeUtil.isValidInt(value);
        } else if (((Object)datatype).equals(XMLSchema.SHORT)) {
            result = XMLDatatypeUtil.isValidShort(value);
        } else if (((Object)datatype).equals(XMLSchema.BYTE)) {
            result = XMLDatatypeUtil.isValidByte(value);
        } else if (((Object)datatype).equals(XMLSchema.UNSIGNED_LONG)) {
            result = XMLDatatypeUtil.isValidUnsignedLong(value);
        } else if (((Object)datatype).equals(XMLSchema.UNSIGNED_INT)) {
            result = XMLDatatypeUtil.isValidUnsignedInt(value);
        } else if (((Object)datatype).equals(XMLSchema.UNSIGNED_SHORT)) {
            result = XMLDatatypeUtil.isValidUnsignedShort(value);
        } else if (((Object)datatype).equals(XMLSchema.UNSIGNED_BYTE)) {
            result = XMLDatatypeUtil.isValidUnsignedByte(value);
        } else if (((Object)datatype).equals(XMLSchema.FLOAT)) {
            result = XMLDatatypeUtil.isValidFloat(value);
        } else if (((Object)datatype).equals(XMLSchema.DOUBLE)) {
            result = XMLDatatypeUtil.isValidDouble(value);
        } else if (((Object)datatype).equals(XMLSchema.BOOLEAN)) {
            result = XMLDatatypeUtil.isValidBoolean(value);
        } else if (((Object)datatype).equals(XMLSchema.DATETIME)) {
            result = XMLDatatypeUtil.isValidDateTime(value);
        } else if (((Object)datatype).equals(XMLSchema.DATE)) {
            result = XMLDatatypeUtil.isValidDate(value);
        } else if (((Object)datatype).equals(XMLSchema.TIME)) {
            result = XMLDatatypeUtil.isValidTime(value);
        } else if (((Object)datatype).equals(XMLSchema.GDAY)) {
            result = XMLDatatypeUtil.isValidGDay(value);
        } else if (((Object)datatype).equals(XMLSchema.GMONTH)) {
            result = XMLDatatypeUtil.isValidGMonth(value);
        } else if (((Object)datatype).equals(XMLSchema.GMONTHDAY)) {
            result = XMLDatatypeUtil.isValidGMonthDay(value);
        } else if (((Object)datatype).equals(XMLSchema.GYEAR)) {
            result = XMLDatatypeUtil.isValidGYear(value);
        } else if (((Object)datatype).equals(XMLSchema.GYEARMONTH)) {
            result = XMLDatatypeUtil.isValidGYearMonth(value);
        } else if (((Object)datatype).equals(XMLSchema.DURATION)) {
            result = XMLDatatypeUtil.isValidDuration(value);
        } else if (((Object)datatype).equals(XMLSchema.DAYTIMEDURATION)) {
            result = XMLDatatypeUtil.isValidDayTimeDuration(value);
        } else if (((Object)datatype).equals(XMLSchema.QNAME)) {
            result = XMLDatatypeUtil.isValidQName(value);
        }
        return result;
    }

    public static boolean isValidDecimal(String value) {
        try {
            XMLDatatypeUtil.normalizeDecimal(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidInteger(String value) {
        try {
            XMLDatatypeUtil.normalizeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidNegativeInteger(String value) {
        try {
            XMLDatatypeUtil.normalizeNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidNonPositiveInteger(String value) {
        try {
            XMLDatatypeUtil.normalizeNonPositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidNonNegativeInteger(String value) {
        try {
            XMLDatatypeUtil.normalizeNonNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidPositiveInteger(String value) {
        try {
            XMLDatatypeUtil.normalizePositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidLong(String value) {
        try {
            XMLDatatypeUtil.normalizeLong(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidInt(String value) {
        try {
            XMLDatatypeUtil.normalizeInt(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidShort(String value) {
        try {
            XMLDatatypeUtil.normalizeShort(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidByte(String value) {
        try {
            XMLDatatypeUtil.normalizeByte(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidUnsignedLong(String value) {
        try {
            XMLDatatypeUtil.normalizeUnsignedLong(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidUnsignedInt(String value) {
        try {
            XMLDatatypeUtil.normalizeUnsignedInt(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidUnsignedShort(String value) {
        try {
            XMLDatatypeUtil.normalizeUnsignedShort(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidUnsignedByte(String value) {
        try {
            XMLDatatypeUtil.normalizeUnsignedByte(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidFloat(String value) {
        try {
            XMLDatatypeUtil.normalizeFloat(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidDouble(String value) {
        try {
            XMLDatatypeUtil.normalizeDouble(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidBoolean(String value) {
        try {
            XMLDatatypeUtil.normalizeBoolean(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidDuration(String value) {
        String regex = "-?P((\\d)+Y)?((\\d)+M)?((\\d)+D)?((T(\\d)+H((\\d)+M)?((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+M((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+(\\.(\\d)+)?S))?";
        return value.length() > 1 && value.matches(regex);
    }

    public static boolean isValidDayTimeDuration(String value) {
        String regex = "-?P((\\d)+D)?((T(\\d)+H((\\d)+M)?((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+M((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+(\\.(\\d)+)?S))?";
        return value.length() > 1 && value.matches(regex);
    }

    public static boolean isValidDateTime(String value) {
        try {
            XMLDateTime dt = new XMLDateTime(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static boolean isValidDate(String value) {
        String regex = "-?\\d\\d\\d\\d-\\d\\d-\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
        if (value.matches(regex)) {
            return XMLDatatypeUtil.isValidCalendarValue(value);
        }
        return false;
    }

    public static boolean isValidTime(String value) {
        String regex = "\\d\\d:\\d\\d:\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
        if (value.matches(regex)) {
            return XMLDatatypeUtil.isValidCalendarValue(value);
        }
        return false;
    }

    public static boolean isValidGDay(String value) {
        String regex = "---\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
        if (value.matches(regex)) {
            return XMLDatatypeUtil.isValidCalendarValue(value);
        }
        return false;
    }

    public static boolean isValidGMonth(String value) {
        String regex = "--\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
        if (value.matches(regex)) {
            return XMLDatatypeUtil.isValidCalendarValue(value);
        }
        return false;
    }

    public static boolean isValidGMonthDay(String value) {
        String regex = "--\\d\\d-\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
        if (value.matches(regex)) {
            return XMLDatatypeUtil.isValidCalendarValue(value);
        }
        return false;
    }

    public static boolean isValidGYear(String value) {
        String regex = "-?\\d\\d\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
        if (value.matches(regex)) {
            return XMLDatatypeUtil.isValidCalendarValue(value);
        }
        return false;
    }

    public static boolean isValidGYearMonth(String value) {
        String regex = "-?\\d\\d\\d\\d-\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
        if (value.matches(regex)) {
            return XMLDatatypeUtil.isValidCalendarValue(value);
        }
        return false;
    }

    public static boolean isValidQName(String value) {
        String name;
        String[] split = value.split(":", -2);
        if (split.length != 2) {
            return false;
        }
        String prefix = split[0];
        if (!"".equals(prefix)) {
            if (!XMLDatatypeUtil.isPrefixStartChar(prefix.charAt(0))) {
                return false;
            }
            for (int i = 1; i < prefix.length(); ++i) {
                if (XMLDatatypeUtil.isNameChar(prefix.charAt(i))) continue;
                return false;
            }
        }
        if (!"".equals(name = split[1])) {
            if (!XMLDatatypeUtil.isNameStartChar(name.charAt(0))) {
                return false;
            }
            for (int i = 1; i < name.length(); ++i) {
                if (XMLDatatypeUtil.isNameChar(name.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isPrefixStartChar(int c) {
        return ASCIIUtil.isLetter(c) || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    private static boolean isNameStartChar(int c) {
        return c == 95 || XMLDatatypeUtil.isPrefixStartChar(c);
    }

    private static boolean isNameChar(int c) {
        return XMLDatatypeUtil.isNameStartChar(c) || ASCIIUtil.isNumber(c) || c == 45 || c == 183 || c >= 768 && c <= 879 || c >= 8255 && c <= 8256;
    }

    private static boolean isValidCalendarValue(String value) {
        try {
            XMLDatatypeUtil.parseCalendar(value);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static String normalize(String value, URI datatype) {
        String result = value;
        if (((Object)datatype).equals(XMLSchema.DECIMAL)) {
            result = XMLDatatypeUtil.normalizeDecimal(value);
        } else if (((Object)datatype).equals(XMLSchema.INTEGER)) {
            result = XMLDatatypeUtil.normalizeInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.NEGATIVE_INTEGER)) {
            result = XMLDatatypeUtil.normalizeNegativeInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.NON_POSITIVE_INTEGER)) {
            result = XMLDatatypeUtil.normalizeNonPositiveInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.NON_NEGATIVE_INTEGER)) {
            result = XMLDatatypeUtil.normalizeNonNegativeInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.POSITIVE_INTEGER)) {
            result = XMLDatatypeUtil.normalizePositiveInteger(value);
        } else if (((Object)datatype).equals(XMLSchema.LONG)) {
            result = XMLDatatypeUtil.normalizeLong(value);
        } else if (((Object)datatype).equals(XMLSchema.INT)) {
            result = XMLDatatypeUtil.normalizeInt(value);
        } else if (((Object)datatype).equals(XMLSchema.SHORT)) {
            result = XMLDatatypeUtil.normalizeShort(value);
        } else if (((Object)datatype).equals(XMLSchema.BYTE)) {
            result = XMLDatatypeUtil.normalizeByte(value);
        } else if (((Object)datatype).equals(XMLSchema.UNSIGNED_LONG)) {
            result = XMLDatatypeUtil.normalizeUnsignedLong(value);
        } else if (((Object)datatype).equals(XMLSchema.UNSIGNED_INT)) {
            result = XMLDatatypeUtil.normalizeUnsignedInt(value);
        } else if (((Object)datatype).equals(XMLSchema.UNSIGNED_SHORT)) {
            result = XMLDatatypeUtil.normalizeUnsignedShort(value);
        } else if (((Object)datatype).equals(XMLSchema.UNSIGNED_BYTE)) {
            result = XMLDatatypeUtil.normalizeUnsignedByte(value);
        } else if (((Object)datatype).equals(XMLSchema.FLOAT)) {
            result = XMLDatatypeUtil.normalizeFloat(value);
        } else if (((Object)datatype).equals(XMLSchema.DOUBLE)) {
            result = XMLDatatypeUtil.normalizeDouble(value);
        } else if (((Object)datatype).equals(XMLSchema.BOOLEAN)) {
            result = XMLDatatypeUtil.normalizeBoolean(value);
        } else if (((Object)datatype).equals(XMLSchema.DATETIME)) {
            result = XMLDatatypeUtil.normalizeDateTime(value);
        }
        return result;
    }

    public static String normalizeBoolean(String value) {
        if ((value = XMLDatatypeUtil.collapseWhiteSpace(value)).equals("1")) {
            return "true";
        }
        if (value.equals("0")) {
            return "false";
        }
        if (value.equals("true") || value.equals("false")) {
            return value;
        }
        throw new IllegalArgumentException("Not a legal boolean value: " + value);
    }

    public static String normalizeDecimal(String decimal) {
        decimal = XMLDatatypeUtil.collapseWhiteSpace(decimal);
        int decLength = decimal.length();
        StringBuilder result = new StringBuilder(decLength + 2);
        if (decLength == 0) {
            XMLDatatypeUtil.throwIAE("Not a legal decimal: " + decimal);
        }
        boolean isZeroPointZero = true;
        int idx = 0;
        if (decimal.charAt(idx) == '-') {
            result.append('-');
            ++idx;
        } else if (decimal.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == decLength) {
            XMLDatatypeUtil.throwIAE("Not a legal decimal: " + decimal);
        }
        while (idx < decLength && decimal.charAt(idx) == '0') {
            ++idx;
        }
        if (idx == decLength) {
            result.append('0');
        } else if (idx < decLength && decimal.charAt(idx) == '.') {
            result.append('0');
        } else {
            char c;
            isZeroPointZero = false;
            while (idx < decLength && (c = decimal.charAt(idx)) != '.') {
                if (!XMLDatatypeUtil.isDigit(c)) {
                    XMLDatatypeUtil.throwIAE("Not a legal decimal: " + decimal);
                }
                result.append(c);
                ++idx;
            }
        }
        result.append('.');
        if (idx == decLength) {
            result.append('0');
        } else {
            int lastIdx;
            ++idx;
            for (lastIdx = decLength - 1; lastIdx >= 0 && decimal.charAt(lastIdx) == '0'; --lastIdx) {
            }
            if (idx > lastIdx) {
                result.append('0');
            } else {
                isZeroPointZero = false;
                while (idx <= lastIdx) {
                    char c = decimal.charAt(idx);
                    if (!XMLDatatypeUtil.isDigit(c)) {
                        XMLDatatypeUtil.throwIAE("Not a legal decimal: " + decimal);
                    }
                    result.append(c);
                    ++idx;
                }
            }
        }
        if (isZeroPointZero) {
            return "0.0";
        }
        return result.toString();
    }

    public static String normalizeInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, null, null);
    }

    public static String normalizeNegativeInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, null, "-1");
    }

    public static String normalizeNonPositiveInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, null, "0");
    }

    public static String normalizeNonNegativeInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", null);
    }

    public static String normalizePositiveInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "1", null);
    }

    public static String normalizeLong(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "-9223372036854775808", "9223372036854775807");
    }

    public static String normalizeInt(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "-2147483648", "2147483647");
    }

    public static String normalizeShort(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "-32768", "32767");
    }

    public static String normalizeByte(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "-128", "127");
    }

    public static String normalizeUnsignedLong(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", "18446744073709551615");
    }

    public static String normalizeUnsignedInt(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", "4294967295");
    }

    public static String normalizeUnsignedShort(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", "65535");
    }

    public static String normalizeUnsignedByte(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", "255");
    }

    private static String normalizeIntegerValue(String integer, String minValue, String maxValue) {
        int intLength = (integer = XMLDatatypeUtil.collapseWhiteSpace(integer)).length();
        if (intLength == 0) {
            XMLDatatypeUtil.throwIAE("Not a legal integer: " + integer);
        }
        int idx = 0;
        boolean isNegative = false;
        if (integer.charAt(idx) == '-') {
            isNegative = true;
            ++idx;
        } else if (integer.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == intLength) {
            XMLDatatypeUtil.throwIAE("Not a legal integer: " + integer);
        }
        if (integer.charAt(idx) == '0' && idx < intLength - 1) {
            ++idx;
            while (idx < intLength - 1 && integer.charAt(idx) == '0') {
                ++idx;
            }
        }
        String norm = integer.substring(idx);
        for (int i = 0; i < norm.length(); ++i) {
            if (XMLDatatypeUtil.isDigit(norm.charAt(i))) continue;
            XMLDatatypeUtil.throwIAE("Not a legal integer: " + integer);
        }
        if (isNegative && norm.charAt(0) != '0') {
            norm = "-" + norm;
        }
        if (minValue != null && XMLDatatypeUtil.compareCanonicalIntegers(norm, minValue) < 0) {
            XMLDatatypeUtil.throwIAE("Value smaller than minimum value");
        }
        if (maxValue != null && XMLDatatypeUtil.compareCanonicalIntegers(norm, maxValue) > 0) {
            XMLDatatypeUtil.throwIAE("Value larger than maximum value");
        }
        return norm;
    }

    public static String normalizeFloat(String value) {
        return XMLDatatypeUtil.normalizeFPNumber(value, "-16777215.0", "16777215.0", "-149", "104");
    }

    public static String normalizeDouble(String value) {
        return XMLDatatypeUtil.normalizeFPNumber(value, "-9007199254740991.0", "9007199254740991.0", "-1075", "970");
    }

    public static String normalizeFPNumber(String value) {
        return XMLDatatypeUtil.normalizeFPNumber(value, null, null, null, null);
    }

    private static String normalizeFPNumber(String value, String minMantissa, String maxMantissa, String minExponent, String maxExponent) {
        int dotIdx;
        String exponent;
        String mantissa;
        if ((value = XMLDatatypeUtil.collapseWhiteSpace(value)).equals("INF") || value.equals("-INF") || value.equals("NaN")) {
            return value;
        }
        int eIdx = value.indexOf(69);
        if (eIdx == -1) {
            eIdx = value.indexOf(101);
        }
        if (eIdx == -1) {
            mantissa = XMLDatatypeUtil.normalizeDecimal(value);
            exponent = "0";
        } else {
            mantissa = XMLDatatypeUtil.normalizeDecimal(value.substring(0, eIdx));
            exponent = XMLDatatypeUtil.normalizeInteger(value.substring(eIdx + 1));
        }
        if (minMantissa != null && XMLDatatypeUtil.compareCanonicalDecimals(mantissa, minMantissa) < 0) {
            XMLDatatypeUtil.throwIAE("Mantissa smaller than minimum value (" + minMantissa + ")");
        }
        if (maxMantissa != null && XMLDatatypeUtil.compareCanonicalDecimals(mantissa, maxMantissa) > 0) {
            XMLDatatypeUtil.throwIAE("Mantissa larger than maximum value (" + maxMantissa + ")");
        }
        if (minExponent != null && XMLDatatypeUtil.compareCanonicalIntegers(exponent, minExponent) < 0) {
            XMLDatatypeUtil.throwIAE("Exponent smaller than minimum value (" + minExponent + ")");
        }
        if (maxExponent != null && XMLDatatypeUtil.compareCanonicalIntegers(exponent, maxExponent) > 0) {
            XMLDatatypeUtil.throwIAE("Exponent larger than maximum value (" + maxExponent + ")");
        }
        int shift = 0;
        int digitCount = dotIdx = mantissa.indexOf(46);
        if (mantissa.charAt(0) == '-') {
            --digitCount;
        }
        if (digitCount > 1) {
            int nonZeroIdx;
            StringBuilder sb = new StringBuilder(mantissa.length());
            int firstDigitIdx = 0;
            if (mantissa.charAt(0) == '-') {
                sb.append('-');
                firstDigitIdx = 1;
            }
            sb.append(mantissa.charAt(firstDigitIdx));
            sb.append('.');
            sb.append(mantissa.substring(firstDigitIdx + 1, dotIdx));
            sb.append(mantissa.substring(dotIdx + 1));
            mantissa = sb.toString();
            for (nonZeroIdx = mantissa.length() - 1; nonZeroIdx >= 3 && mantissa.charAt(nonZeroIdx) == '0'; --nonZeroIdx) {
            }
            if (nonZeroIdx < 3 && mantissa.charAt(0) == '-') {
                ++nonZeroIdx;
            }
            if (nonZeroIdx < mantissa.length() - 1) {
                mantissa = mantissa.substring(0, nonZeroIdx + 1);
            }
            shift = 1 - digitCount;
        } else if (mantissa.startsWith("0.") || mantissa.startsWith("-0.")) {
            int nonZeroIdx;
            for (nonZeroIdx = 2; nonZeroIdx < mantissa.length() && mantissa.charAt(nonZeroIdx) == '0'; ++nonZeroIdx) {
            }
            if (nonZeroIdx < mantissa.length()) {
                StringBuilder sb = new StringBuilder(mantissa.length());
                sb.append(mantissa.charAt(nonZeroIdx));
                sb.append('.');
                if (nonZeroIdx == mantissa.length() - 1) {
                    sb.append('0');
                } else {
                    sb.append(mantissa.substring(nonZeroIdx + 1));
                }
                mantissa = sb.toString();
                shift = nonZeroIdx - 1;
            }
        }
        if (shift != 0) {
            try {
                int exp = Integer.parseInt(exponent);
                exponent = String.valueOf(exp - shift);
            }
            catch (NumberFormatException e2) {
                throw new RuntimeException("NumberFormatException: " + e2.getMessage());
            }
        }
        return mantissa + "E" + exponent;
    }

    public static String normalizeDateTime(String value) {
        XMLDateTime dt = new XMLDateTime(value);
        dt.normalize();
        return dt.toString();
    }

    public static String collapseWhiteSpace(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        StringTokenizer st = new StringTokenizer(s, "\t\r\n ");
        if (st.hasMoreTokens()) {
            sb.append(st.nextToken());
        }
        while (st.hasMoreTokens()) {
            sb.append(' ').append(st.nextToken());
        }
        return sb.toString();
    }

    public static int compare(String value1, String value2, URI datatype) {
        if (((Object)datatype).equals(XMLSchema.DECIMAL)) {
            return XMLDatatypeUtil.compareDecimals(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.INTEGER)) {
            return XMLDatatypeUtil.compareIntegers(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.NEGATIVE_INTEGER)) {
            return XMLDatatypeUtil.compareNegativeIntegers(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.NON_POSITIVE_INTEGER)) {
            return XMLDatatypeUtil.compareNonPositiveIntegers(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.NON_NEGATIVE_INTEGER)) {
            return XMLDatatypeUtil.compareNonNegativeIntegers(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.POSITIVE_INTEGER)) {
            return XMLDatatypeUtil.comparePositiveIntegers(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.LONG)) {
            return XMLDatatypeUtil.compareLongs(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.INT)) {
            return XMLDatatypeUtil.compareInts(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.SHORT)) {
            return XMLDatatypeUtil.compareShorts(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.BYTE)) {
            return XMLDatatypeUtil.compareBytes(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.UNSIGNED_LONG)) {
            return XMLDatatypeUtil.compareUnsignedLongs(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.UNSIGNED_INT)) {
            return XMLDatatypeUtil.compareUnsignedInts(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.UNSIGNED_SHORT)) {
            return XMLDatatypeUtil.compareUnsignedShorts(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.UNSIGNED_BYTE)) {
            return XMLDatatypeUtil.compareUnsignedBytes(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.FLOAT)) {
            return XMLDatatypeUtil.compareFloats(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.DOUBLE)) {
            return XMLDatatypeUtil.compareDoubles(value1, value2);
        }
        if (((Object)datatype).equals(XMLSchema.DATETIME)) {
            return XMLDatatypeUtil.compareDateTime(value1, value2);
        }
        throw new IllegalArgumentException("datatype is not ordered");
    }

    public static int compareDecimals(String dec1, String dec2) {
        dec1 = XMLDatatypeUtil.normalizeDecimal(dec1);
        dec2 = XMLDatatypeUtil.normalizeDecimal(dec2);
        return XMLDatatypeUtil.compareCanonicalDecimals(dec1, dec2);
    }

    public static int compareCanonicalDecimals(String dec1, String dec2) {
        int dotIdx2;
        if (dec1.equals(dec2)) {
            return 0;
        }
        if (dec1.charAt(0) == '-' && dec2.charAt(0) != '-') {
            return -1;
        }
        if (dec2.charAt(0) == '-' && dec1.charAt(0) != '-') {
            return 1;
        }
        int dotIdx1 = dec1.indexOf(46);
        int result = dotIdx1 - (dotIdx2 = dec2.indexOf(46));
        if (result == 0) {
            int dec2Length;
            for (int i = 0; result == 0 && i < dotIdx1; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            int dec1Length = dec1.length();
            int lastIdx = dec1Length <= (dec2Length = dec2.length()) ? dec1Length : dec2Length;
            for (int i = dotIdx1 + 1; result == 0 && i < lastIdx; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            if (result == 0) {
                result = dec1Length - dec2Length;
            }
        }
        if (dec1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    public static int compareIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeInteger(int1);
        int2 = XMLDatatypeUtil.normalizeInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareCanonicalIntegers(String int1, String int2) {
        if (int1.equals(int2)) {
            return 0;
        }
        if (int1.charAt(0) == '-' && int2.charAt(0) != '-') {
            return -1;
        }
        if (int2.charAt(0) == '-' && int1.charAt(0) != '-') {
            return 1;
        }
        int result = int1.length() - int2.length();
        if (result == 0) {
            for (int i = 0; result == 0 && i < int1.length(); ++i) {
                result = int1.charAt(i) - int2.charAt(i);
            }
        }
        if (int1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    public static int compareNegativeIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeNegativeInteger(int1);
        int2 = XMLDatatypeUtil.normalizeNegativeInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareNonPositiveIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeNonPositiveInteger(int1);
        int2 = XMLDatatypeUtil.normalizeNonPositiveInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareNonNegativeIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeNonNegativeInteger(int1);
        int2 = XMLDatatypeUtil.normalizeNonNegativeInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int comparePositiveIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizePositiveInteger(int1);
        int2 = XMLDatatypeUtil.normalizePositiveInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareLongs(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeLong(int1);
        int2 = XMLDatatypeUtil.normalizeLong(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareInts(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeInt(int1);
        int2 = XMLDatatypeUtil.normalizeInt(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareShorts(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeShort(int1);
        int2 = XMLDatatypeUtil.normalizeShort(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareBytes(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeByte(int1);
        int2 = XMLDatatypeUtil.normalizeByte(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedLongs(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeUnsignedLong(int1);
        int2 = XMLDatatypeUtil.normalizeUnsignedLong(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedInts(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeUnsignedInt(int1);
        int2 = XMLDatatypeUtil.normalizeUnsignedInt(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedShorts(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeUnsignedShort(int1);
        int2 = XMLDatatypeUtil.normalizeUnsignedShort(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedBytes(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeUnsignedByte(int1);
        int2 = XMLDatatypeUtil.normalizeUnsignedByte(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareFloats(String float1, String float2) {
        float1 = XMLDatatypeUtil.normalizeFloat(float1);
        float2 = XMLDatatypeUtil.normalizeFloat(float2);
        return XMLDatatypeUtil.compareCanonicalFloats(float1, float2);
    }

    public static int compareCanonicalFloats(String float1, String float2) {
        return XMLDatatypeUtil.compareCanonicalFPNumbers(float1, float2);
    }

    public static int compareDoubles(String double1, String double2) {
        double1 = XMLDatatypeUtil.normalizeDouble(double1);
        double2 = XMLDatatypeUtil.normalizeDouble(double2);
        return XMLDatatypeUtil.compareCanonicalDoubles(double1, double2);
    }

    public static int compareCanonicalDoubles(String double1, String double2) {
        return XMLDatatypeUtil.compareCanonicalFPNumbers(double1, double2);
    }

    public static int compareFPNumbers(String fp1, String fp2) {
        fp1 = XMLDatatypeUtil.normalizeFPNumber(fp1);
        fp2 = XMLDatatypeUtil.normalizeFPNumber(fp2);
        return XMLDatatypeUtil.compareCanonicalFPNumbers(fp1, fp2);
    }

    public static int compareCanonicalFPNumbers(String float1, String float2) {
        if (float1.equals("NaN") || float2.equals("NaN")) {
            if (float1.equals(float2)) {
                return 0;
            }
            XMLDatatypeUtil.throwIAE("NaN cannot be compared to other floats");
        }
        if (float1.equals("INF")) {
            return float2.equals("INF") ? 0 : 1;
        }
        if (float2.equals("INF")) {
            return -1;
        }
        if (float1.equals("-INF")) {
            return float2.equals("-INF") ? 0 : -1;
        }
        if (float2.equals("-INF")) {
            return 1;
        }
        if (float1.charAt(0) == '-' && float2.charAt(0) != '-') {
            return -1;
        }
        if (float2.charAt(0) == '-' && float1.charAt(0) != '-') {
            return 1;
        }
        int eIdx1 = float1.indexOf(69);
        String mantissa1 = float1.substring(0, eIdx1);
        String exponent1 = float1.substring(eIdx1 + 1);
        int eIdx2 = float2.indexOf(69);
        String mantissa2 = float2.substring(0, eIdx2);
        String exponent2 = float2.substring(eIdx2 + 1);
        int result = XMLDatatypeUtil.compareCanonicalIntegers(exponent1, exponent2);
        if (result != 0 && float1.charAt(0) == '-') {
            result = -result;
        }
        if (result == 0) {
            result = XMLDatatypeUtil.compareCanonicalDecimals(mantissa1, mantissa2);
        }
        return result;
    }

    public static int compareDateTime(String value1, String value2) {
        XMLDateTime dateTime1 = new XMLDateTime(value1);
        XMLDateTime dateTime2 = new XMLDateTime(value2);
        dateTime1.normalize();
        dateTime2.normalize();
        return dateTime1.compareTo(dateTime2);
    }

    public static boolean parseBoolean(String s) {
        return XMLDatatypeUtil.normalizeBoolean(s).equals("true");
    }

    public static byte parseByte(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Byte.parseByte(s);
    }

    public static short parseShort(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Short.parseShort(s);
    }

    public static int parseInt(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Integer.parseInt(s);
    }

    public static long parseLong(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Long.parseLong(s);
    }

    public static float parseFloat(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Float.parseFloat(s);
    }

    public static double parseDouble(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Double.parseDouble(s);
    }

    public static BigInteger parseInteger(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return new BigInteger(s);
    }

    public static BigDecimal parseDecimal(String s) {
        return new BigDecimal(s);
    }

    public static XMLGregorianCalendar parseCalendar(String s) {
        return dtFactory.newXMLGregorianCalendar(s);
    }

    private static String trimPlusSign(String s) {
        if (s.length() > 0 && s.charAt(0) == '+') {
            return s.substring(1);
        }
        return s;
    }

    public static URI qnameToURI(QName qname) {
        if (DatatypeConstants.DATETIME.equals(qname)) {
            return XMLSchema.DATETIME;
        }
        if (DatatypeConstants.DATE.equals(qname)) {
            return XMLSchema.DATE;
        }
        if (DatatypeConstants.TIME.equals(qname)) {
            return XMLSchema.TIME;
        }
        if (DatatypeConstants.GYEARMONTH.equals(qname)) {
            return XMLSchema.GYEARMONTH;
        }
        if (DatatypeConstants.GMONTHDAY.equals(qname)) {
            return XMLSchema.GMONTHDAY;
        }
        if (DatatypeConstants.GYEAR.equals(qname)) {
            return XMLSchema.GYEAR;
        }
        if (DatatypeConstants.GMONTH.equals(qname)) {
            return XMLSchema.GMONTH;
        }
        if (DatatypeConstants.GDAY.equals(qname)) {
            return XMLSchema.GDAY;
        }
        if (DatatypeConstants.DURATION.equals(qname)) {
            return XMLSchema.DURATION;
        }
        throw new IllegalArgumentException("QName cannot be mapped to an XML Schema URI: " + qname.toString());
    }

    private static final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static final void throwIAE(String msg) {
        throw new IllegalArgumentException(msg);
    }

    static {
        try {
            dtFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e2) {
            throw new RuntimeException(e2);
        }
    }
}

