/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository.contexts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.ProtocolUtil;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.http.server.repository.TupleQueryResultView;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.query.impl.ListBindingSet;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class ContextsController
extends AbstractController {
    public ContextsController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
        List<String> columnNames = Arrays.asList("contextID");
        ArrayList<ListBindingSet> contexts = new ArrayList<ListBindingSet>();
        try {
            RepositoryResult<Resource> contextIter = repositoryCon.getContextIDs();
            try {
                while (contextIter.hasNext()) {
                    ListBindingSet bindingSet = new ListBindingSet(columnNames, (Value)contextIter.next());
                    contexts.add(bindingSet);
                }
            }
            finally {
                contextIter.close();
            }
        }
        catch (RepositoryException e2) {
            throw new ServerHTTPException("Repository error: " + e2.getMessage(), (Throwable)e2);
        }
        TupleQueryResultWriterFactory factory = ProtocolUtil.getAcceptableService(request, response, TupleQueryResultWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("queryResult", new TupleQueryResultImpl(columnNames, contexts));
        model.put("filenameHint", "contexts");
        model.put("factory", factory);
        return new ModelAndView((View)TupleQueryResultView.getInstance(), model);
    }
}

