/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository;

import info.aduna.lang.service.FileFormatServiceRegistry;
import info.aduna.webapp.util.HttpServerUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.protocol.error.ErrorInfo;
import org.openrdf.http.protocol.error.ErrorType;
import org.openrdf.http.server.ClientHTTPException;
import org.openrdf.http.server.ProtocolUtil;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.BooleanQueryResultView;
import org.openrdf.http.server.repository.GraphQueryResultView;
import org.openrdf.http.server.repository.QueryResultView;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.http.server.repository.TupleQueryResultView;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.BooleanQueryResultWriterRegistry;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFWriterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class RepositoryController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public RepositoryController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "POST"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reqMethod;
        Repository repository = RepositoryInterceptor.getRepository(request);
        RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
        String queryStr = request.getParameter("query");
        int qryCode = 0;
        if (this.logger.isInfoEnabled() || this.logger.isDebugEnabled()) {
            qryCode = String.valueOf(queryStr).hashCode();
        }
        if ("GET".equals(reqMethod = request.getMethod())) {
            this.logger.info("GET query {}", qryCode);
        } else if ("POST".equals(reqMethod)) {
            this.logger.info("POST query {}", qryCode);
            String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
            if (!"application/x-www-form-urlencoded".equals(mimeType)) {
                throw new ClientHTTPException(415, "Unsupported MIME type: " + mimeType);
            }
        }
        this.logger.debug("query {} = {}", qryCode, (Object)queryStr);
        if (queryStr != null) {
            QueryResultView view;
            FileFormatServiceRegistry registry;
            Object queryResult;
            block12: {
                Query query2 = this.getQuery(repository, repositoryCon, queryStr, request, response);
                try {
                    if (query2 instanceof TupleQuery) {
                        TupleQuery tQuery = (TupleQuery)query2;
                        queryResult = tQuery.evaluate();
                        registry = TupleQueryResultWriterRegistry.getInstance();
                        view = TupleQueryResultView.getInstance();
                        break block12;
                    }
                    if (query2 instanceof GraphQuery) {
                        GraphQuery gQuery = (GraphQuery)query2;
                        queryResult = gQuery.evaluate();
                        registry = RDFWriterRegistry.getInstance();
                        view = GraphQueryResultView.getInstance();
                        break block12;
                    }
                    if (query2 instanceof BooleanQuery) {
                        BooleanQuery bQuery = (BooleanQuery)query2;
                        queryResult = bQuery.evaluate();
                        registry = BooleanQueryResultWriterRegistry.getInstance();
                        view = BooleanQueryResultView.getInstance();
                        break block12;
                    }
                    throw new ClientHTTPException(400, "Unsupported query type: " + query2.getClass().getName());
                }
                catch (QueryInterruptedException e2) {
                    this.logger.info("Query interrupted", e2);
                    throw new ServerHTTPException(503, "Query evaluation took too long");
                }
                catch (QueryEvaluationException e3) {
                    this.logger.info("Query evaluation error", e3);
                    throw new ServerHTTPException("Query evaluation error: " + e3.getMessage());
                }
            }
            TupleQueryResultWriterFactory factory = ProtocolUtil.getAcceptableService(request, response, registry);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("filenameHint", "query-result");
            model.put("queryResult", queryResult);
            model.put("factory", factory);
            return new ModelAndView((View)view, model);
        }
        throw new ClientHTTPException(400, "Missing parameter: query");
    }

    private Query getQuery(Repository repository, RepositoryConnection repositoryCon, String queryStr, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException {
        Query result = null;
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        String queryLnStr = request.getParameter("queryLn");
        this.logger.debug("query language param = {}", (Object)queryLnStr);
        if (queryLnStr != null && (queryLn = QueryLanguage.valueOf(queryLnStr)) == null) {
            throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
        }
        String baseURI = request.getParameter("baseURI");
        boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
        String timeout = request.getParameter("timeout");
        int maxQueryTime = 0;
        if (timeout != null) {
            try {
                maxQueryTime = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e2) {
                throw new ClientHTTPException(400, "Invalid timeout value: " + timeout);
            }
        }
        String[] defaultGraphURIs = request.getParameterValues("default-graph-uri");
        String[] namedGraphURIs = request.getParameterValues("named-graph-uri");
        DatasetImpl dataset = null;
        if (defaultGraphURIs != null || namedGraphURIs != null) {
            URI uri;
            dataset = new DatasetImpl();
            if (defaultGraphURIs != null) {
                for (String defaultGraphURI : defaultGraphURIs) {
                    try {
                        uri = repository.getValueFactory().createURI(defaultGraphURI);
                        dataset.addDefaultGraph(uri);
                    }
                    catch (IllegalArgumentException e3) {
                        throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                    }
                }
            }
            if (namedGraphURIs != null) {
                for (String namedGraphURI : namedGraphURIs) {
                    try {
                        uri = repository.getValueFactory().createURI(namedGraphURI);
                        dataset.addNamedGraph(uri);
                    }
                    catch (IllegalArgumentException e4) {
                        throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                    }
                }
            }
        }
        try {
            result = repositoryCon.prepareQuery(queryLn, queryStr, baseURI);
            result.setIncludeInferred(includeInferred);
            if (maxQueryTime > 0) {
                result.setMaxQueryTime(maxQueryTime);
            }
            if (dataset != null) {
                result.setDataset(dataset);
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, repository.getValueFactory());
                result.setBinding(bindingName, bindingValue);
            }
        }
        catch (UnsupportedQueryLanguageException e5) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.UNSUPPORTED_QUERY_LANGUAGE, queryLn.getName());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (MalformedQueryException e6) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, e6.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (RepositoryException e7) {
            this.logger.error("Repository error", e7);
            response.sendError(500);
        }
        return result;
    }
}

