/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server;

import info.aduna.lang.FileFormat;
import info.aduna.lang.service.FileFormatServiceRegistry;
import info.aduna.webapp.util.HttpServerUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.http.protocol.error.ErrorInfo;
import org.openrdf.http.protocol.error.ErrorType;
import org.openrdf.http.server.ClientHTTPException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolUtil {
    public static Value parseValueParam(HttpServletRequest request, String paramName, ValueFactory vf) throws ClientHTTPException {
        String paramValue = request.getParameter(paramName);
        try {
            return Protocol.decodeValue(paramValue, vf);
        }
        catch (IllegalArgumentException e2) {
            throw new ClientHTTPException(400, "Invalid value for parameter '" + paramName + "': " + paramValue);
        }
    }

    public static Resource parseResourceParam(HttpServletRequest request, String paramName, ValueFactory vf) throws ClientHTTPException {
        String paramValue = request.getParameter(paramName);
        try {
            return Protocol.decodeResource(paramValue, vf);
        }
        catch (IllegalArgumentException e2) {
            throw new ClientHTTPException(400, "Invalid value for parameter '" + paramName + "': " + paramValue);
        }
    }

    public static URI parseURIParam(HttpServletRequest request, String paramName, ValueFactory vf) throws ClientHTTPException {
        String paramValue = request.getParameter(paramName);
        try {
            return Protocol.decodeURI(paramValue, vf);
        }
        catch (IllegalArgumentException e2) {
            throw new ClientHTTPException(400, "Invalid value for parameter '" + paramName + "': " + paramValue);
        }
    }

    public static Resource[] parseContextParam(HttpServletRequest request, String paramName, ValueFactory vf) throws ClientHTTPException {
        String[] paramValues = request.getParameterValues(paramName);
        try {
            return Protocol.decodeContexts(paramValues, vf);
        }
        catch (IllegalArgumentException e2) {
            throw new ClientHTTPException(400, "Invalid value for parameter '" + paramName + "': " + e2.getMessage());
        }
    }

    public static boolean parseBooleanParam(HttpServletRequest request, String paramName, boolean defaultValue) {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(paramValue);
    }

    public static void logRequestParameters(HttpServletRequest request) {
        Logger logger = LoggerFactory.getLogger(ProtocolUtil.class);
        if (logger.isDebugEnabled()) {
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                for (String value : request.getParameterValues(name)) {
                    logger.debug("{}=\"{}\"", (Object)name, (Object)value);
                }
            }
        }
    }

    public static <FF extends FileFormat, S> S getAcceptableService(HttpServletRequest request, HttpServletResponse response, FileFormatServiceRegistry<FF, S> serviceRegistry) throws ClientHTTPException {
        FF format;
        boolean hasAcceptParam;
        String mimeType = request.getParameter("Accept");
        boolean bl = hasAcceptParam = mimeType != null;
        if (mimeType == null) {
            ProtocolUtil.logAcceptableFormats(request);
            ArrayList<String> mimeTypes = new ArrayList<String>(16);
            for (FileFormat format2 : serviceRegistry.getKeys()) {
                mimeTypes.addAll(format2.getMIMETypes());
            }
            mimeType = HttpServerUtil.selectPreferredMIMEType(mimeTypes.iterator(), request);
            response.setHeader("Vary", "Accept");
        }
        if (mimeType != null && (format = serviceRegistry.getFileFormatForMIMEType(mimeType)) != null) {
            return serviceRegistry.get(format);
        }
        if (hasAcceptParam) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.UNSUPPORTED_FILE_FORMAT, mimeType);
            throw new ClientHTTPException(400, errInfo.toString());
        }
        throw new ClientHTTPException(406, "No acceptable file format found.");
    }

    public static void logAcceptableFormats(HttpServletRequest request) {
        Logger logger = LoggerFactory.getLogger(ProtocolUtil.class);
        if (logger.isDebugEnabled()) {
            StringBuilder acceptable = new StringBuilder(64);
            Enumeration acceptHeaders = request.getHeaders("Accept");
            while (acceptHeaders.hasMoreElements()) {
                acceptable.append((String)acceptHeaders.nextElement());
                if (!acceptHeaders.hasMoreElements()) continue;
                acceptable.append(',');
            }
            logger.debug("Acceptable formats: " + acceptable);
        }
    }
}

