/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.tokens;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerText;

public class TokenizerFactory {
    public static Tokenizer makeTokenizer(Reader reader) {
        PeekReader peekReader = PeekReader.make(reader);
        TokenizerText tokenizer = new TokenizerText(peekReader);
        return tokenizer;
    }

    public static Tokenizer makeTokenizerUTF8(InputStream in) {
        PeekReader peekReader = PeekReader.makeUTF8(in);
        TokenizerText tokenizer = new TokenizerText(peekReader);
        return tokenizer;
    }

    public static Tokenizer makeTokenizerASCII(InputStream in) {
        PeekReader peekReader = PeekReader.makeASCII(in);
        TokenizerText tokenizer = new TokenizerText(peekReader);
        return tokenizer;
    }

    public static Tokenizer makeTokenizerASCII(String string) {
        byte[] b = StrUtils.asUTF8bytes(string);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        return TokenizerFactory.makeTokenizerASCII(in);
    }

    public static Tokenizer makeTokenizerString(String str2) {
        PeekReader peekReader = PeekReader.readString(str2);
        TokenizerText tokenizer = new TokenizerText(peekReader);
        return tokenizer;
    }
}

