/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.impl.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.Lang;
import org.openjena.riot.checker.CheckerLiterals;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.system.RiotLib;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LangRDFXML
implements LangRIOT {
    private ARP arp = new ARP();
    private long count = 0L;
    private InputStream input = null;
    private String xmlBase;
    private String filename;
    private Sink<Triple> sink;
    private ParserProfile profile;

    @Override
    public ParserProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    public static LangRDFXML create(InputStream in, String xmlBase, String filename, ErrorHandler errorHandler, Sink<Triple> sink) {
        return new LangRDFXML(in, xmlBase, filename, errorHandler, sink);
    }

    public static LangRDFXML create(String xmlBase, String filename, ErrorHandler errorHandler, Sink<Triple> sink) {
        return LangRDFXML.create(IO.openFile(filename), xmlBase, filename, errorHandler, sink);
    }

    private LangRDFXML(InputStream in, String xmlBase, String filename, ErrorHandler errorHandler, Sink<Triple> sink) {
        this.input = in;
        this.xmlBase = xmlBase;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), xmlBase, errorHandler);
    }

    @Override
    public Lang getLang() {
        return Lang.RDFXML;
    }

    @Override
    public void parse() {
        this.count = 0L;
        HandlerSink rslt = new HandlerSink(this.sink, this.getProfile().getHandler());
        this.arp.getHandlers().setStatementHandler(rslt);
        this.arp.getHandlers().setErrorHandler(rslt);
        this.arp.getHandlers().setNamespaceHandler(rslt);
        try {
            this.arp.load(this.input, this.xmlBase);
        }
        catch (IOException e2) {
            this.getProfile().getHandler().error(this.filename + ": " + ParseException.formatMessage(e2), -1L, -1L);
        }
        catch (SAXParseException e3) {
        }
        catch (SAXException sax) {
            this.getProfile().getHandler().error(this.filename + ": " + ParseException.formatMessage(sax), -1L, -1L);
        }
        this.sink.flush();
    }

    private static class ErrorHandlerBridge
    implements RDFErrorHandler {
        private ErrorHandler errorHandler;

        ErrorHandlerBridge(ErrorHandler hander) {
            this.errorHandler = hander;
        }

        @Override
        public void warning(Exception e2) {
            this.errorHandler.warning(e2.getMessage(), -1L, -1L);
        }

        @Override
        public void error(Exception e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
        }

        @Override
        public void fatalError(Exception e2) {
            this.errorHandler.fatal(e2.getMessage(), -1L, -1L);
        }
    }

    private static class HandlerSink
    extends ARPSaxErrorHandler
    implements StatementHandler,
    NamespaceHandler {
        private Sink<Triple> sink;
        private ErrorHandler errHandler;
        private CheckerLiterals checker;

        HandlerSink(Sink<Triple> sink, ErrorHandler errHandler) {
            super(new ErrorHandlerBridge(errHandler));
            this.sink = sink;
            this.errHandler = errHandler;
            this.checker = new CheckerLiterals(errHandler);
        }

        @Override
        public void statement(AResource subj, AResource pred, AResource obj) {
            this.sink.send(this.convert(subj, pred, obj));
        }

        @Override
        public void statement(AResource subj, AResource pred, ALiteral lit) {
            this.sink.send(this.convert(subj, pred, lit));
        }

        private static Node convert(ALiteral lit) {
            String dtURI = lit.getDatatypeURI();
            if (dtURI == null) {
                return Node.createLiteral(((Object)lit).toString(), lit.getLang(), false);
            }
            if (lit.isWellFormedXML()) {
                return Node.createLiteral(((Object)lit).toString(), null, true);
            }
            RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
            return Node.createLiteral(((Object)lit).toString(), null, dt);
        }

        private static Node convert(AResource r) {
            if (!r.isAnonymous()) {
                return Node.createURI(r.getURI());
            }
            Node rr = (Node)r.getUserData();
            if (rr == null) {
                rr = Node.createAnon();
                r.setUserData(rr);
            }
            return rr;
        }

        private Triple convert(AResource s, AResource p, AResource o) {
            return Triple.create(HandlerSink.convert(s), HandlerSink.convert(p), HandlerSink.convert(o));
        }

        private Triple convert(AResource s, AResource p, ALiteral o) {
            Node object = HandlerSink.convert(o);
            this.checker.check(object, -1L, -1L);
            return Triple.create(HandlerSink.convert(s), HandlerSink.convert(p), object);
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }
    }
}

