/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.lang.LangNTuple;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LangNTriples
extends LangNTuple<Triple> {
    private static Logger messageLog = LoggerFactory.getLogger("N-Triples");

    public LangNTriples(Tokenizer tokens2, ParserProfile profile, Sink<Triple> sink) {
        super(tokens2, profile, sink);
    }

    @Override
    public Lang getLang() {
        return Lang.NTRIPLES;
    }

    @Override
    protected final Triple parseOne() {
        Token oToken;
        Token pToken;
        Token sToken = this.nextToken();
        if (sToken.isEOF()) {
            this.exception(sToken, "Premature end of file: %s", sToken);
        }
        if ((pToken = this.nextToken()).isEOF()) {
            this.exception(pToken, "Premature end of file: %s", pToken);
        }
        if ((oToken = this.nextToken()).isEOF()) {
            this.exception(oToken, "Premature end of file: %s", oToken);
        }
        this.checkIRIOrBNode(sToken);
        this.checkIRI(pToken);
        this.checkRDFTerm(oToken);
        Token x = this.nextToken();
        if (x.getType() != TokenType.DOT) {
            this.exception(x, "Triple not terminated by DOT: %s", x);
        }
        Node s = this.tokenAsNode(sToken);
        Node p = this.tokenAsNode(pToken);
        Node o = this.tokenAsNode(oToken);
        return this.profile.createTriple(s, p, o, sToken.getLine(), sToken.getColumn());
    }

    @Override
    protected final Node tokenAsNode(Token token) {
        return this.profile.create(null, token);
    }
}

