/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib.cache;

import java.util.concurrent.atomic.AtomicLong;
import org.openjena.atlas.lib.ActionKeyValue;
import org.openjena.atlas.lib.Cache;
import org.openjena.atlas.lib.CacheStats;
import org.openjena.atlas.lib.cache.CacheWrapper;

public class CacheStatsAtomic<Key, Value>
extends CacheWrapper<Key, Value>
implements CacheStats<Key, Value> {
    private final AtomicLong cacheEntries = new AtomicLong(0L);
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    private final AtomicLong cacheEjects = new AtomicLong(0L);

    public CacheStatsAtomic(Cache<Key, Value> cache) {
        super(cache);
        cache.setDropHandler(new EjectMonitor(null));
    }

    @Override
    public Value get(Key key) {
        Object x = this.cache.get(key);
        if (x == null) {
            this.cacheMisses.getAndIncrement();
        } else {
            this.cacheHits.getAndIncrement();
        }
        return x;
    }

    @Override
    public Value put(Key key, Value t) {
        Value v = this.cache.put(key, t);
        if (v == null) {
            this.cacheEntries.getAndIncrement();
        }
        return v;
    }

    @Override
    public boolean remove(Key key) {
        boolean b = this.cache.remove(key);
        if (b) {
            this.cacheEntries.getAndDecrement();
        }
        return b;
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.cacheEntries.set(0L);
    }

    @Override
    public void setDropHandler(ActionKeyValue<Key, Value> dropHandler) {
        this.cache.setDropHandler(new EjectMonitor(dropHandler));
    }

    @Override
    public final long getCacheEntries() {
        return this.cacheEntries.get();
    }

    @Override
    public final long getCacheHits() {
        return this.cacheHits.get();
    }

    @Override
    public final long getCacheMisses() {
        return this.cacheMisses.get();
    }

    @Override
    public final long getCacheEjects() {
        return this.cacheEjects.get();
    }

    private class EjectMonitor
    implements ActionKeyValue<Key, Value> {
        private ActionKeyValue<Key, Value> other;

        EjectMonitor(ActionKeyValue<Key, Value> other) {
            this.other = other;
        }

        @Override
        public void apply(Key key, Value thing) {
            CacheStatsAtomic.this.cacheEjects.getAndIncrement();
            if (this.other != null) {
                this.other.apply(key, thing);
            }
        }
    }
}

