/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import org.openjena.atlas.AtlasException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    private static Logger log = LoggerFactory.getLogger(SystemUtils.class.getName());
    private static boolean logging = false;

    public static ClassLoader chooseClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (logging && classLoader != null) {
            log.trace("Using thread classloader");
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
            if (logging && classLoader != null) {
                log.trace("Using system classloader");
            }
        }
        if (classLoader == null) {
            throw new AtlasException("Failed to find a classloader");
        }
        return classLoader;
    }
}

