/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.plugin.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.Compare;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.CompareResultListener;

public class ComparePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField endpointsTextField = null;
    private JButton endpointsButton = null;
    private JTextField wordsTextField = null;
    private JButton wordsButton = null;
    private JScrollPane logScrollPane = null;
    private JTextArea logTextArea = null;
    private JLabel endpointsLabel = null;
    private JLabel wordsLabel = null;
    private JButton executeButton = null;
    private JPanel optPanel = null;
    private JPanel matchPanel = null;
    private JRadioButton matchFullRadioButton = null;
    private JRadioButton matchPartRadioButton = null;
    private JRadioButton findSubjectRadioButton = null;
    private JRadioButton findObjectRadioButton = null;
    private JRadioButton findLabelObjectRadioButton = null;
    private JSeparator separator = null;
    private JLabel outputLabel = null;
    private JTextField outputTextField = null;
    private JButton outputRefButton = null;
    private Component parent;
    Compare compare = null;

    public ComparePanel(Component parent) {
        this.initialize();
        this.parent = parent;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
        gridBagConstraints111.gridx = 2;
        gridBagConstraints111.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints111.gridy = 3;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.gridy = 3;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints10.gridx = 1;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 3;
        this.outputLabel = new JLabel("Output File");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridwidth = 3;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.gridy = 4;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints5.gridy = 2;
        this.wordsLabel = new JLabel();
        this.wordsLabel.setText("Word List File");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints4.gridy = 0;
        this.endpointsLabel = new JLabel();
        this.endpointsLabel.setText("Endpoint List File");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.gridx = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridy = 2;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints11.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.gridx = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(14, 10, 5, 0);
        gridBagConstraints.gridx = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getEndpointsTextField(), gridBagConstraints);
        this.add((Component)this.getEndpointsButton(), gridBagConstraints1);
        this.add((Component)this.getWordsTextField(), gridBagConstraints11);
        this.add((Component)this.getWordsButton(), gridBagConstraints2);
        this.add((Component)this.getLogScrollPane(), gridBagConstraints3);
        this.add((Component)this.endpointsLabel, gridBagConstraints4);
        this.add((Component)this.wordsLabel, gridBagConstraints5);
        this.add((Component)this.getOptPanel(), gridBagConstraints8);
        this.add((Component)this.outputLabel, gridBagConstraints9);
        this.add((Component)this.getOutputTextField(), gridBagConstraints10);
        this.add((Component)this.getOutputRefButton(), gridBagConstraints111);
    }

    private JTextField getEndpointsTextField() {
        if (this.endpointsTextField == null) {
            this.endpointsTextField = new JTextField();
            this.endpointsTextField.setEditable(false);
        }
        return this.endpointsTextField;
    }

    private JButton getEndpointsButton() {
        if (this.endpointsButton == null) {
            this.endpointsButton = new JButton("Ref");
            this.endpointsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ComparePanel.this.selectFile(ComparePanel.this.getEndpointsTextField(), 0);
                    ComparePanel.this.validateExecute();
                }
            });
        }
        return this.endpointsButton;
    }

    private JTextField getWordsTextField() {
        if (this.wordsTextField == null) {
            this.wordsTextField = new JTextField();
            this.wordsTextField.setEditable(false);
        }
        return this.wordsTextField;
    }

    private JButton getWordsButton() {
        if (this.wordsButton == null) {
            this.wordsButton = new JButton("Ref");
            this.wordsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ComparePanel.this.selectFile(ComparePanel.this.getWordsTextField(), 0);
                    ComparePanel.this.validateExecute();
                }
            });
        }
        return this.wordsButton;
    }

    private JScrollPane getLogScrollPane() {
        if (this.logScrollPane == null) {
            this.logScrollPane = new JScrollPane();
            this.logScrollPane.setViewportView(this.getLogTextArea());
        }
        return this.logScrollPane;
    }

    private JTextArea getLogTextArea() {
        if (this.logTextArea == null) {
            this.logTextArea = new JTextArea();
            this.logTextArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                }

                @Override
                public void insertUpdate(DocumentEvent e2) {
                    final Document doc = ComparePanel.this.logTextArea.getDocument();
                    final Element root = doc.getDefaultRootElement();
                    if (root.getElementCount() <= 100) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.removeLines(doc, root);
                        }
                    });
                    ComparePanel.this.logTextArea.setCaretPosition(doc.getLength());
                }

                private void removeLines(Document doc, Element root) {
                    Element fl = root.getElement(0);
                    try {
                        doc.remove(0, fl.getEndOffset());
                    }
                    catch (BadLocationException ble) {
                        System.out.println(ble);
                    }
                }
            });
        }
        return this.logTextArea;
    }

    void addLogText(String log) {
        String[] logs;
        String[] stringArray = logs = log.split("\n");
        int n = logs.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            this.getLogTextArea().append(l);
            ++n2;
        }
        if (log.endsWith("\n")) {
            this.getLogTextArea().append("\n");
        }
        this.getLogTextArea().setCaretPosition(this.getLogTextArea().getDocument().getLength());
    }

    private JButton getExecuteButton() {
        if (this.executeButton == null) {
            this.executeButton = new JButton("Execute");
            this.executeButton.setEnabled(false);
            this.executeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (ComparePanel.this.getExecuteButton().getText().equals("Execute")) {
                        ComparePanel.this.setProcessing(true);
                        ComparePanel.this.doCompare();
                    } else {
                        ComparePanel.this.executeButton.setEnabled(false);
                        ComparePanel.this.doStop();
                    }
                }
            });
        }
        return this.executeButton;
    }

    private JPanel getOptPanel() {
        if (this.optPanel == null) {
            this.optPanel = new JPanel();
            this.optPanel.setLayout(new BorderLayout());
            this.optPanel.add((Component)this.getExecuteButton(), "East");
            this.optPanel.add((Component)this.getMatchPanel(), "Center");
        }
        return this.optPanel;
    }

    private JPanel getMatchPanel() {
        if (this.matchPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setVgap(0);
            this.matchPanel = new JPanel();
            this.matchPanel.setLayout(flowLayout);
            this.matchPanel.add((Component)this.getMatchFullRadioButton(), null);
            this.matchPanel.add((Component)this.getMatchPartRadioButton(), null);
            this.matchPanel.add((Component)this.getSeparator(), null);
            this.matchPanel.add((Component)this.getFindSubjectRadioButton(), null);
            this.matchPanel.add((Component)this.getFindObjectRadioButton(), null);
            this.matchPanel.add((Component)this.getFindLabelObjectRadioButton(), null);
            ButtonGroup gp1 = new ButtonGroup();
            gp1.add(this.getMatchFullRadioButton());
            gp1.add(this.getMatchPartRadioButton());
            this.getMatchFullRadioButton().setSelected(true);
            ButtonGroup gp2 = new ButtonGroup();
            gp2.add(this.getFindSubjectRadioButton());
            gp2.add(this.getFindObjectRadioButton());
            gp2.add(this.getFindLabelObjectRadioButton());
            this.getFindSubjectRadioButton().setSelected(true);
        }
        return this.matchPanel;
    }

    private int getFindType() {
        if (this.getFindSubjectRadioButton().isSelected()) {
            return 1;
        }
        if (this.getFindObjectRadioButton().isSelected()) {
            return 2;
        }
        if (this.getFindLabelObjectRadioButton().isSelected()) {
            return 3;
        }
        return 0;
    }

    private boolean isFullMatch() {
        return this.getMatchFullRadioButton().isSelected();
    }

    private void selectFile(JTextField tf, int dialogType) {
        JFileChooser fileChooser = new JFileChooser("./");
        fileChooser.setDialogType(dialogType);
        int result = fileChooser.showOpenDialog(this);
        File file = fileChooser.getSelectedFile();
        if (result == 1 || file == null) {
            return;
        }
        try {
            tf.setText(file.getCanonicalPath());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void validateExecute() {
        boolean enable = true;
        if (this.getEndpointsTextField().getText().isEmpty() || this.getWordsTextField().getText().isEmpty() || this.getOutputTextField().getText().isEmpty()) {
            enable = false;
        }
        this.getExecuteButton().setEnabled(enable);
    }

    private void doCompare() {
        this.compare = new Compare(new File(this.getWordsTextField().getText()), new File(this.getEndpointsTextField().getText()), new SparqlQueryListener(){

            @Override
            public void sparqlExecuted(String query2) {
                ComparePanel.this.addLogText(query2);
            }
        });
        this.compare.outputResult(this.getFindType(), this.isFullMatch(), new File(this.getOutputTextField().getText()), new CompareResultListener(){

            @Override
            public void uncaughtException(Thread thread, Throwable e2) {
                JOptionPane.showMessageDialog(ComparePanel.this.parent, "Execute error:" + e2.getMessage(), "Error", 0);
                ComparePanel.this.setProcessing(false);
            }

            @Override
            public void resultReceived(boolean result) {
                ComparePanel.this.setProcessing(false);
            }
        });
    }

    private void doStop() {
        if (this.compare != null) {
            this.compare.stop();
        }
    }

    private void setProcessing(boolean isProcess) {
        this.getEndpointsButton().setEnabled(!isProcess);
        this.getWordsButton().setEnabled(!isProcess);
        this.getOutputRefButton().setEnabled(!isProcess);
        this.getMatchFullRadioButton().setEnabled(!isProcess);
        this.getMatchPartRadioButton().setEnabled(!isProcess);
        this.getFindSubjectRadioButton().setEnabled(!isProcess);
        this.getFindObjectRadioButton().setEnabled(!isProcess);
        this.getFindLabelObjectRadioButton().setEnabled(!isProcess);
        if (isProcess) {
            this.getExecuteButton().setText("Stop");
        } else {
            this.getExecuteButton().setText("Execute");
        }
        this.getExecuteButton().setEnabled(true);
    }

    private JRadioButton getMatchFullRadioButton() {
        if (this.matchFullRadioButton == null) {
            this.matchFullRadioButton = new JRadioButton("Full Match");
        }
        return this.matchFullRadioButton;
    }

    private JRadioButton getMatchPartRadioButton() {
        if (this.matchPartRadioButton == null) {
            this.matchPartRadioButton = new JRadioButton("Part Match");
        }
        return this.matchPartRadioButton;
    }

    private JRadioButton getFindSubjectRadioButton() {
        if (this.findSubjectRadioButton == null) {
            this.findSubjectRadioButton = new JRadioButton("Find Subject");
        }
        return this.findSubjectRadioButton;
    }

    private JRadioButton getFindObjectRadioButton() {
        if (this.findObjectRadioButton == null) {
            this.findObjectRadioButton = new JRadioButton("Find All Object");
        }
        return this.findObjectRadioButton;
    }

    private JRadioButton getFindLabelObjectRadioButton() {
        if (this.findLabelObjectRadioButton == null) {
            this.findLabelObjectRadioButton = new JRadioButton("Find Label Object");
        }
        return this.findLabelObjectRadioButton;
    }

    private JSeparator getSeparator() {
        if (this.separator == null) {
            this.separator = new JSeparator(1);
            this.separator.setPreferredSize(new Dimension(5, 20));
        }
        return this.separator;
    }

    private JTextField getOutputTextField() {
        if (this.outputTextField == null) {
            this.outputTextField = new JTextField();
            this.outputTextField.setEditable(false);
        }
        return this.outputTextField;
    }

    private JButton getOutputRefButton() {
        if (this.outputRefButton == null) {
            this.outputRefButton = new JButton("Ref");
            this.outputRefButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    ComparePanel.this.selectFile(ComparePanel.this.getOutputTextField(), 1);
                    ComparePanel.this.validateExecute();
                }
            });
        }
        return this.outputRefButton;
    }
}

