/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.plugin.compare;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.EndpointSettingsManager;
import jp.ac.osaka_u.sanken.sparql.SparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.CompareResultListener;

public class Compare {
    private HashMap<String, SparqlAccessor> accessorMap = new HashMap();
    private List<String> labels;
    private SparqlQueryListener listener;
    private Thread thread;
    private boolean finalizeThread = false;

    public Compare(File inputFile, File endpointFile) {
        this(inputFile, endpointFile, null);
    }

    public Compare(File inputFile, File endpointFile, SparqlQueryListener listener) {
        this.loadSetting("settings.xml");
        List<String> endpoints = this.readLabelText(endpointFile);
        this.setEndpoint(endpoints);
        this.labels = this.readLabelText(inputFile);
        this.listener = listener;
    }

    public void addEndpoint(String endpoint) {
        EndpointSettings settings = EndpointSettingsManager.instance.getSetting(endpoint);
        SparqlAccessor sa = new SparqlAccessor(settings);
        this.accessorMap.put(endpoint, sa);
    }

    private void setEndpoint(List<String> endpoints) {
        for (String ep : endpoints) {
            this.addEndpoint(ep);
        }
    }

    private List<String> readLabelText(File file) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                ret.add(line);
                line = br.readLine();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return ret;
    }

    public void outputResult(int targetType, boolean fullMatch, File out, CompareResultListener listener) {
        this.thread = new QueryThread(new Object[]{new Integer(targetType), new Boolean(fullMatch), out}, listener){

            @Override
            public void run() {
                try {
                    Integer type = (Integer)((Object[])this.getOption())[0];
                    Boolean fullMatch = (Boolean)((Object[])this.getOption())[1];
                    File file = (File)((Object[])this.getOption())[2];
                    this.getCompareResultListener().resultReceived(Compare.this.outputResult((int)type, (boolean)fullMatch, file));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        this.thread.setUncaughtExceptionHandler(listener);
        this.thread.start();
    }

    public void stop() {
        this.println(String.valueOf(this.getCurrentTime()) + "Stop Request");
        this.finalizeThread = true;
    }

    public boolean outputResult(int targetType, boolean fullMatch, File out) throws IOException {
        if (out.getParentFile() != null && !out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        out.createNewFile();
        if (!out.canWrite()) {
            return false;
        }
        return this.outputResult(targetType, fullMatch, new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), "SJIS")));
    }

    private boolean outputResult(int targetType, boolean fullMatch, PrintWriter out) {
        String typeStr = "all";
        if (targetType == 1) {
            typeStr = "subject";
        }
        if (targetType == 3) {
            typeStr = "object (label only)";
        }
        if (targetType == 2) {
            typeStr = "object";
        }
        this.println("find type :[" + typeStr + "]");
        this.println("full match :[" + fullMatch + "]");
        this.println("target endpoints:");
        for (String endpoint : this.accessorMap.keySet()) {
            this.print("[" + endpoint + "]");
        }
        this.println();
        this.println(String.valueOf(this.getCurrentTime()) + "query start.");
        out.print("\"\",");
        for (String endpoint : this.accessorMap.keySet()) {
            out.print("\"" + endpoint + "\",");
        }
        out.println();
        int index = 0;
        for (String label : this.labels) {
            this.print(String.valueOf(this.getCurrentTime()) + "No." + ++index + ":searching :[" + label + "].");
            out.print("\"" + label + "\",");
            for (String endpoint : this.accessorMap.keySet()) {
                this.print("*");
                SparqlAccessor sa = this.accessorMap.get(endpoint);
                try {
                    SparqlResultSet res = sa.findSubject(label, fullMatch, 10, null, targetType);
                    List<Map<String, RDFNode>> list = res.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, RDFNode> r = list.get(0);
                        RDFNode s = r.get("s");
                        out.print("\"" + s.toString() + "\",");
                    } else {
                        out.print(",");
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (this.finalizeThread) break;
            }
            if (this.finalizeThread) break;
            this.println();
            out.println();
        }
        out.flush();
        out.close();
        this.println(String.valueOf(this.getCurrentTime()) + "query end.");
        return true;
    }

    private String getCurrentTime() {
        Timestamp time = new Timestamp(new Date().getTime());
        return String.valueOf(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(time)) + ":";
    }

    private void println() {
        this.println("");
    }

    private void println(String str2) {
        this.print(String.valueOf(str2) + "\n");
    }

    private void print(String str2) {
        if (this.listener != null) {
            this.listener.sparqlExecuted(str2);
        }
    }

    private int loadSetting(String settingFile) {
        File file = new File(settingFile);
        try {
            EndpointSettings[] settings = EndpointSettings.inputXML(new FileInputStream(file));
            if (settings != null) {
                EndpointSettingsManager.instance.setSettings(settings);
                return 0;
            }
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return 64;
        }
        return 64;
    }

    private class QueryThread
    extends Thread {
        private Object option;
        private CompareResultListener listener;

        public QueryThread(Object option, CompareResultListener listener) {
            this.option = option;
            this.listener = listener;
        }

        protected Object getOption() {
            return this.option;
        }

        protected CompareResultListener getCompareResultListener() {
            return this.listener;
        }
    }
}

