/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.gui;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TripleEditDialog
extends JDialog {
    private static final long serialVersionUID = -8353265680791711240L;
    private RDFNode s;
    private RDFNode p;
    private RDFNode o;
    private Model model;
    private JPanel mainPanel = null;
    private JTextField subjectTextField = null;
    private JTextField propertyTextField = null;
    private JTextField objectTextField = null;
    private JLabel subjectLabel = null;
    private JLabel propertyLabel = null;
    private JLabel objectLabel = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    public boolean ok = false;

    public TripleEditDialog(RDFNode s, RDFNode p, RDFNode o, Model model) {
        this.s = s;
        this.p = p;
        this.o = o;
        this.model = model;
        this.initialize();
        this.getSubjectTextField().setText(s.toString());
        this.getPropertyTextField().setText(p.toString());
        if (o != null) {
            this.getObjectTextField().setText(o.toString());
        }
        this.setModal(true);
    }

    public RDFNode getSubject() {
        if (this.s == null && this.getSubjectTextField().getText().isEmpty()) {
            return null;
        }
        if (this.s != null && this.s.toString().equals(this.getSubjectTextField().getText())) {
            return this.s;
        }
        return this.getRDFNodeFromString(this.getSubjectTextField().getText());
    }

    public RDFNode getProperty() {
        if (this.p == null && this.getPropertyTextField().getText().isEmpty()) {
            return null;
        }
        if (this.p != null && this.p.toString().equals(this.getPropertyTextField().getText())) {
            return this.p;
        }
        return this.getRDFNodeFromString(this.getPropertyTextField().getText());
    }

    public RDFNode getObject() {
        if (this.o == null && this.getObjectTextField().getText().isEmpty()) {
            return null;
        }
        if (this.o != null && this.o.toString().equals(this.getObjectTextField().getText())) {
            return this.o;
        }
        return this.getRDFNodeFromString(this.getObjectTextField().getText());
    }

    private RDFNode getRDFNodeFromString(String str2) {
        if (str2.startsWith("http://")) {
            ResourceImpl ri = new ResourceImpl(str2);
            return ri;
        }
        return this.model.createLiteral(str2);
    }

    private void initialize() {
        this.setSize(new Dimension(999, 157));
        this.setContentPane(this.getMainPanel());
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 0;
            this.objectLabel = new JLabel();
            this.objectLabel.setText("Object");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            this.propertyLabel = new JLabel();
            this.propertyLabel.setText("Property");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            this.subjectLabel = new JLabel();
            this.subjectLabel.setText("Subject");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints.gridx = 0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.getSubjectTextField(), gridBagConstraints);
            this.mainPanel.add((Component)this.getPropertyTextField(), gridBagConstraints1);
            this.mainPanel.add((Component)this.getObjectTextField(), gridBagConstraints2);
            this.mainPanel.add((Component)this.subjectLabel, gridBagConstraints3);
            this.mainPanel.add((Component)this.propertyLabel, gridBagConstraints4);
            this.mainPanel.add((Component)this.objectLabel, gridBagConstraints5);
            this.mainPanel.add((Component)this.getButtonPanel(), gridBagConstraints6);
        }
        return this.mainPanel;
    }

    private JTextField getSubjectTextField() {
        if (this.subjectTextField == null) {
            this.subjectTextField = new JTextField();
            this.subjectTextField.setEditable(false);
        }
        return this.subjectTextField;
    }

    private JTextField getPropertyTextField() {
        if (this.propertyTextField == null) {
            this.propertyTextField = new JTextField();
        }
        return this.propertyTextField;
    }

    private JTextField getObjectTextField() {
        if (this.objectTextField == null) {
            this.objectTextField = new JTextField();
        }
        return this.objectTextField;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
            this.buttonPanel.setAlignmentX(1.0f);
            this.buttonPanel.add(this.getOkButton());
            this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            this.buttonPanel.add(this.getCancelButton());
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TripleEditDialog.this.ok = true;
                    TripleEditDialog.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("CANCEL");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TripleEditDialog.this.ok = false;
                    TripleEditDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }
}

