/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;

public class OptionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel footerPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel mainPanel = null;
    private JTextField queryKeyTextField = null;
    private JTextField optionTextField = null;
    private JLabel queryKeyLabel = null;
    private JLabel optionLabel = null;
    private JLabel encodingLabel = null;
    private JTextField encodingTextField = null;
    private JLabel resultTypeLabel = null;
    private JComboBox dataFormatComboBox = null;
    private boolean isOk;
    private JLabel endpointLabel = null;
    private JTextField endpointTextField = null;
    private JLabel queryTypeLabel = null;
    private JPanel queryTypePanel = null;
    private JRadioButton queryTypeDefaultRadioButton = null;
    private JRadioButton queryTypeCustomRadioButton = null;
    private JLabel namespacesLabel = null;
    private JTextField namespacesTextField = null;
    private JLabel repositoryTypeLabel = null;
    private JPanel repositoryTypePanel = null;
    private JRadioButton repositoryOnRadioButton = null;
    private JRadioButton repositoryOffRadioButton = null;
    private JLabel repositoryLabel = null;
    private JTextField repositoryTextField = null;
    private JLabel userLabel = null;
    private JLabel passLabel = null;
    private JTextField userTextField = null;
    private JPasswordField passPasswordField = null;
    private JLabel urlLabel = null;
    private JTextField repositoryUrlTextField = null;

    public OptionDialog(Frame owner, String endpoint) {
        super(owner);
        this.initialize();
        this.getEndpointTextField().setText(endpoint);
    }

    public OptionDialog(Frame owner, EndpointSettings setting) {
        super(owner);
        this.initialize();
        this.setCurrentEndpoint(setting);
    }

    private void setCurrentEndpoint(EndpointSettings setting) {
        this.getEndpointTextField().setText(setting.getEndpoint());
        this.setUseCustom(setting.isUseCustomParam());
        this.setEncoding(setting.getEncoding());
        this.setQueryKey(setting.getQueryKey());
        this.setOption(setting.getOption());
        this.setNamespaces(setting.getNamespaces());
        this.setResultType(setting.getResultType());
        this.setEditable(setting.isEditable());
        this.setRepositoryURL(setting.getRepositoryURL());
        this.setRepository(setting.getRepository());
        this.setUser(setting.getUser());
        this.setPassword(setting.getPass());
    }

    private void initialize() {
        this.setSize(545, 631);
        this.setContentPane(this.getJContentPane());
    }

    public void setUseCustom(boolean custom) {
        this.getQueryTypeDefaultRadioButton().setSelected(!custom);
        this.getQueryTypeCustomRadioButton().setSelected(custom);
        this.setCustomEnabled(custom);
    }

    public boolean isUseCustom() {
        return this.getQueryTypeCustomRadioButton().isSelected();
    }

    public void setQueryKey(String key) {
        this.getQueryKeyTextField().setText(key);
    }

    public String getQueryKey() {
        return this.getQueryKeyTextField().getText();
    }

    public void setOption(String opt) {
        this.getOptionTextField().setText(opt);
    }

    public String getOption() {
        return this.getOptionTextField().getText();
    }

    public void setNamespaces(String namespaces) {
        this.getNamespacesTextField().setText(namespaces);
    }

    public String getNamespaces() {
        return this.getNamespacesTextField().getText();
    }

    public void setEncoding(String encode) {
        this.getEncodingTextField().setText(encode);
    }

    public String getEndoding() {
        return this.getEncodingTextField().getText();
    }

    public void setResultType(Integer type) {
        this.getDataFormatComboBox().setSelectedItem(EndpointSettings.getResultDataType(type));
    }

    public Integer getResultType() {
        return EndpointSettings.getResultDataType((String)this.getDataFormatComboBox().getSelectedItem());
    }

    public boolean isEditable() {
        return this.getRepositoryOnRadioButton().isSelected();
    }

    public void setEditable(boolean isEditable) {
        this.getRepositoryOnRadioButton().setSelected(isEditable);
        this.getRepositoryOffRadioButton().setSelected(!isEditable);
        this.setEditEnabled(isEditable);
    }

    public String getRepositoryURL() {
        return this.getRepositoryUrlTextField().getText();
    }

    public void setRepositoryURL(String repo) {
        this.getRepositoryUrlTextField().setText(repo);
    }

    public String getRepository() {
        return this.getRepositoryTextField().getText();
    }

    public void setRepository(String repo) {
        this.getRepositoryTextField().setText(repo);
    }

    public String getUser() {
        return this.getUserTextField().getText();
    }

    public void setUser(String user) {
        this.getUserTextField().setText(user);
    }

    public String getPassword() {
        return new String(this.getPassPasswordField().getPassword());
    }

    public void setPassword(String pass) {
        this.getPassPasswordField().setText(pass);
    }

    public boolean isOk() {
        return this.isOk;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getFooterPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(new FlowLayout());
            this.footerPanel.add(this.getOkButton());
            this.footerPanel.add((Component)this.getCancelButton(), null);
        }
        return this.footerPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    OptionDialog.this.isOk = true;
                    OptionDialog.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("CANCEL");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    OptionDialog.this.isOk = false;
                    OptionDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridy = 10;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.insets = new Insets(10, 0, 10, 10);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 10;
            this.urlLabel = new JLabel();
            this.urlLabel.setText("Repository URL");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 13;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(10, 0, 10, 10);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 12;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(10, 0, 10, 10);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 13;
            this.passLabel = new JLabel();
            this.passLabel.setText("Password");
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.gridx = 0;
            gridBagConstraints51.gridy = 12;
            this.userLabel = new JLabel();
            this.userLabel.setText("User");
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.fill = 1;
            gridBagConstraints41.gridy = 11;
            gridBagConstraints41.weightx = 1.0;
            gridBagConstraints41.insets = new Insets(10, 0, 10, 10);
            gridBagConstraints41.gridx = 1;
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.insets = new Insets(0, 10, 0, 5);
            gridBagConstraints32.gridy = 11;
            this.repositoryLabel = new JLabel();
            this.repositoryLabel.setText("Repository Name");
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 1;
            gridBagConstraints25.fill = 1;
            gridBagConstraints25.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints25.gridy = 9;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints15.gridy = 9;
            this.repositoryTypeLabel = new JLabel();
            this.repositoryTypeLabel.setText("Editable AllegroGraph");
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 2;
            gridBagConstraints24.gridy = 2;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints24.gridx = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.insets = new Insets(15, 10, 15, 10);
            gridBagConstraints14.gridy = 2;
            this.namespacesLabel = new JLabel("Namespaces");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 3;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.gridy = 3;
            this.queryTypeLabel = new JLabel("Query Type");
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 2;
            gridBagConstraints23.gridy = 1;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints23.gridx = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.insets = new Insets(15, 10, 15, 10);
            gridBagConstraints13.gridy = 1;
            this.endpointLabel = new JLabel("Endpoint");
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 0;
            gridBagConstraints22.gridy = 8;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.ipadx = 0;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.insets = new Insets(15, 0, 15, 0);
            gridBagConstraints22.gridwidth = 0;
            gridBagConstraints22.gridx = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 8;
            this.resultTypeLabel = new JLabel("Result Format");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 7;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(10, 0, 10, 10);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridy = 7;
            this.encodingLabel = new JLabel("Encoding");
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(10, 0, 10, 0);
            gridBagConstraints11.gridy = 5;
            this.optionLabel = new JLabel("Option");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints2.gridy = 4;
            this.queryKeyLabel = new JLabel("Query Key");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 5;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.anchor = 10;
            gridBagConstraints1.insets = new Insets(10, 0, 10, 10);
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(10, 0, 10, 10);
            gridBagConstraints.gridx = 1;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.getQueryKeyTextField(), gridBagConstraints);
            this.mainPanel.add((Component)this.getOptionTextField(), gridBagConstraints1);
            this.mainPanel.add((Component)this.queryKeyLabel, gridBagConstraints2);
            this.mainPanel.add((Component)this.optionLabel, gridBagConstraints11);
            this.mainPanel.add((Component)this.encodingLabel, gridBagConstraints21);
            this.mainPanel.add((Component)this.getEncodingTextField(), gridBagConstraints3);
            this.mainPanel.add((Component)this.resultTypeLabel, gridBagConstraints12);
            this.mainPanel.add((Component)this.getDataFormatComboBox(), gridBagConstraints22);
            this.mainPanel.add((Component)this.endpointLabel, gridBagConstraints13);
            this.mainPanel.add((Component)this.getEndpointTextField(), gridBagConstraints23);
            this.mainPanel.add((Component)this.queryTypeLabel, gridBagConstraints31);
            this.mainPanel.add((Component)this.getQueryTypePanel(), gridBagConstraints5);
            this.mainPanel.add((Component)this.namespacesLabel, gridBagConstraints14);
            this.mainPanel.add((Component)this.getNamespacesTextField(), gridBagConstraints24);
            this.mainPanel.add((Component)this.repositoryTypeLabel, gridBagConstraints15);
            this.mainPanel.add((Component)this.getRepositoryTypePanel(), gridBagConstraints25);
            this.mainPanel.add((Component)this.repositoryLabel, gridBagConstraints32);
            this.mainPanel.add((Component)this.getRepositoryTextField(), gridBagConstraints41);
            this.mainPanel.add((Component)this.userLabel, gridBagConstraints51);
            this.mainPanel.add((Component)this.passLabel, gridBagConstraints6);
            this.mainPanel.add((Component)this.getUserTextField(), gridBagConstraints7);
            this.mainPanel.add((Component)this.getPassPasswordField(), gridBagConstraints8);
            this.mainPanel.add((Component)this.urlLabel, gridBagConstraints9);
            this.mainPanel.add((Component)this.getRepositoryUrlTextField(), gridBagConstraints10);
        }
        return this.mainPanel;
    }

    private JTextField getQueryKeyTextField() {
        if (this.queryKeyTextField == null) {
            this.queryKeyTextField = new JTextField();
        }
        return this.queryKeyTextField;
    }

    private JTextField getOptionTextField() {
        if (this.optionTextField == null) {
            this.optionTextField = new JTextField();
        }
        return this.optionTextField;
    }

    private JTextField getEncodingTextField() {
        if (this.encodingTextField == null) {
            this.encodingTextField = new JTextField();
        }
        return this.encodingTextField;
    }

    private JComboBox getDataFormatComboBox() {
        if (this.dataFormatComboBox == null) {
            this.dataFormatComboBox = new JComboBox<String>(EndpointSettings.getResultDataTypeList());
        }
        return this.dataFormatComboBox;
    }

    private JTextField getEndpointTextField() {
        if (this.endpointTextField == null) {
            this.endpointTextField = new JTextField();
            this.endpointTextField.setEditable(false);
        }
        return this.endpointTextField;
    }

    private JPanel getQueryTypePanel() {
        if (this.queryTypePanel == null) {
            this.queryTypePanel = new JPanel();
            this.queryTypePanel.setLayout(new FlowLayout());
            this.queryTypePanel.add((Component)this.getQueryTypeDefaultRadioButton(), null);
            this.queryTypePanel.add((Component)this.getQueryTypeCustomRadioButton(), null);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getQueryTypeDefaultRadioButton());
            bg.add(this.getQueryTypeCustomRadioButton());
        }
        return this.queryTypePanel;
    }

    private void setCustomEnabled(boolean enabled) {
        this.getQueryKeyTextField().setEnabled(enabled);
        this.getOptionTextField().setEnabled(enabled);
        this.getEncodingTextField().setEnabled(enabled);
        this.getDataFormatComboBox().setEnabled(enabled);
        this.queryKeyLabel.setEnabled(enabled);
        this.optionLabel.setEnabled(enabled);
        this.encodingLabel.setEnabled(enabled);
        this.resultTypeLabel.setEnabled(enabled);
    }

    private JRadioButton getQueryTypeDefaultRadioButton() {
        if (this.queryTypeDefaultRadioButton == null) {
            this.queryTypeDefaultRadioButton = new JRadioButton("Default");
            this.queryTypeDefaultRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    OptionDialog.this.setCustomEnabled(false);
                }
            });
        }
        return this.queryTypeDefaultRadioButton;
    }

    private JRadioButton getQueryTypeCustomRadioButton() {
        if (this.queryTypeCustomRadioButton == null) {
            this.queryTypeCustomRadioButton = new JRadioButton("Custom");
            this.queryTypeCustomRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    OptionDialog.this.setCustomEnabled(true);
                }
            });
        }
        return this.queryTypeCustomRadioButton;
    }

    private JTextField getNamespacesTextField() {
        if (this.namespacesTextField == null) {
            this.namespacesTextField = new JTextField();
        }
        return this.namespacesTextField;
    }

    private void setEditEnabled(boolean enabled) {
        this.getRepositoryUrlTextField().setEnabled(enabled);
        this.getRepositoryTextField().setEnabled(enabled);
        this.getUserTextField().setEnabled(enabled);
        this.getPassPasswordField().setEnabled(enabled);
        this.urlLabel.setEnabled(enabled);
        this.repositoryLabel.setEnabled(enabled);
        this.userLabel.setEnabled(enabled);
        this.passLabel.setEnabled(enabled);
    }

    private JPanel getRepositoryTypePanel() {
        if (this.repositoryTypePanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = -1;
            gridBagConstraints4.gridy = -1;
            this.repositoryTypePanel = new JPanel();
            this.repositoryTypePanel.setLayout(new FlowLayout());
            this.repositoryTypePanel.add((Component)this.getRepositoryOnRadioButton(), gridBagConstraints4);
            this.repositoryTypePanel.add((Component)this.getRepositoryOffRadioButton(), new GridBagConstraints());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getRepositoryOnRadioButton());
            bg.add(this.getRepositoryOffRadioButton());
        }
        return this.repositoryTypePanel;
    }

    private JRadioButton getRepositoryOnRadioButton() {
        if (this.repositoryOnRadioButton == null) {
            this.repositoryOnRadioButton = new JRadioButton();
            this.repositoryOnRadioButton.setText("ON");
            this.repositoryOnRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    OptionDialog.this.setEditEnabled(true);
                }
            });
        }
        return this.repositoryOnRadioButton;
    }

    private JRadioButton getRepositoryOffRadioButton() {
        if (this.repositoryOffRadioButton == null) {
            this.repositoryOffRadioButton = new JRadioButton();
            this.repositoryOffRadioButton.setText("OFF");
            this.repositoryOffRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    OptionDialog.this.setEditEnabled(false);
                }
            });
        }
        return this.repositoryOffRadioButton;
    }

    private JTextField getRepositoryTextField() {
        if (this.repositoryTextField == null) {
            this.repositoryTextField = new JTextField();
        }
        return this.repositoryTextField;
    }

    private JTextField getUserTextField() {
        if (this.userTextField == null) {
            this.userTextField = new JTextField();
        }
        return this.userTextField;
    }

    private JPasswordField getPassPasswordField() {
        if (this.passPasswordField == null) {
            this.passPasswordField = new JPasswordField();
        }
        return this.passPasswordField;
    }

    private JTextField getRepositoryUrlTextField() {
        if (this.repositoryUrlTextField == null) {
            this.repositoryUrlTextField = new JTextField();
        }
        return this.repositoryUrlTextField;
    }
}

