/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.gui;

import com.hp.hpl.jena.rdf.model.RDFNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import jp.ac.osaka_u.sanken.sparql.EndpointSettingsManager;
import jp.ac.osaka_u.sanken.sparql.SparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.gui.SparqlAccessorForm;

public class KeywordSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel keywordPanel = null;
    private JLabel keywordLabel = null;
    private JTextField keywordTextField = null;
    private JList subjectList = null;
    private JScrollPane subjectScrollPane = null;
    private JPanel centerPanel = null;
    private JPanel footerPanel = null;
    private JScrollPane resultListScrollPane = null;
    private JTable resultList = null;
    private JButton runQueryButton = null;
    private JSplitPane mainSplitPane = null;
    private JPanel optionPanel = null;
    private JPanel findTypePanel = null;
    private JRadioButton fullMatchRadioButton = null;
    private JRadioButton partMatchRadioButton = null;
    private JSeparator findSeparator = null;
    private boolean processing = false;
    private JPanel headerPanel = null;
    private JPanel limitPanel = null;
    private JCheckBox limitEnableCheckBox = null;
    private JLabel limitLabel = null;
    private JComboBox limitComboBox = null;
    private JRadioButton findSubjectRadioButton = null;
    private JRadioButton findObjectRadioButton = null;
    private JRadioButton findAllRadioButton = null;
    private JRadioButton findLabelObjectRadioButton = null;
    private Date fromDate;
    private JPanel movePanel = null;
    private JButton prevButton = null;
    private JButton nextButton = null;
    private JPanel limitMainPanel = null;
    private JButton limitPrevButton = null;
    private JButton limitNextButton = null;
    private SparqlAccessorForm parent;
    private DefaultListModel listModel;
    private DefaultTableModel tableModel;
    private SparqlAccessor sa;
    private int historyIndex = 0;
    private List<String> history;
    private List<String> subjectHistoryList;
    private Integer limit = null;
    private int page = 0;
    private String word;
    private boolean fullMatch = false;
    private int type;
    private boolean hasLimitNext = false;

    public KeywordSearchPanel(SparqlAccessorForm parent) {
        this.initialize();
        this.parent = parent;
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.getMainSplitPane(), "Center");
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane(0, this.getCenterPanel(), this.getFooterPanel());
            this.mainSplitPane.setDividerLocation(200);
        }
        return this.mainSplitPane;
    }

    private JPanel getKeywordPanel() {
        if (this.keywordPanel == null) {
            this.keywordPanel = new JPanel();
            this.keywordPanel.setLayout(new BorderLayout());
            this.keywordLabel = new JLabel();
            this.keywordLabel.setText("Enter Keyword");
            this.keywordPanel.add((Component)this.keywordLabel, "West");
            this.keywordPanel.add((Component)this.getKeywordTextField(), "Center");
            this.keywordPanel.add((Component)this.getRunQueryButton(), "East");
        }
        return this.keywordPanel;
    }

    private JPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = new JPanel();
            this.optionPanel.setLayout(new BorderLayout());
            this.optionPanel.add((Component)this.getFindTypePanel(), "Center");
            this.optionPanel.add((Component)this.getLimitPanel(), "East");
        }
        return this.optionPanel;
    }

    private JPanel getFindTypePanel() {
        if (this.findTypePanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            flowLayout.setVgap(0);
            this.findTypePanel = new JPanel();
            this.findTypePanel.setLayout(flowLayout);
            this.findTypePanel.add((Component)this.getFullMatchRadioButton(), null);
            this.findTypePanel.add((Component)this.getPartMatchRadioButton(), null);
            this.findTypePanel.add((Component)this.getFindSeparator(), null);
            this.findTypePanel.add((Component)this.getFindAllRadioButton(), null);
            this.findTypePanel.add((Component)this.getFindSubjectRadioButton(), null);
            this.findTypePanel.add((Component)this.getFindObjectRadioButton(), null);
            this.findTypePanel.add((Component)this.getFindLabelObjectRadioButton(), null);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getFullMatchRadioButton());
            bg.add(this.getPartMatchRadioButton());
            this.getFullMatchRadioButton().setSelected(true);
            ButtonGroup bg2 = new ButtonGroup();
            bg2.add(this.getFindAllRadioButton());
            bg2.add(this.getFindSubjectRadioButton());
            bg2.add(this.getFindObjectRadioButton());
            bg2.add(this.getFindLabelObjectRadioButton());
            this.getFindSubjectRadioButton().setSelected(true);
        }
        return this.findTypePanel;
    }

    private boolean isFullMatch() {
        return this.getFullMatchRadioButton().isSelected();
    }

    private int getFindType() {
        if (this.getFindSubjectRadioButton().isSelected()) {
            return 1;
        }
        if (this.getFindObjectRadioButton().isSelected()) {
            return 2;
        }
        if (this.getFindLabelObjectRadioButton().isSelected()) {
            return 3;
        }
        return 0;
    }

    private JRadioButton getFullMatchRadioButton() {
        if (this.fullMatchRadioButton == null) {
            this.fullMatchRadioButton = new JRadioButton("Full Match");
        }
        return this.fullMatchRadioButton;
    }

    private JRadioButton getPartMatchRadioButton() {
        if (this.partMatchRadioButton == null) {
            this.partMatchRadioButton = new JRadioButton("Part Match");
        }
        return this.partMatchRadioButton;
    }

    private JSeparator getFindSeparator() {
        if (this.findSeparator == null) {
            this.findSeparator = new JSeparator(1);
            this.findSeparator.setPreferredSize(new Dimension(5, 20));
        }
        return this.findSeparator;
    }

    private JTextField getKeywordTextField() {
        if (this.keywordTextField == null) {
            this.keywordTextField = new JTextField();
            this.keywordTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent arg0) {
                    if (arg0.getKeyChar() == '\n') {
                        KeywordSearchPanel.this.doSearch();
                    }
                }
            });
        }
        return this.keywordTextField;
    }

    public String getFindWord() {
        return this.getKeywordTextField().getText();
    }

    private JList getSubjectList() {
        if (this.subjectList == null) {
            this.subjectList = new JList();
            this.subjectList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    String subject;
                    if (e2.getClickCount() >= 2 && KeywordSearchPanel.this.findSubjectTriple(subject = (String)KeywordSearchPanel.this.getSubjectList().getSelectedValue())) {
                        KeywordSearchPanel.this.addHistory(subject);
                    }
                }
            });
        }
        return this.subjectList;
    }

    private SparqlResultListener createSparqlResultListener2() {
        return new SparqlResultListener(){

            @Override
            public void resultReceived(SparqlResultSet result) {
                KeywordSearchPanel.this.setProcessing(false);
                KeywordSearchPanel.this.setResults(result);
            }

            @Override
            public void uncaughtException(Thread t, Throwable e2) {
                JOptionPane.showMessageDialog(KeywordSearchPanel.this.parent, "Execute error:" + e2.getMessage(), "Error", 0);
                KeywordSearchPanel.this.setProcessing(false);
            }
        };
    }

    private void setSubjectList(String obj) {
        this.listModel = new DefaultListModel();
        this.listModel.addElement(obj);
        this.getSubjectList().setModel(this.listModel);
    }

    public void setSubjectList(List<String> list) {
        this.subjectHistoryList = list;
        this.listModel = new DefaultListModel();
        for (String item : list) {
            this.listModel.addElement(item);
        }
        this.getSubjectList().setModel(this.listModel);
    }

    private JScrollPane getSubjectScrollPane() {
        if (this.subjectScrollPane == null) {
            this.subjectScrollPane = new JScrollPane(this.getSubjectList());
        }
        return this.subjectScrollPane;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.getSubjectScrollPane(), "Center");
        }
        return this.centerPanel;
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(new BorderLayout());
            this.footerPanel.add((Component)this.getResultListScrollPane(), "Center");
        }
        return this.footerPanel;
    }

    private JScrollPane getResultListScrollPane() {
        if (this.resultListScrollPane == null) {
            this.resultListScrollPane = new JScrollPane(this.getResultList());
        }
        return this.resultListScrollPane;
    }

    private JTable getResultList() {
        if (this.resultList == null) {
            this.resultList = new JTable();
            this.resultList.setDefaultEditor(Object.class, null);
            this.resultList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (e2.getClickCount() >= 2) {
                        int index = KeywordSearchPanel.this.resultList.getSelectedRow();
                        String o = KeywordSearchPanel.this.resultList.getValueAt(index, 1).toString();
                        KeywordSearchPanel.this.setSubjectList(o);
                        if (KeywordSearchPanel.this.findSubjectTriple(o)) {
                            KeywordSearchPanel.this.addHistory(o);
                        }
                    }
                }
            });
        }
        return this.resultList;
    }

    public void setResults(SparqlResultSet result) {
        if (result == null || result.getResult() == null || result.getResult().size() == 0) {
            this.tableModel = new DefaultTableModel();
            this.getResultList().setModel(this.tableModel);
            return;
        }
        List<Map<String, RDFNode>> list = result.getResult();
        Map<String, RDFNode> columns = list.get(0);
        ArrayList<String> clm = new ArrayList<String>();
        for (String string : columns.keySet()) {
            clm.add(string);
        }
        this.tableModel = new DefaultTableModel(clm.toArray(new String[0]), 0);
        for (Map map : list) {
            ArrayList<RDFNode> row = new ArrayList<RDFNode>();
            for (String key : clm) {
                RDFNode node = (RDFNode)map.get(key);
                row.add(node);
            }
            this.tableModel.addRow(row.toArray(new Object[0]));
        }
        this.getResultList().setModel(this.tableModel);
        this.parent.setResults(this.sa, result);
    }

    private void setProcessing(boolean processing) {
        this.processing = processing;
        this.getSubjectList().setEnabled(!processing);
        this.getRunQueryButton().setEnabled(!processing);
        this.getResultList().setEnabled(!processing);
        this.getKeywordTextField().setEnabled(!processing);
        this.getFullMatchRadioButton().setEnabled(!processing);
        this.getPartMatchRadioButton().setEnabled(!processing);
        this.getFindSubjectRadioButton().setEnabled(!processing);
        this.getFindObjectRadioButton().setEnabled(!processing);
        this.getFindLabelObjectRadioButton().setEnabled(!processing);
        this.updateButtonStates();
        this.updateLimitButtonStates();
        this.parent.setProcessing(processing);
    }

    private boolean isProcessing() {
        return this.processing;
    }

    private JButton getRunQueryButton() {
        if (this.runQueryButton == null) {
            this.runQueryButton = new JButton("Find");
            this.runQueryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    KeywordSearchPanel.this.doSearch();
                }
            });
        }
        return this.runQueryButton;
    }

    private void doSearch() {
        if (this.isProcessing()) {
            return;
        }
        this.initHistory();
        this.initLimit();
        this.setResults(null);
        this.setProcessing(true);
        this.sa = new SparqlAccessor(EndpointSettingsManager.instance.getSetting(this.parent.getCurrentEndPoint()), new SparqlQueryListener(){

            @Override
            public void sparqlExecuted(String query2) {
                KeywordSearchPanel.this.fromDate = new Date();
                KeywordSearchPanel.this.parent.addLogText("----------------");
                KeywordSearchPanel.this.parent.addLogText(query2);
            }
        });
        this.word = this.getFindWord();
        this.fullMatch = this.isFullMatch();
        this.limit = this.getLimit();
        this.type = this.getFindType();
        this.sa.findSubject(this.word, this.fullMatch, this.limit, this.limit != null ? Integer.valueOf(this.limit * this.page) : null, this.type, this.createSparqlResultListener());
    }

    private SparqlResultListener createSparqlResultListener() {
        return new SparqlResultListener(){

            @Override
            public void resultReceived(SparqlResultSet result) {
                KeywordSearchPanel.this.hasLimitNext = result.isHasNext();
                Date now2 = new Date();
                long time = now2.getTime() - KeywordSearchPanel.this.fromDate.getTime();
                KeywordSearchPanel.this.parent.addLogText("---------------- result:" + time + " ms");
                ArrayList<String> resultList = new ArrayList<String>();
                for (Map<String, RDFNode> item : result.getResult()) {
                    RDFNode node = item.get("s");
                    resultList.add(node.toString());
                }
                KeywordSearchPanel.this.setSubjectList(resultList);
                KeywordSearchPanel.this.setProcessing(false);
            }

            @Override
            public void uncaughtException(Thread t, Throwable e2) {
                JOptionPane.showMessageDialog(KeywordSearchPanel.this.parent, "Execute error:" + e2.getMessage(), "Error", 0);
                KeywordSearchPanel.this.setProcessing(false);
            }
        };
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setLayout(new BorderLayout());
            this.headerPanel.add((Component)this.getKeywordPanel(), "Center");
            this.headerPanel.add((Component)this.getOptionPanel(), "South");
            this.headerPanel.add((Component)this.getMovePanel(), "West");
        }
        return this.headerPanel;
    }

    private JPanel getLimitPanel() {
        if (this.limitPanel == null) {
            this.limitLabel = new JLabel();
            this.limitLabel.setText(" LIMIT  ");
            this.limitLabel.setEnabled(false);
            this.limitPanel = new JPanel();
            this.limitPanel.setLayout(new BorderLayout());
            this.limitPanel.add((Component)this.getLimitEnableCheckBox(), "West");
            this.limitPanel.add((Component)this.limitLabel, "Center");
            this.limitPanel.add((Component)this.getLimitMainPanel(), "East");
        }
        return this.limitPanel;
    }

    private Integer getLimit() {
        try {
            if (this.getLimitComboBox().isEnabled()) {
                return Integer.parseInt((String)this.getLimitComboBox().getSelectedItem());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private JCheckBox getLimitEnableCheckBox() {
        if (this.limitEnableCheckBox == null) {
            this.limitEnableCheckBox = new JCheckBox();
            this.limitEnableCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    boolean enabled = KeywordSearchPanel.this.getLimitEnableCheckBox().isSelected();
                    KeywordSearchPanel.this.getLimitComboBox().setEnabled(enabled);
                    KeywordSearchPanel.this.limitLabel.setEnabled(enabled);
                    KeywordSearchPanel.this.updateLimitButtonStates();
                }
            });
        }
        return this.limitEnableCheckBox;
    }

    private JComboBox getLimitComboBox() {
        if (this.limitComboBox == null) {
            String[] limits = new String[]{"100", "250", "500", "1000"};
            this.limitComboBox = new JComboBox<String>(limits);
            this.limitComboBox.setEnabled(false);
        }
        return this.limitComboBox;
    }

    private JRadioButton getFindSubjectRadioButton() {
        if (this.findSubjectRadioButton == null) {
            this.findSubjectRadioButton = new JRadioButton("Find Subject");
        }
        return this.findSubjectRadioButton;
    }

    private JRadioButton getFindObjectRadioButton() {
        if (this.findObjectRadioButton == null) {
            this.findObjectRadioButton = new JRadioButton("Find All Object");
        }
        return this.findObjectRadioButton;
    }

    private JRadioButton getFindAllRadioButton() {
        if (this.findAllRadioButton == null) {
            this.findAllRadioButton = new JRadioButton("Find All");
            this.findAllRadioButton.setEnabled(false);
        }
        return this.findAllRadioButton;
    }

    private JRadioButton getFindLabelObjectRadioButton() {
        if (this.findLabelObjectRadioButton == null) {
            this.findLabelObjectRadioButton = new JRadioButton("Find Label Object");
        }
        return this.findLabelObjectRadioButton;
    }

    private JPanel getMovePanel() {
        if (this.movePanel == null) {
            this.movePanel = new JPanel();
            this.movePanel.setLayout(new BoxLayout(this.movePanel, 0));
            this.movePanel.add((Component)this.getPrevButton(), null);
            this.movePanel.add((Component)this.getNextButton(), null);
        }
        return this.movePanel;
    }

    private JButton getPrevButton() {
        if (this.prevButton == null) {
            this.prevButton = new JButton("\u2190");
            this.prevButton.setMargin(new Insets(0, 10, 0, 10));
            this.prevButton.setEnabled(false);
            this.prevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String s = KeywordSearchPanel.this.getPrev();
                    if (s != null) {
                        if (KeywordSearchPanel.this.historyIndex == 0) {
                            KeywordSearchPanel.this.setSubjectList(KeywordSearchPanel.this.subjectHistoryList);
                        } else {
                            KeywordSearchPanel.this.setSubjectList(s);
                        }
                        KeywordSearchPanel.this.findSubjectTriple(s);
                    }
                }
            });
        }
        return this.prevButton;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton("\u2192");
            this.nextButton.setMargin(new Insets(0, 10, 0, 10));
            this.nextButton.setEnabled(false);
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String s = KeywordSearchPanel.this.getNext();
                    if (s != null) {
                        KeywordSearchPanel.this.setSubjectList(s);
                        KeywordSearchPanel.this.findSubjectTriple(s);
                    }
                }
            });
        }
        return this.nextButton;
    }

    private boolean findSubjectTriple(String s) {
        if (this.isProcessing()) {
            return false;
        }
        this.setProcessing(true);
        this.setResults(null);
        this.sa.findTripleFromSubject(s, this.createSparqlResultListener2());
        return true;
    }

    private void initHistory() {
        this.history = new ArrayList<String>();
        this.historyIndex = -1;
        this.updateButtonStates();
    }

    private void addHistory(String item) {
        if (this.historyIndex >= 0 && this.historyIndex < this.history.size() - 1) {
            int i = this.history.size() - 1;
            while (i > this.historyIndex) {
                this.history.remove(i);
                --i;
            }
        }
        this.history.add(item);
        ++this.historyIndex;
        this.updateButtonStates();
    }

    private String getPrev() {
        if (this.hasPrev()) {
            --this.historyIndex;
            this.updateButtonStates();
            return this.history.get(this.historyIndex);
        }
        return null;
    }

    private String getNext() {
        if (this.hasNext()) {
            ++this.historyIndex;
            this.updateButtonStates();
            return this.history.get(this.historyIndex);
        }
        return null;
    }

    private void updateButtonStates() {
        if (!this.processing) {
            this.getPrevButton().setEnabled(this.hasPrev());
            this.getNextButton().setEnabled(this.hasNext());
        } else {
            this.getPrevButton().setEnabled(false);
            this.getNextButton().setEnabled(false);
        }
    }

    private boolean hasPrev() {
        return this.history.size() != 0 && this.historyIndex > 0;
    }

    private boolean hasNext() {
        return this.historyIndex + 1 < this.history.size();
    }

    private JPanel getLimitMainPanel() {
        if (this.limitMainPanel == null) {
            this.limitMainPanel = new JPanel();
            this.limitMainPanel.setLayout(new BorderLayout());
            this.limitMainPanel.add((Component)this.getLimitComboBox(), "West");
            this.limitMainPanel.add((Component)this.getLimitPrevButton(), "Center");
            this.limitMainPanel.add((Component)this.getLimitNextButton(), "East");
        }
        return this.limitMainPanel;
    }

    private JButton getLimitPrevButton() {
        if (this.limitPrevButton == null) {
            this.limitPrevButton = new JButton("\u2190");
            this.limitPrevButton.setMargin(new Insets(0, 10, 0, 10));
            this.limitPrevButton.setEnabled(false);
            this.limitPrevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    KeywordSearchPanel.this.setProcessing(true);
                    SparqlAccessor sparqlAccessor = KeywordSearchPanel.this.sa;
                    String string = KeywordSearchPanel.this.word;
                    boolean bl = KeywordSearchPanel.this.fullMatch;
                    Integer n = KeywordSearchPanel.this.limit;
                    int n2 = KeywordSearchPanel.this.limit;
                    KeywordSearchPanel keywordSearchPanel = KeywordSearchPanel.this;
                    int n3 = keywordSearchPanel.page - 1;
                    keywordSearchPanel.page = n3;
                    sparqlAccessor.findSubject(string, bl, n, n2 * n3, KeywordSearchPanel.this.type, KeywordSearchPanel.this.createSparqlResultListener());
                }
            });
        }
        return this.limitPrevButton;
    }

    private JButton getLimitNextButton() {
        if (this.limitNextButton == null) {
            this.limitNextButton = new JButton("\u2192");
            this.limitNextButton.setMargin(new Insets(0, 10, 0, 10));
            this.limitNextButton.setEnabled(false);
            this.limitNextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    KeywordSearchPanel.this.setProcessing(true);
                    SparqlAccessor sparqlAccessor = KeywordSearchPanel.this.sa;
                    String string = KeywordSearchPanel.this.word;
                    boolean bl = KeywordSearchPanel.this.fullMatch;
                    Integer n = KeywordSearchPanel.this.limit;
                    int n2 = KeywordSearchPanel.this.limit;
                    KeywordSearchPanel keywordSearchPanel = KeywordSearchPanel.this;
                    int n3 = keywordSearchPanel.page + 1;
                    keywordSearchPanel.page = n3;
                    sparqlAccessor.findSubject(string, bl, n, n2 * n3, KeywordSearchPanel.this.type, KeywordSearchPanel.this.createSparqlResultListener());
                }
            });
        }
        return this.limitNextButton;
    }

    private void initLimit() {
        this.limit = this.getLimit();
        this.page = 0;
    }

    private void updateLimitButtonStates() {
        if (!this.processing && this.getLimitEnableCheckBox().isSelected()) {
            this.getLimitPrevButton().setEnabled(this.page != 0);
            this.getLimitNextButton().setEnabled(this.hasLimitNext);
        } else {
            this.getLimitPrevButton().setEnabled(false);
            this.getLimitNextButton().setEnabled(false);
        }
    }
}

