/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGQueryExecutionFactory;
import com.franz.agraph.jena.AGQueryFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.SeparatedValuesExporter;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.edit.AllegroEditor;

public class SparqlAccessor {
    private EndpointSettings setting;
    public static final int OUTPUT_TYPE_TSV = 0;
    public static final int OUTPUT_TYPE_CSV = 1;
    public static final int OUTPUT_TYPE_XLS = 2;
    public static final int FIND_TARGET_ALL = 0;
    public static final int FIND_TARGET_SUBJECT = 1;
    public static final int FIND_TARGET_OBJECT = 2;
    public static final int FIND_TARGET_LABEL_OBJECT = 3;
    private SparqlQueryListener queryListener;
    private HashMap<Integer, String> separatorMap;

    public SparqlAccessor(EndpointSettings endpoint, SparqlQueryListener queryListener) {
        this.queryListener = queryListener;
        this.setting = endpoint;
        this.separatorMap = new HashMap();
        this.separatorMap.put(0, "\t");
        this.separatorMap.put(1, ",");
    }

    public SparqlAccessor(EndpointSettings endpoint) {
        this(endpoint, null);
    }

    public EndpointSettings getSetting() {
        return this.setting;
    }

    private QueryExecution makeQuery(String queryString) {
        QueryExecution qe = null;
        if (this.setting.isEditable()) {
            try {
                AllegroEditor ae = new AllegroEditor(this, this.setting.getRepositoryURL(), this.setting.getRepository(), this.setting.getUser(), this.setting.getPass());
                AGQuery sparql2 = AGQueryFactory.create(queryString);
                qe = AGQueryExecutionFactory.create(sparql2, (AGModel)ae.getModel());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else {
            Query query2 = QueryFactory.create(queryString);
            qe = QueryExecutionFactory.sparqlService(this.setting.getEndpoint(), query2);
        }
        return qe;
    }

    public void executeQuery(String queryString, SparqlResultListener resultListener) {
        QueryThread thread = new QueryThread(queryString, resultListener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(SparqlAccessor.this.executeQuery(this.getQueryString())));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(resultListener);
        thread.start();
    }

    public List<Map<String, RDFNode>> executeQuery(String queryString) throws Exception {
        ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
        QueryExecution qe = this.makeQuery(queryString);
        if (qe == null) {
            throw new Exception("Can't connect to endpoint");
        }
        try {
            try {
                if (this.queryListener != null) {
                    this.queryListener.sparqlExecuted(queryString);
                }
                ResultSet results = null;
                try {
                    results = !this.setting.isUseCustomParam() ? qe.execSelect() : this.customQuery(queryString);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                List<String> keys = results.getResultVars();
                while (results.hasNext()) {
                    QuerySolution result = results.next();
                    HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
                    for (String key : keys) {
                        RDFNode node = result.get(key);
                        map.put(key, node);
                    }
                    ret.add(map);
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw e3;
            }
        }
        finally {
            qe.close();
        }
        return ret;
    }

    private ResultSet customQuery(String query2) throws Exception {
        URL url = new URL(String.valueOf(this.setting.getEndpoint()) + "?" + this.setting.getQueryKey() + "=" + URLEncoder.encode(query2, this.setting.getEncoding()) + "&" + this.setting.getOption());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Accept-Language", "ja");
        conn.setRequestProperty("Referer", this.setting.getEndpoint());
        int resultType = this.setting.getResultType();
        ResultSet ret = null;
        if (resultType == 1) {
            ret = ResultSetFactory.fromJSON(conn.getInputStream());
        } else if (resultType == 0) {
            ret = ResultSetFactory.fromXML(conn.getInputStream());
        } else if (resultType == 2) {
            ret = ResultSetFactory.fromSSE(conn.getInputStream());
        } else if (resultType == 3) {
            ret = ResultSetFactory.fromTSV(conn.getInputStream());
        }
        conn.disconnect();
        return ret;
    }

    public SparqlResultSet findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type) throws Exception {
        String query2;
        if (!fullMatch) {
            query2 = type == 1 ? "select distinct ?s where {\n?s <http://www.w3.org/2000/01/rdf-schema#label> ?o \nFILTER(regex(str(?s), \"" + word + "\", \"m\"))\n" + "}" : (type == 2 ? "select distinct ?s where {\n?s ?p ?o \nFILTER(regex(str(?o), \"" + word + "\", \"m\"))\n" + "}" : (type == 3 ? "select distinct ?s where {\n?s <http://www.w3.org/2000/01/rdf-schema#label> ?o \nFILTER(regex(str(?o), \"" + word + "\", \"m\"))\n" + "}" : "select distinct ?s where {?s <http://www.w3.org/2000/01/rdf-schema#label> ?o FILTER(regex(str(?o), \"" + word + "\", \"m\"))" + "}"));
        } else if (type == 2) {
            query2 = "select distinct ?s where \n{{?s ?p \"" + word + "\"} UNION \n" + "{?s ?p \"" + word + "\"@en} UNION \n" + "{?s ?p \"" + word + "\"@ja} ";
            String[] namespaces = this.setting.getNamespaceList();
            if (namespaces != null && namespaces.length > 0) {
                query2 = String.valueOf(query2) + "UNION \n";
            }
            int i = 0;
            while (i < namespaces.length) {
                String ns = namespaces[i];
                query2 = String.valueOf(query2) + "{?s ?p <" + ns + "/" + word + ">} ";
                query2 = i != namespaces.length - 1 ? String.valueOf(query2) + "UNION \n" : String.valueOf(query2) + "\n";
                ++i;
            }
            query2 = String.valueOf(query2) + "}";
        } else if (type == 3) {
            query2 = "select distinct ?s where \n{{?s <http://www.w3.org/2000/01/rdf-schema#label> \"" + word + "\"} UNION \n" + "{?s <http://www.w3.org/2000/01/rdf-schema#label> \"" + word + "\"@en} UNION \n" + "{?s <http://www.w3.org/2000/01/rdf-schema#label> \"" + word + "\"@ja} ";
            query2 = String.valueOf(query2) + "}";
        } else {
            if (type == 1) {
                String[] namespaces = this.setting.getNamespaceList();
                ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
                int i = 0;
                while (i < namespaces.length) {
                    String ns = namespaces[i];
                    String query3 = "select ?o where {\n<" + ns + "/" + word + "> ?p ?o \n";
                    List<Map<String, RDFNode>> temp = this.executeQuery(query3 = String.valueOf(query3) + "}");
                    if (temp != null && temp.size() > 0) {
                        HashMap<String, ResourceImpl> node = new HashMap<String, ResourceImpl>();
                        node.put("s", new ResourceImpl(String.valueOf(ns) + "/" + word));
                        ret.add(node);
                    }
                    ++i;
                }
                return new SparqlResultSet(ret, false);
            }
            query2 = "select distinct ?s where {\n{?s ?p \"" + word + "\"} UNION \n" + "{?s ?p \"" + word + "\"@en} UNION \n" + "{?s ?p \"" + word + "\"@ja}\n" + "}";
        }
        if (limit != null && limit > 0) {
            query2 = String.valueOf(query2) + "\n LIMIT " + String.valueOf(limit + 1);
        }
        if (offset != null && offset > 0) {
            query2 = String.valueOf(query2) + "\n OFFSET " + String.valueOf(offset);
        }
        List<Map<String, RDFNode>> result = this.executeQuery(query2);
        SparqlResultSet ret = new SparqlResultSet(result);
        if (result != null && result.size() > limit) {
            result = result.subList(0, limit);
            ret.setResult(result);
            ret.setHasNext(true);
        }
        return ret;
    }

    public void findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, SparqlResultListener resultListener) {
        QueryThread thread = new QueryThread(word, new Object[]{new Boolean(fullMatch), limit, offset, new Integer(type)}, resultListener){

            @Override
            public void run() {
                try {
                    Boolean fullMatch = (Boolean)((Object[])this.getOption())[0];
                    Integer limit = (Integer)((Object[])this.getOption())[1];
                    Integer offset = (Integer)((Object[])this.getOption())[2];
                    Integer type = (Integer)((Object[])this.getOption())[3];
                    this.getSparqlResultListener().resultReceived(SparqlAccessor.this.findSubject(this.getQueryString(), fullMatch, limit, offset, type));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(resultListener);
        thread.start();
    }

    public List<Map<String, RDFNode>> findTripleFromSubject(String subject) throws Exception {
        String query2 = "select ?p ?o where {\n<" + subject + "> ?p ?o\n" + "}";
        return this.executeQuery(query2);
    }

    public void findTripleFromSubject(String subject, SparqlResultListener listener) {
        QueryThread thread = new QueryThread(subject, listener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(SparqlAccessor.this.findTripleFromSubject(this.getQueryString())));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(listener);
        thread.start();
    }

    public boolean saveResult(List<Map<String, RDFNode>> results, int type, OutputStream stream) {
        if (type == 0 || type == 1) {
            String separator = this.separatorMap.get(type);
            if (separator == null) {
                return false;
            }
            SeparatedValuesExporter expo = new SeparatedValuesExporter(separator, results);
            try {
                expo.export(stream);
                return true;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return true;
            }
        }
        return false;
    }

    public boolean saveResult(List<Map<String, RDFNode>> results, int type, File file) throws FileNotFoundException {
        return this.saveResult(results, type, new FileOutputStream(file));
    }

    public static void main(String[] args) {
        try {
            URL url = new URL("http://www.wikipediaontology.org/query/?q=" + URLEncoder.encode("select * {?s ?p ?o}", "UTF-8") + "&type=xml&LIMIT=100");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "test");
            conn.setRequestProperty("Accept-Language", "ja");
            conn.setRequestProperty("Referer", "http://www.wikipediaontology.org/query/");
            InputStreamReader isr = new InputStreamReader(conn.getInputStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
            conn.disconnect();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private class QueryThread
    extends Thread {
        private String queryString;
        private Object option;
        private SparqlResultListener listener;

        public QueryThread(String queryString, Object option, SparqlResultListener listener) {
            this.queryString = queryString;
            this.option = option;
            this.listener = listener;
        }

        public QueryThread(String queryString, SparqlResultListener listener) {
            this(queryString, null, listener);
        }

        protected String getQueryString() {
            return this.queryString;
        }

        protected Object getOption() {
            return this.option;
        }

        protected SparqlResultListener getSparqlResultListener() {
            return this.listener;
        }
    }
}

