/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class EndpointSettings
implements Serializable {
    private static final long serialVersionUID = -6928422841511501314L;
    public static final int RESULT_TYPE_XML = 0;
    public static final int RESULT_TYPE_JSON = 1;
    public static final int RESULT_TYPE_SSE = 2;
    public static final int RESULT_TYPE_TSV = 3;
    public static final String RESULT_TYPE_XML_STR = "XML/RDF";
    public static final String RESULT_TYPE_JSON_STR = "JSON";
    public static final String RESULT_TYPE_SSE_STR = "SPARQL Syntax Expressions";
    public static final String RESULT_TYPE_TSV_STR = "TSV";
    private static HashMap<String, Integer> dataTypeMap = new LinkedHashMap<String, Integer>();
    private String endpoint;
    private boolean useCustomParam = false;
    private String queryKey = "q";
    private String option = "type=json&LIMIT=100";
    private String encoding = "UTF-8";
    private String namespaces = "";
    private int resultType = 1;
    private boolean editable = false;
    private String repositoryURL;
    private String repository;
    private String user;
    private String pass;

    static {
        dataTypeMap.put(RESULT_TYPE_XML_STR, new Integer(0));
        dataTypeMap.put(RESULT_TYPE_JSON_STR, new Integer(1));
        dataTypeMap.put(RESULT_TYPE_SSE_STR, new Integer(2));
        dataTypeMap.put(RESULT_TYPE_TSV_STR, new Integer(3));
    }

    public EndpointSettings() {
    }

    public EndpointSettings(String endpoint) {
        this.endpoint = endpoint;
        this.namespaces = this.makeDefaultNamespaces(endpoint);
        this.makeDefaultRepository(endpoint);
    }

    private String makeDefaultNamespaces(String endpoint) {
        int index;
        String ret = "";
        if (endpoint == null) {
            return ret;
        }
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - "/".length());
        }
        if ((index = endpoint.lastIndexOf("/")) > 0) {
            endpoint = endpoint.substring(0, index);
        }
        ret = String.valueOf(endpoint) + "/class," + endpoint + "/instance," + endpoint + "/resource";
        return ret;
    }

    private void makeDefaultRepository(String endpoint) {
        int index = endpoint.indexOf("/endpoint/");
        if (index >= 0) {
            this.repositoryURL = endpoint.substring(0, index);
            this.repository = endpoint.substring(index + "/endpoint/".length());
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isUseCustomParam() {
        return this.useCustomParam;
    }

    public void setUseCustomParam(boolean useCustomParam) {
        this.useCustomParam = useCustomParam;
    }

    public String getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(String queryKey) {
        this.queryKey = queryKey;
    }

    public void setNamespaces(String namespaces) {
        this.namespaces = namespaces;
    }

    public String getNamespaces() {
        return this.namespaces;
    }

    public String[] getNamespaceList() {
        return this.namespaces.split(",");
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public int getResultType() {
        return this.resultType;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public void setRepositoryURL(String repositoryURL) {
        this.repositoryURL = repositoryURL;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public static String[] getResultDataTypeList() {
        return dataTypeMap.keySet().toArray(new String[0]);
    }

    public static Integer getResultDataType(String str2) {
        return dataTypeMap.get(str2);
    }

    public static String getResultDataType(Integer type) {
        for (String key : dataTypeMap.keySet()) {
            if (!dataTypeMap.get(key).equals(type)) continue;
            return key;
        }
        return null;
    }

    public static void outputXML(OutputStream os, EndpointSettings[] settings) {
        XMLEncoder enc = new XMLEncoder(os);
        enc.writeObject(settings);
        enc.close();
    }

    public static EndpointSettings[] inputXML(InputStream is) {
        XMLDecoder dec = new XMLDecoder(is);
        EndpointSettings[] ret = (EndpointSettings[])dec.readObject();
        return ret;
    }
}

