/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.platform;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessLauncher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String commandLine;
    private String[] commandArray;
    private File baseDir;
    private ArrayList<OutputListener> listeners = new ArrayList(1);
    private Process subProcess;
    private boolean finished = false;
    private StringBuilder out = new StringBuilder();
    private StringBuilder err = new StringBuilder();

    public ProcessLauncher(String commandLine) {
        this(commandLine, null);
    }

    public ProcessLauncher(String commandLine, File baseDir) {
        this.commandLine = commandLine;
        this.baseDir = baseDir;
    }

    public ProcessLauncher(String[] commandArray) {
        this(commandArray, null);
    }

    public ProcessLauncher(String[] commandArray, File baseDir) {
        this.commandArray = commandArray;
        this.baseDir = baseDir;
    }

    public ProcessLauncher(ArrayList<?> commandList) {
        this(commandList, null);
    }

    public ProcessLauncher(ArrayList<?> commandList, File baseDir) {
        this(ProcessLauncher.toStringArray(commandList), baseDir);
    }

    private static <T> String[] toStringArray(ArrayList<T> list) {
        String[] result = new String[list.size()];
        Iterator<T> iter = list.iterator();
        int arrayIndex = 0;
        while (iter.hasNext()) {
            result[arrayIndex++] = iter.next().toString();
        }
        return result;
    }

    public void addOutputListener(OutputListener listener) {
        this.listeners.add(listener);
    }

    private void fireErr(char[] err) {
        if (this.listeners.isEmpty()) {
            this.err.append((CharSequence)this.out);
        }
        Iterator<OutputListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().errorOutput(err);
        }
    }

    private void fireOut(char[] out) {
        if (this.listeners.isEmpty()) {
            this.out.append(out);
        }
        Iterator<OutputListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().standardOutput(out);
        }
    }

    public String getStandardOutput() {
        if (!this.listeners.isEmpty()) {
            throw new IllegalStateException("Cannot get standard output, because outputlisteners have been registered.");
        }
        return this.out.toString();
    }

    public String getErrorOutput() {
        if (!this.listeners.isEmpty()) {
            throw new IllegalStateException("Cannot get error output, because outputlisteners have been registered.");
        }
        return this.err.toString();
    }

    public String getCommandLine() {
        if (this.commandLine != null) {
            return this.commandLine;
        }
        if (this.commandArray != null) {
            StringBuilder result = new StringBuilder(64);
            for (int i = 0; i < this.commandArray.length; ++i) {
                if (i > 0) {
                    result.append(' ');
                }
                result.append(this.commandArray[i]);
            }
            return result.toString();
        }
        return null;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int launch() throws CommandNotExistsException {
        this.err.setLength(0);
        this.out.setLength(0);
        BackgroundPrinter stdout = null;
        BackgroundPrinter stderr = null;
        try {
            this.subProcess = this.commandArray != null ? Runtime.getRuntime().exec(this.commandArray, null, this.baseDir) : Runtime.getRuntime().exec(this.commandLine, null, this.baseDir);
            stdout = new BackgroundPrinter(this.subProcess.getInputStream(), false);
            stderr = new BackgroundPrinter(this.subProcess.getErrorStream(), true);
            stdout.start();
            stderr.start();
            int exitValue = this.subProcess.waitFor();
            stdout.join(10000L);
            stderr.join(10000L);
            if (exitValue != 0) {
                this.logger.info("WARNING: exit value " + exitValue + " for command \"" + this.getCommandLine() + "\"");
            }
            int n = exitValue;
            return n;
        }
        catch (IOException ioe) {
            throw new CommandNotExistsException("Command probably does not exist: " + ioe);
        }
        catch (Exception e2) {
            this.logger.error("Exception while running/launching \"" + this.getCommandLine() + "\".", e2);
        }
        finally {
            if (this.subProcess != null) {
                this.subProcess.destroy();
                this.subProcess = null;
            }
            if (stdout != null) {
                stdout.close();
            }
            if (stderr != null) {
                stderr.close();
            }
            this.finished = true;
        }
        return -1;
    }

    public void abort() {
        if (this.subProcess != null) {
            this.subProcess.destroy();
            this.subProcess = null;
        }
    }

    public static class CommandNotExistsException
    extends RuntimeException {
        private static final long serialVersionUID = -3770613178610919742L;

        public CommandNotExistsException(String msg) {
            super(msg);
        }
    }

    private class BackgroundPrinter
    extends Thread {
        private InputStream in;
        boolean isErrorOutput;

        public BackgroundPrinter(InputStream in, boolean isErrorOutput) {
            this.in = in;
            this.isErrorOutput = isErrorOutput;
        }

        public void run() {
            try {
                int numberOfReadBytes;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
                char[] buf = new char[1024];
                while ((numberOfReadBytes = reader.read(buf)) != -1) {
                    char[] clearedbuf = new char[numberOfReadBytes];
                    System.arraycopy(buf, 0, clearedbuf, 0, numberOfReadBytes);
                    if (this.isErrorOutput) {
                        ProcessLauncher.this.fireErr(clearedbuf);
                        continue;
                    }
                    ProcessLauncher.this.fireOut(clearedbuf);
                }
            }
            catch (Exception e2) {
                ProcessLauncher.this.logger.warn("Exception while reading from stream from subprocess.", e2);
            }
        }

        public void close() {
            try {
                this.in.close();
            }
            catch (Exception e2) {
                ProcessLauncher.this.logger.warn("Closing background stream for launched process caused exception.", e2);
            }
        }
    }

    public static interface OutputListener {
        public void standardOutput(char[] var1);

        public void errorOutput(char[] var1);
    }
}

