/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.CloseableIterationBase;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExceptionConvertingIteration<E, X extends Exception>
extends CloseableIterationBase<E, X> {
    private final Iteration<? extends E, ? extends Exception> iter;

    public ExceptionConvertingIteration(Iteration<? extends E, ? extends Exception> iter) {
        assert (iter != null);
        this.iter = iter;
    }

    protected abstract X convert(Exception var1);

    @Override
    public boolean hasNext() throws X {
        try {
            return this.iter.hasNext();
        }
        catch (Exception e2) {
            throw this.convert(e2);
        }
    }

    @Override
    public E next() throws X {
        try {
            return this.iter.next();
        }
        catch (NoSuchElementException e2) {
            throw e2;
        }
        catch (IllegalStateException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw this.convert(e4);
        }
    }

    @Override
    public void remove() throws X {
        try {
            this.iter.remove();
        }
        catch (UnsupportedOperationException e2) {
            throw e2;
        }
        catch (IllegalStateException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw this.convert(e4);
        }
    }

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        try {
            Iterations.closeCloseable(this.iter);
        }
        catch (Exception e2) {
            throw this.convert(e2);
        }
    }
}

