/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import java.util.Date;

public class OlsonTimeZone
extends TimeZone {
    static final long serialVersionUID = -6281977362477515376L;
    private static final boolean ASSERT = false;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private int transitionCount;
    private int typeCount;
    private int[] transitionTimes;
    private int[] typeOffsets;
    private byte[] typeData;
    private int finalYear = Integer.MAX_VALUE;
    private double finalMillis = Double.MAX_VALUE;
    private SimpleTimeZone finalZone = null;
    private static final boolean DEBUG = ICUDebug.enabled("olson");
    private static final int[] DAYS_BEFORE = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int JULIAN_1_CE = 1721426;
    private static final int JULIAN_1970_CE = 2440588;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int SECONDS_PER_DAY = 86400;

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Month is not in the legal range: " + month);
        }
        return this.getOffset(era, year, month, day, dayOfWeek, milliseconds, MONTH_LENGTH[month + (OlsonTimeZone.isLeapYear(year) ? 12 : 0)]);
    }

    public int getOffset(int era, int year, int month, int dom, int dow, int millis, int monthLength) {
        if (era != 1 && era != 0 || month < 0 || month > 11 || dom < 1 || dom > monthLength || dow < 1 || dow > 7 || millis < 0 || millis >= 86400000 || monthLength < 28 || monthLength > 31) {
            throw new IllegalArgumentException();
        }
        if (era == 0) {
            year = -year;
        }
        if (year > this.finalYear) {
            return this.finalZone.getOffset(era, year, month, dom, dow, millis, monthLength);
        }
        double time = OlsonTimeZone.fieldsToDay(year, month, dom) * 86400.0 + Math.floor((double)millis / 1000.0);
        return this.zoneOffset(this.findTransition(time, true)) * 1000;
    }

    public void setRawOffset(int offsetMillis) {
        this.finalZone.setRawOffset(offsetMillis);
    }

    public Object clone() {
        OlsonTimeZone other = (OlsonTimeZone)super.clone();
        if (this.finalZone != null) {
            this.finalZone.setID(this.getID());
            other.finalZone = (SimpleTimeZone)this.finalZone.clone();
        }
        other.transitionTimes = (int[])this.transitionTimes.clone();
        other.typeData = (byte[])this.typeData.clone();
        other.typeOffsets = (int[])this.typeOffsets.clone();
        return other;
    }

    public void getOffset(long date2, boolean local, int[] offsets) {
        if ((double)date2 >= this.finalMillis && this.finalZone != null) {
            double[] doub = this.floorDivide(date2, 8.64E7);
            double millis = doub[1];
            double days = doub[0];
            int[] temp = this.dayToFields(days);
            int year = temp[0];
            int month = temp[1];
            int dom = temp[2];
            int dow = temp[3];
            int rawoff = this.finalZone.getRawOffset();
            if (!local) {
                doub = this.floorDivide(date2 += (long)rawoff, 8.64E7);
                double days2 = doub[0];
                millis = doub[1];
                if (days2 != days) {
                    temp = this.dayToFields(days2);
                    year = temp[0];
                    month = temp[1];
                    dom = temp[2];
                    dow = temp[3];
                }
            }
            int dstoff = this.finalZone.getOffset(1, year, month, dom, dow, (int)millis) - rawoff;
            offsets[0] = rawoff;
            offsets[1] = dstoff;
            return;
        }
        double secs = Math.floor(date2 / 1000L);
        int i = this.findTransition(secs, local);
        int rawoff = this.rawOffset(i) * 1000;
        int dstoff = this.dstOffset(i) * 1000;
        offsets[0] = rawoff;
        offsets[1] = dstoff;
    }

    double[] floorDivide(double dividend, double divisor) {
        double[] ret = new double[2];
        double quotient = Math.floor(dividend / divisor);
        double remainder = dividend - quotient * divisor;
        if (remainder < 0.0 || remainder >= divisor) {
            double q = quotient;
            remainder = q == (quotient += remainder < 0.0 ? -1.0 : 1.0) ? 0.0 : dividend - quotient * divisor;
        }
        ret[0] = quotient;
        ret[1] = remainder;
        return ret;
    }

    public int getRawOffset() {
        int[] ret = new int[2];
        this.getOffset(System.currentTimeMillis(), false, ret);
        return ret[0];
    }

    public boolean useDaylightTime() {
        double[] dt = this.floorDivide(System.currentTimeMillis(), 8.64E7);
        int days = (int)dt[0];
        int[] it = this.dayToFields(days);
        int year = it[0];
        int month = it[1];
        int dom = it[2];
        int dow = it[3];
        if (year > this.finalYear) {
            return true;
        }
        int start = (int)OlsonTimeZone.fieldsToDay(year, 0, 1) * 86400;
        int limit = (int)OlsonTimeZone.fieldsToDay(year + 1, 0, 1) * 86400;
        for (int i = 0; i < this.transitionCount && this.transitionTimes[i] < limit; ++i) {
            if (this.transitionTimes[i] < start || this.dstOffset(this.typeData[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public int getDSTSavings() {
        if (this.finalZone != null) {
            return this.finalZone.getDSTSavings();
        }
        return super.getDSTSavings();
    }

    public boolean inDaylightTime(Date date2) {
        int[] temp = new int[2];
        this.getOffset(date2.getTime(), false, temp);
        return temp[1] != 0;
    }

    private void constructEmpty() {
        this.transitionCount = 0;
        this.typeCount = 1;
        this.typeOffsets = new int[]{0, 0};
        this.transitionTimes = this.typeOffsets;
        this.typeData = new byte[2];
    }

    public OlsonTimeZone(ICUResourceBundle top, ICUResourceBundle res) {
        this.construct(top, res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void construct(ICUResourceBundle top, ICUResourceBundle res) {
        int size;
        if (top == null || res == null) {
            throw new IllegalArgumentException();
        }
        if (DEBUG) {
            System.out.println("OlsonTimeZone(" + res.getKey() + ")");
        }
        if ((size = res.getSize()) < 3 || size > 6) {
            throw new IllegalArgumentException("Invalid Format");
        }
        ICUResourceBundle r = res.get(0);
        this.transitionTimes = r.getIntVector();
        if (this.transitionTimes.length < 0 || this.transitionTimes.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid Format");
        }
        this.transitionCount = this.transitionTimes.length;
        r = res.get(1);
        this.typeOffsets = r.getIntVector();
        if (this.typeOffsets.length < 2 || this.typeOffsets.length > 32766 || (this.typeOffsets.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid Format");
        }
        this.typeCount = this.typeOffsets.length >> 1;
        r = res.get(2);
        this.typeData = r.getBinary().array();
        if (this.typeData.length != this.transitionCount) {
            throw new IllegalArgumentException("Invalid Format");
        }
        if (size < 5) return;
        String ruleid = res.getString(3);
        r = res.get(4);
        int[] data = r.getIntVector();
        if (data == null || data.length != 2) throw new IllegalArgumentException("Invalid Format");
        int rawOffset = data[0] * 1000;
        this.finalYear = data[1] - 1;
        this.finalMillis = OlsonTimeZone.fieldsToDay(data[1], 0, 1) * 8.64E7;
        r = OlsonTimeZone.loadRule(top, ruleid);
        data = r.getIntVector();
        if (data.length != 11) throw new IllegalArgumentException("Invalid Format");
        this.finalZone = new SimpleTimeZone(rawOffset, "", data[0], data[1], data[2], data[3] * 1000, data[4], data[5], data[6], data[7], data[8] * 1000, data[9], data[10] * 1000);
    }

    public OlsonTimeZone() {
        this.constructEmpty();
    }

    public OlsonTimeZone(String id) {
        ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        ICUResourceBundle res = ZoneMeta.openOlsonResource(id);
        this.construct(top, res);
        if (this.finalZone != null) {
            this.finalZone.setID(id);
        }
        super.setID(id);
    }

    public void setID(String id) {
        if (this.finalZone != null) {
            this.finalZone.setID(id);
        }
        super.setID(id);
    }

    private int getInt(byte val) {
        return 0xFF & val;
    }

    private int findTransition(double time, boolean local) {
        int i = 0;
        if (this.transitionCount != 0) {
            for (i = this.transitionCount - 1; i > 0; --i) {
                int transition = this.transitionTimes[i];
                if (local) {
                    int zoneOffsetCurr;
                    int zoneOffsetPrev = this.zoneOffset(this.getInt(this.typeData[i - 1]));
                    transition = zoneOffsetPrev < (zoneOffsetCurr = this.zoneOffset(this.getInt(this.typeData[i]))) ? (transition += zoneOffsetPrev) : (transition += zoneOffsetCurr);
                }
                if (time >= (double)transition) break;
            }
            i = this.typeData[i];
        }
        return i;
    }

    private int zoneOffset(int index) {
        return this.typeOffsets[index <<= 1] + this.typeOffsets[index + 1];
    }

    private int rawOffset(int index) {
        return this.typeOffsets[index << 1];
    }

    private int dstOffset(int index) {
        return this.typeOffsets[(index << 1) + 1];
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('[');
        buf.append("transitionCount=" + this.transitionCount);
        buf.append(",typeCount=" + this.typeCount);
        buf.append(",transitionTimes=");
        if (this.transitionTimes != null) {
            buf.append('[');
            for (i = 0; i < this.transitionTimes.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(Integer.toString(this.transitionTimes[i]));
            }
            buf.append(']');
        } else {
            buf.append("null");
        }
        buf.append(",typeOffsets=");
        if (this.typeOffsets != null) {
            buf.append('[');
            for (i = 0; i < this.typeOffsets.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(Integer.toString(this.typeOffsets[i]));
            }
            buf.append(']');
        } else {
            buf.append("null");
        }
        buf.append(",finalYear=" + this.finalYear);
        buf.append(",finalMillis=" + this.finalMillis);
        buf.append(",finalZone=" + this.finalZone);
        buf.append(']');
        return buf.toString();
    }

    private static final double fieldsToDay(int year, int month, int dom) {
        int y = year - 1;
        double julian = (long)(365 * y) + OlsonTimeZone.myFloorDivide(y, 4L) + 1721423L + OlsonTimeZone.myFloorDivide(y, 400L) - OlsonTimeZone.myFloorDivide(y, 100L) + 2L + (long)DAYS_BEFORE[month + (OlsonTimeZone.isLeapYear(year) ? 12 : 0)] + (long)dom;
        return julian - 2440588.0;
    }

    private static final boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static ICUResourceBundle loadRule(ICUResourceBundle top, String ruleid) {
        ICUResourceBundle r = top.get("Rules");
        r = r.get(ruleid);
        return r;
    }

    private static final long myFloorDivide(long numerator, long denominator) {
        return numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
    }

    int[] dayToFields(double day) {
        int march1;
        int[] ret = new int[5];
        double[] temp = this.floorDivide(day += 719162.0, 146097.0);
        double n400 = temp[0];
        double doy = temp[1];
        temp = this.floorDivide(doy, 36524.0);
        double n100 = temp[0];
        doy = temp[1];
        temp = this.floorDivide(doy, 1461.0);
        double n4 = temp[0];
        doy = temp[1];
        temp = this.floorDivide(doy, 365.0);
        double n1 = temp[0];
        doy = temp[1];
        int year = (int)(400.0 * n400 + 100.0 * n100 + 4.0 * n4 + n1);
        if (n100 == 4.0 || n1 == 4.0) {
            doy = 365.0;
        } else {
            ++year;
        }
        boolean isLeap = OlsonTimeZone.isLeapYear(year);
        int dow = (int)((day + 1.0) % 7.0);
        dow += dow < 0 ? 8 : 1;
        int correction = 0;
        int n = march1 = isLeap ? 60 : 59;
        if (doy >= (double)march1) {
            correction = isLeap ? 1 : 2;
        }
        int month = (int)((12.0 * (doy + (double)correction) + 6.0) / 367.0);
        int dom = (int)(doy - (double)DAYS_BEFORE[month + (isLeap ? 12 : 0)] + 1.0);
        ret[0] = year;
        ret[1] = month;
        ret[2] = dom;
        ret[3] = dow;
        ret[4] = (int)(doy += 1.0);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        OlsonTimeZone z = (OlsonTimeZone)obj;
        return Utility.arrayEquals(this.typeData, (Object)z.typeData) || this.finalYear == z.finalYear && (this.finalZone == null && z.finalZone == null || this.finalZone != null && z.finalZone != null && this.finalZone.equals(z.finalZone) && this.transitionCount == z.transitionCount && this.typeCount == z.typeCount && Utility.arrayEquals(this.transitionTimes, (Object)z.transitionTimes) && Utility.arrayEquals(this.typeOffsets, (Object)z.typeOffsets) && Utility.arrayEquals(this.typeData, (Object)z.typeData));
    }

    public int hashCode() {
        int i;
        int ret = (int)((long)(this.finalYear ^ (this.finalYear >>> 4) + this.transitionCount ^ (this.transitionCount >>> 6) + this.typeCount) ^ (long)(this.typeCount >>> 8) + Double.doubleToLongBits(this.finalMillis) + (long)(this.finalZone == null ? 0 : this.finalZone.hashCode()) + (long)super.hashCode());
        for (i = 0; i < this.transitionTimes.length; ++i) {
            ret += this.transitionTimes[i] ^ this.transitionTimes[i] >>> 8;
        }
        for (i = 0; i < this.typeOffsets.length; ++i) {
            ret += this.typeOffsets[i] ^ this.typeOffsets[i] >>> 8;
        }
        for (i = 0; i < this.typeData.length; ++i) {
            ret += this.typeData[i] & 0xFF;
        }
        return ret;
    }
}

