/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.logging.Log;

public class CollectionUtils {
    public static <T> void removeNulls(Collection<T> list) {
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            T e2 = iter.next();
            if (e2 != null) continue;
            iter.remove();
        }
    }

    public static <T> List<List<T>> permute(List<T> c) {
        if (c.size() > 5) {
            Log.warn(CollectionUtils.class, "Attempt to permute more than 5 items - think again");
            return null;
        }
        ArrayList<List<T>> x = new ArrayList<List<T>>();
        if (c.size() == 1) {
            x.add(c);
            return x;
        }
        for (T obj : c) {
            ArrayList<T> c2 = new ArrayList<T>(c);
            c2.remove(obj);
            List<List<T>> x2 = CollectionUtils.permute(c2);
            for (List<T> x3 : x2) {
                x3.add(0, obj);
                x.add(x3);
            }
        }
        return x;
    }
}

