/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.util.LabelToNodeMap;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.atlas.logging.Log;

class XMLInputStAX
extends SPARQLResult {
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace";

    public static ResultSet fromXML(InputStream in) {
        return XMLInputStAX.fromXML(in, null);
    }

    public static ResultSet fromXML(InputStream in, Model model) {
        XMLInputStAX x = new XMLInputStAX(in, model);
        if (!x.isResultSet()) {
            throw new ResultSetException("Not a result set");
        }
        return x.getResultSet();
    }

    public static ResultSet fromXML(String str2) {
        return XMLInputStAX.fromXML(str2, null);
    }

    public static ResultSet fromXML(String str2, Model model) {
        XMLInputStAX x = new XMLInputStAX(str2, model);
        if (!x.isResultSet()) {
            throw new ResultSetException("Not a result set");
        }
        return x.getResultSet();
    }

    public static boolean booleanFromXML(InputStream in) {
        XMLInputStAX x = new XMLInputStAX(in);
        return x.getBooleanResult();
    }

    public static boolean booleanFromXML(String str2) {
        XMLInputStAX x = new XMLInputStAX(str2);
        return x.getBooleanResult();
    }

    public XMLInputStAX(InputStream in) {
        this(in, null);
    }

    public XMLInputStAX(InputStream in, Model model) {
        XMLInputFactory xf = XMLInputFactory.newInstance();
        try {
            XMLStreamReader xReader = xf.createXMLStreamReader(in);
            this.worker(xReader, model);
        }
        catch (XMLStreamException e2) {
            throw new ResultSetException("Can't initialize StAX parsing engine", e2);
        }
        catch (Exception ex) {
            throw new ResultSetException("Failed when initializing the StAX parsing engine", ex);
        }
    }

    public XMLInputStAX(String str2) {
        this(str2, null);
    }

    public XMLInputStAX(String str2, Model model) {
        XMLInputFactory xf = XMLInputFactory.newInstance();
        try {
            StringReader r = new StringReader(str2);
            XMLStreamReader xReader = xf.createXMLStreamReader(r);
            this.worker(xReader, model);
        }
        catch (XMLStreamException e2) {
            throw new ResultSetException("Can't initialize StAX parsing engine", e2);
        }
        catch (Exception ex) {
            throw new ResultSetException("Failed when initializing the StAX parsing engine", ex);
        }
    }

    private void worker(XMLStreamReader xReader, Model model) {
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        ResultSetStAX rss = new ResultSetStAX(xReader, model);
        if (rss.isResultSet) {
            this.set(rss);
        } else {
            this.set(rss.askResult);
        }
    }

    class ResultSetStAX
    implements ResultSet,
    Closeable {
        QuerySolution current = null;
        XMLStreamReader parser = null;
        List<String> variables = new ArrayList<String>();
        Binding binding = null;
        boolean inputGraphLabels = ARQ.isTrue(ARQ.inputGraphBNodeLabels);
        LabelToNodeMap bNodes = LabelToNodeMap.createBNodeMap();
        boolean isResultSet = false;
        boolean ordered = false;
        boolean distinct = false;
        boolean finished = false;
        Model model = null;
        int row = 0;
        boolean askResult = false;

        ResultSetStAX(XMLStreamReader reader, Model model) {
            this.parser = reader;
            this.model = model;
            this.init();
        }

        private void init() {
            try {
                this.skipTo("head");
                this.processHead();
                this.skipTo(new String[]{"results", "boolean"}, new String[]{"results"});
                String tag = this.parser.getLocalName();
                if (tag.equals("results")) {
                    this.isResultSet = true;
                    this.processResults();
                }
                if (tag.equals("boolean")) {
                    this.isResultSet = false;
                    this.processBoolean();
                }
            }
            catch (XMLStreamException ex) {
                Log.warn(this, "XMLStreamException: " + ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.isResultSet) {
                throw new ResultSetException("Not an XML result set");
            }
            try {
                if (this.finished) {
                    return false;
                }
                if (this.binding == null) {
                    this.binding = this.getOneSolution();
                }
            }
            catch (XMLStreamException ex) {
                ex.printStackTrace(System.err);
                this.staxError("XMLStreamException: " + ex.getMessage(), ex);
            }
            ++this.row;
            boolean b = this.binding != null;
            return b;
        }

        @Override
        public QuerySolution next() {
            return this.nextSolution();
        }

        @Override
        public Binding nextBinding() {
            if (this.finished) {
                throw new NoSuchElementException("End of XML Results");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("End of XML Results");
            }
            Binding r = this.binding;
            this.binding = null;
            return r;
        }

        @Override
        public QuerySolution nextSolution() {
            Binding r = this.nextBinding();
            ResultBinding currentEnv = new ResultBinding(this.model, r);
            return currentEnv;
        }

        @Override
        public int getRowNumber() {
            return this.row;
        }

        @Override
        public List<String> getResultVars() {
            return this.variables;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        @Override
        public Model getResourceModel() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(XMLInputStAX.class.getName());
        }

        @Override
        public void close() {
            this.finished = true;
        }

        private void processBoolean() throws XMLStreamException {
            String s = this.parser.getElementText();
            if (s.equalsIgnoreCase("true")) {
                this.askResult = true;
                return;
            }
            if (s.equalsIgnoreCase("false")) {
                this.askResult = false;
                return;
            }
            throw new ResultSetException("Unknown boolean value: " + s);
        }

        private void skipTo(String tag1) throws XMLStreamException {
            this.skipTo(new String[]{tag1}, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void skipTo(String[] startElementNames, String[] stopElementNames) throws XMLStreamException {
            boolean found = false;
            block5: while (this.parser.hasNext()) {
                int event = this.parser.next();
                switch (event) {
                    case 8: {
                        break block5;
                    }
                    case 2: {
                        String endTag;
                        if (stopElementNames == null || (endTag = this.parser.getLocalName()) == null || !this.containsName(stopElementNames, endTag)) break;
                        return;
                    }
                    case 1: {
                        if (startElementNames == null) break;
                        QName qname = this.parser.getName();
                        if (!qname.getNamespaceURI().equals("http://www.w3.org/2005/sparql-results#")) {
                            this.staxError("skipToHead: Unexpected tag: " + qname);
                        }
                        if (!this.containsName(startElementNames, qname.getLocalPart())) break;
                        return;
                    }
                }
            }
            if (!found) {
                String s1 = "";
                if (startElementNames != null) {
                    s1 = StrUtils.strjoin(", ", startElementNames);
                }
                String s2 = "";
                if (stopElementNames != null) {
                    s2 = StrUtils.strjoin(", ", stopElementNames);
                }
                Log.warn(this, "Failed to find start and stop of specified elements: " + s1 + " :: " + s2);
            }
        }

        private boolean containsName(String[] elementNames, String eName) {
            for (int i = 0; i < elementNames.length; ++i) {
                String s = elementNames[i];
                if (!s.equals(eName)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processHead() throws XMLStreamException {
            while (this.parser.hasNext()) {
                int event = this.parser.next();
                String tag = null;
                switch (event) {
                    case 8: {
                        return;
                    }
                    case 2: {
                        tag = this.parser.getLocalName();
                        if (!this.isTag(tag, "head")) break;
                        return;
                    }
                    case 1: {
                        tag = this.parser.getLocalName();
                        if (this.isTag(tag, "head")) break;
                        if (this.isTag(tag, "variable")) {
                            String varname = this.parser.getAttributeValue(null, "name");
                            this.variables.add(varname);
                            break;
                        }
                        if (this.isTag(tag, "link")) break;
                        this.staxError("Unknown XML element: " + tag);
                    }
                }
            }
        }

        private void processResults() throws XMLStreamException {
        }

        private Binding getOneSolution() throws XMLStreamException {
            BindingMap binding = BindingFactory.create();
            String varName = null;
            while (this.parser.hasNext()) {
                int event = this.parser.next();
                String tag = null;
                switch (event) {
                    case 8: {
                        this.staxError("End of document while processing solution");
                        return null;
                    }
                    case 2: {
                        tag = this.parser.getLocalName();
                        if (this.isTag(tag, "result")) {
                            return binding;
                        }
                        if (!this.isTag(tag, "results")) break;
                        return null;
                    }
                    case 1: {
                        Node node;
                        tag = this.parser.getLocalName();
                        if (this.isTag(tag, "result")) {
                            binding = BindingFactory.create();
                            break;
                        }
                        if (this.isTag(tag, "binding")) {
                            varName = this.parser.getAttributeValue(null, "name");
                            break;
                        }
                        if (this.isTag(tag, "bnode")) {
                            String label = this.parser.getElementText();
                            node = null;
                            node = this.inputGraphLabels ? Node.createAnon(new AnonId(label)) : this.bNodes.asNode(label);
                            SPARQLResult.addBinding(binding, Var.alloc(varName), node);
                            break;
                        }
                        if (this.isTag(tag, "literal")) {
                            String datatype = this.parser.getAttributeValue(null, "datatype");
                            String langTag = this.parser.getAttributeValue(XMLInputStAX.XML_NS, "lang");
                            String text = this.parser.getElementText();
                            RDFDatatype dType = null;
                            if (datatype != null) {
                                dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
                            }
                            Node n = Node.createLiteral(text, langTag, dType);
                            if (varName == null) {
                                throw new ResultSetException("No name for variable");
                            }
                            SPARQLResult.addBinding(binding, Var.alloc(varName), n);
                            break;
                        }
                        if (this.isTag(tag, "unbound") || !this.isTag(tag, "uri")) break;
                        String uri = this.parser.getElementText();
                        node = Node.createURI(uri);
                        SPARQLResult.addBinding(binding, Var.alloc(varName), node);
                        break;
                    }
                }
            }
            this.staxError("getOneSolution: Hit end unexpectedly");
            return null;
        }

        private boolean isTag(String localName, String expectedName) {
            if (!this.parser.getNamespaceURI().equals("http://www.w3.org/2005/sparql-results#")) {
                return false;
            }
            return localName.equals(expectedName);
        }

        private void staxError(String msg) {
            Log.warn(this, "StAX error: " + msg);
            throw new ResultSetException(msg);
        }

        private void staxError(String msg, Throwable th) {
            Log.warn(this, "StAX error: " + msg, th);
            throw new ResultSetException(msg, th);
        }
    }
}

