/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.openjena.atlas.io.IO;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class TSVInput {
    static Pattern pattern = Pattern.compile("\t");

    public static ResultSet fromTSV(InputStream in) {
        BufferedReader reader = IO.asBufferedUTF8(in);
        ArrayList<Var> vars = new ArrayList<Var>();
        ArrayList<String> varNames = new ArrayList<String>();
        ArrayList<BindingMap> bindings2 = new ArrayList<BindingMap>();
        boolean first = true;
        String str2 = null;
        int line = 0;
        try {
            while ((str2 = reader.readLine()) != null) {
                ++line;
                String[] tokens2 = pattern.split(str2, -1);
                if (first) {
                    for (String token : tokens2) {
                        if (token.startsWith("?")) {
                            token = token.substring(1);
                        }
                        Var var = Var.alloc(token);
                        vars.add(var);
                        varNames.add(var.getName());
                    }
                    first = false;
                    continue;
                }
                int num_tokens = tokens2.length;
                if (num_tokens != vars.size()) {
                    throw new ARQException(String.format("Line %d has %d values instead of %d.", line, num_tokens, vars.size()));
                }
                BindingMap binding = BindingFactory.create();
                for (int i = 0; i < tokens2.length; ++i) {
                    String token;
                    token = tokens2[i];
                    Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(token);
                    if (!tokenizer.hasNext() || token.length() <= 0) continue;
                    Node node = tokenizer.next().asNode();
                    binding.add((Var)vars.get(i), node);
                }
                bindings2.add(binding);
            }
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
        return new ResultSetStream(varNames, null, new QueryIterPlainWrapper(bindings2.iterator()));
    }
}

