/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementMinus;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementVisitorBase;
import com.hp.hpl.jena.sparql.syntax.ElementWalker;
import com.hp.hpl.jena.sparql.syntax.PatternVars;
import com.hp.hpl.jena.sparql.syntax.PatternVarsVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SyntaxVarScope {
    public static void check(Query query2) {
        if (query2.getQueryPattern() == null) {
            return;
        }
        SyntaxVarScope.checkSubQuery(query2.getQueryPattern());
        SyntaxVarScope.checkBind(query2);
        SyntaxVarScope.checkQueryScope(query2);
        Collection<Var> vars = SyntaxVarScope.varsOfQuery(query2);
        SyntaxVarScope.check(query2, vars);
    }

    private static void checkBind(Query query2) {
        LinkedHashSet<Var> queryVars = new LinkedHashSet<Var>();
        BindScopeChecker visitor = new BindScopeChecker(queryVars);
        ScopeWalker walker = new ScopeWalker(visitor);
        ElementWalker.walk(query2.getQueryPattern(), walker);
    }

    private static void checkSubQuery(Element el) {
        SubQueryScopeChecker v = new SubQueryScopeChecker();
        ElementWalker.walk(el, v);
    }

    private static void checkQueryScope(Query query2) {
        Collection<Var> vars = SyntaxVarScope.varsOfQuery(query2);
        SyntaxVarScope.checkExprListAssignment(vars, query2.getProject());
    }

    private static Collection<Var> varsOfQuery(Query query2) {
        Set<Var> vars = PatternVars.vars(query2.getQueryPattern());
        if (query2.hasBindings()) {
            vars.addAll(query2.getBindingVariables());
        }
        return vars;
    }

    private static void check(Query query2, Collection<Var> vars) {
        SyntaxVarScope.checkExprListAssignment(vars, query2.getProject());
        if (!Syntax.syntaxARQ.equals(query2.getSyntax()) && query2.isQueryResultStar() && query2.hasGroupBy()) {
            throw new QueryParseException("SELECT * not legal with GROUP BY", -1, -1);
        }
        SyntaxVarScope.checkExprVarUse(query2);
    }

    private static void checkExprListAssignment(Collection<Var> vars, VarExprList exprList) {
        LinkedHashSet<Var> vars2 = new LinkedHashSet<Var>(vars);
        for (Var v : exprList.getVars()) {
            Expr e2 = exprList.getExpr(v);
            SyntaxVarScope.checkAssignment(vars2, e2, v);
            vars2.add(v);
        }
    }

    private static void checkExprVarUse(Query query2) {
        if (query2.hasGroupBy()) {
            VarExprList groupKey = query2.getGroupBy();
            List<Var> groupVars = groupKey.getVars();
            VarExprList exprList = query2.getProject();
            for (Var v : exprList.getVars()) {
                Expr e2 = exprList.getExpr(v);
                if (e2 == null) {
                    if (groupVars.contains(v)) continue;
                    throw new QueryParseException("Non-group key variable in SELECT: " + v, -1, -1);
                }
                Set<Var> eVars = e2.getVarsMentioned();
                for (Var v2 : eVars) {
                    if (groupVars.contains(v2)) continue;
                    throw new QueryParseException("Non-group key variable in SELECT: " + v2 + " in expression " + e2, -1, -1);
                }
            }
        }
    }

    private static void checkAssignment(Collection<Var> scope, Expr expr, Var var) {
        if (expr == null) {
            return;
        }
        if (scope.contains(var)) {
            throw new QueryParseException("Variable used when already in-scope: " + var + " in " + SyntaxVarScope.fmtAssignment(expr, var), -1, -1);
        }
    }

    private static String fmtExprList(VarExprList exprList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Var v : exprList.getVars()) {
            Expr e2 = exprList.getExpr(v);
            if (!first) {
                sb.append(" ");
            }
            first = false;
            sb.append("(").append(e2).append(" AS ").append(v).append(")");
        }
        return sb.toString();
    }

    private static String fmtAssignment(Expr expr, Var var) {
        return "(" + expr + " AS " + var + ")";
    }

    public static class ScopeWalker
    extends ElementWalker.Walker {
        PatternVarsVisitor pvVisitor;

        protected ScopeWalker(PatternVarsVisitor visitor) {
            super(visitor);
            this.pvVisitor = visitor;
        }

        @Override
        public void visit(ElementMinus el) {
            this.proc.visit(el);
        }

        @Override
        public void visit(ElementUnion el) {
            HashSet<Var> accState = new HashSet<Var>(this.pvVisitor.acc);
            this.doMultipleIndependent(accState, el.getElements());
            this.pvVisitor.acc = accState;
            this.proc.visit(el);
        }

        private void doMultipleIndependent(Set<Var> agg, List<Element> elements) {
            for (Element e2 : elements) {
                this.pvVisitor.acc.clear();
                e2.visit(this);
                agg.addAll(this.pvVisitor.acc);
            }
        }
    }

    private static class BindScopeChecker
    extends PatternVarsVisitor {
        public BindScopeChecker(Set<Var> s) {
            super(s);
        }

        @Override
        public void visit(ElementBind el) {
            Var var = el.getVar();
            if (this.acc.contains(var)) {
                throw new QueryParseException("BIND: Variable used when already in-scope: " + var + " in " + el, -1, -1);
            }
            SyntaxVarScope.checkAssignment(this.acc, el.getExpr(), var);
        }
    }

    private static class SubQueryScopeChecker
    extends ElementVisitorBase {
        private SubQueryScopeChecker() {
        }

        @Override
        public void visit(ElementSubQuery el) {
            Query query2 = el.getQuery();
            SyntaxVarScope.checkQueryScope(query2);
            SyntaxVarScope.check(el.getQuery());
        }
    }
}

