/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.iterator.Iter;

public class Reifier2
implements Reifier {
    private static final String qs = "PREFIX rdf: <" + RDF.getURI() + ">\n" + "SELECT * \n" + "{ ?x rdf:type rdf:Statement ; rdf:subject ?S ; rdf:predicate ?P ; rdf:object ?O }";
    private static final Query query = QueryFactory.create(qs);
    private static final Op op = Algebra.compile(query);
    private static final Var reifNodeVar = Var.alloc("x");
    private static final Var varS = Var.alloc("S");
    private static final Var varP = Var.alloc("P");
    private static final Var varO = Var.alloc("O");
    private static final Node rdfType = RDF.Nodes.type;
    private static final Node statement = RDF.Nodes.Statement;
    private static final Node subject = RDF.Nodes.subject;
    private static final Node predicate = RDF.Nodes.predicate;
    private static final Node object = RDF.Nodes.object;
    private final Graph graph;
    private final DatasetGraph ds;
    private final QueryEngineFactory factory;
    static Filter<Triple> filterReif = new Filter<Triple>(){

        @Override
        public boolean accept(Triple triple) {
            return triple.getPredicate().equals(subject) || triple.getPredicate().equals(predicate) || triple.getPredicate().equals(object) || triple.getPredicate().equals(rdfType) && triple.getObject().equals(statement);
        }
    };

    public Reifier2(Graph graph) {
        this.graph = graph;
        this.ds = DatasetGraphFactory.createOneGraph(graph);
        this.factory = QueryEngineRegistry.findFactory(op, this.ds, null);
    }

    @Override
    public ExtendedIterator<Node> allNodes() {
        return this.allNodes(null);
    }

    @Override
    public ExtendedIterator<Node> allNodes(Triple triple) {
        QueryIterator qIter = this.nodesReifTriple(null, triple);
        return new MapperToNode(qIter, reifNodeVar);
    }

    private QueryIterator nodesReifTriple(Node node, TripleMatch triple) {
        Binding b = BindingRoot.create();
        if (node == Node.ANY) {
            node = null;
        }
        if (node != null || triple != null) {
            BindingMap b2 = BindingFactory.create(b);
            if (node != null) {
                Reifier2.bind(b2, reifNodeVar, node);
            }
            if (triple != null) {
                Reifier2.bind(b2, varS, triple.getMatchSubject());
                Reifier2.bind(b2, varP, triple.getMatchPredicate());
                Reifier2.bind(b2, varO, triple.getMatchObject());
            }
            b = b2;
        }
        Plan plan = this.factory.create(op, this.ds, b, null);
        QueryIterator qIter = plan.iterator();
        return qIter;
    }

    private static void bind(BindingMap b, Var var, Node node) {
        if (node == null || node == Node.ANY) {
            return;
        }
        b.add(var, node);
    }

    @Override
    public void close() {
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch match) {
        return this.graph.find(match);
    }

    @Override
    public ExtendedIterator<Triple> findEither(TripleMatch match, boolean showHidden) {
        if (showHidden) {
            return NullIterator.instance();
        }
        return this.graph.find(match);
    }

    @Override
    public ExtendedIterator<Triple> findExposed(TripleMatch match) {
        Iterator<Triple> it = this.graph.find(match);
        it = Iter.filter(it, filterReif);
        return WrappedIterator.create(it);
    }

    @Override
    public Graph getParentGraph() {
        return this.graph;
    }

    @Override
    public ReificationStyle getStyle() {
        return ReificationStyle.Standard;
    }

    @Override
    public boolean handledAdd(Triple triple) {
        this.graph.add(triple);
        return true;
    }

    @Override
    public boolean handledRemove(Triple triple) {
        this.graph.delete(triple);
        return true;
    }

    @Override
    public boolean hasTriple(Node node) {
        return this.getTriple(node) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTriple(Triple triple) {
        QueryIterator qIter = this.nodesReifTriple(null, triple);
        try {
            if (!qIter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            Binding b = qIter.nextBinding();
            Node x = b.get(reifNodeVar);
            if (qIter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.getTriple(x) != null;
            return bl;
        }
        finally {
            qIter.close();
        }
    }

    @Override
    public Node reifyAs(Node node, Triple triple) {
        Triple t;
        if (node == null) {
            node = Node.createAnon();
        } else {
            t = this.getTriple(node);
            if (t != null && !t.equals(triple)) {
                throw new AlreadyReifiedException(node);
            }
            if (t != null) {
                return node;
            }
        }
        this.graph.add(new Triple(node, rdfType, statement));
        this.graph.add(new Triple(node, subject, triple.getSubject()));
        this.graph.add(new Triple(node, predicate, triple.getPredicate()));
        this.graph.add(new Triple(node, object, triple.getObject()));
        t = this.getTriple(node);
        if (t == null) {
            throw new CannotReifyException(node);
        }
        return node;
    }

    @Override
    public void remove(Triple triple) {
        for (Node n : Iter.toList(this.allNodes(triple))) {
            this.remove(n, triple);
        }
    }

    @Override
    public void remove(Node node, Triple triple) {
        HashSet<Triple> triples = new HashSet<Triple>();
        this.triplesToZap(triples, node, rdfType, statement);
        this.triplesToZap(triples, node, subject, triple.getSubject());
        this.triplesToZap(triples, node, predicate, triple.getPredicate());
        this.triplesToZap(triples, node, object, triple.getObject());
        for (Triple t : triples) {
            this.graph.delete(t);
        }
    }

    private void triplesToZap(Collection<Triple> acc, Node s, Node p, Node o) {
        ExtendedIterator<Triple> iter = this.graph.find(s, p, o);
        while (iter.hasNext()) {
            acc.add((Triple)iter.next());
        }
    }

    @Override
    public int size() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Triple getTriple(Node node) {
        QueryIterator qIter = this.nodesReifTriple(node, null);
        try {
            if (!qIter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Binding b = qIter.nextBinding();
            if (qIter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Node S = b.get(varS);
            Node P = b.get(varP);
            Node O = b.get(varO);
            Triple triple = new Triple(S, P, O);
            return triple;
        }
        finally {
            qIter.close();
        }
    }

    private Node getNode(Node S, Node P) {
        ExtendedIterator<Triple> it = this.graph.find(S, P, Node.ANY);
        if (!it.hasNext()) {
            return null;
        }
        Triple t = (Triple)it.next();
        it.close();
        return t.getObject();
    }

    private static class MapperToTriple
    extends NiceIterator<Triple> {
        private final QueryIterator iter;

        MapperToTriple(QueryIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Triple next() {
            Binding b = this.iter.nextBinding();
            Node S = b.get(varS);
            Node P = b.get(varP);
            Node O = b.get(varO);
            return new Triple(S, P, O);
        }

        @Override
        public void close() {
            this.iter.close();
        }
    }

    private static class MapperToNode
    extends NiceIterator<Node> {
        private final QueryIterator iter;
        private final Var var;

        MapperToNode(QueryIterator iter, Var var) {
            this.iter = iter;
            this.var = var;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Node next() {
            Binding b = this.iter.nextBinding();
            Node n = b.get(this.var);
            return n;
        }

        @Override
        public void close() {
            this.iter.close();
        }
    }
}

