/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;

public class NodeValueTime
extends NodeValue {
    XSDDateTime time;

    public NodeValueTime(XSDDateTime dt) {
        this.time = dt;
        if (dt.getDays() != 0 && dt.getMonths() != 0 && dt.getYears() != 0) {
            throw new ExprException("Illegal time: " + dt);
        }
        if (dt.getTimePart() == 0.0) {
            throw new ExprException("Illegal time: " + dt);
        }
    }

    public NodeValueTime(XSDDateTime dt, Node n) {
        super(n);
        this.time = dt;
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public XSDDateTime getDateTime() {
        return this.time;
    }

    @Override
    protected Node makeNode() {
        String lex = this.time.toString();
        return Node.createLiteral(lex, null, XSDDatatype.XSDtime);
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

