/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingComparator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openjena.atlas.data.BagFactory;
import org.openjena.atlas.data.DistinctDataNet;
import org.openjena.atlas.data.ThresholdPolicy;
import org.openjena.atlas.data.ThresholdPolicyFactory;
import org.openjena.atlas.iterator.Iter;
import org.openjena.riot.SerializationFactoryFinder;

public class QueryIterDistinct
extends QueryIter {
    private final QueryIterator inputIterator;
    final DistinctDataNet<Binding> db;
    boolean initialized = false;
    boolean finished = false;
    Binding slot;
    Iterator<Binding> dbIter;

    public QueryIterDistinct(QueryIterator qIter, ExecutionContext context) {
        super(context);
        this.inputIterator = qIter;
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(context.getContext());
        BindingComparator comparator = new BindingComparator(new ArrayList<SortCondition>(), context);
        this.db = BagFactory.newDistinctNet(policy, SerializationFactoryFinder.bindingSerializationFactory(), comparator);
    }

    @Override
    public void requestCancel() {
        this.inputIterator.cancel();
    }

    private void init() {
        if (!this.initialized) {
            this.fill();
            this.initialized = true;
        }
    }

    private void fill() {
        while (this.inputIterator.hasNext()) {
            this.slot = (Binding)this.inputIterator.next();
            if (!this.db.netAdd(this.slot)) continue;
            return;
        }
        if (null == this.dbIter) {
            this.dbIter = this.db.netIterator();
        }
        if (this.dbIter.hasNext()) {
            this.slot = this.dbIter.next();
            return;
        }
        this.close();
    }

    @Override
    protected boolean hasNextBinding() {
        this.init();
        return !this.finished;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        this.init();
        Binding toReturn = this.slot;
        this.fill();
        return toReturn;
    }

    @Override
    protected void closeIterator() {
        if (this.inputIterator != null) {
            NiceIterator.close(this.inputIterator);
            Iter.close(this.inputIterator);
        }
        if (this.dbIter != null) {
            Iter.close(this.dbIter);
        }
        this.finished = true;
        this.slot = null;
        this.dbIter = null;
        this.db.close();
    }
}

