/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.OpEval;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.PlanOp;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.mgt.QueryEngineInfo;
import com.hp.hpl.jena.sparql.util.Context;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.logging.Log;

public abstract class QueryEngineBase
implements OpEval,
Closeable {
    public static final QueryEngineInfo queryEngineInfo = new QueryEngineInfo();
    protected DatasetGraph dataset = null;
    protected Context context;
    private Binding startBinding;
    private Query query = null;
    private Op queryOp = null;
    private Plan plan = null;

    protected QueryEngineBase(Query query2, DatasetGraph dataset, Binding input, Context cxt) {
        this(dataset, input, cxt);
        this.query = query2;
        query2.setResultVars();
        this.setOp(this.createOp(query2));
    }

    protected QueryEngineBase(Op op, DatasetGraph dataset, Binding input, Context cxt) {
        this(dataset, input, cxt);
        if (this.context == null) {
            this.context = Context.setupContext(this.context, dataset);
        }
        this.query = null;
        this.setOp(op);
    }

    private QueryEngineBase(DatasetGraph dataset, Binding input, Context context) {
        this.context = context;
        this.dataset = dataset;
        if (input == null) {
            Log.warn(this, "Null initial input");
            input = BindingRoot.create();
        }
        this.startBinding = input;
    }

    public Plan getPlan() {
        if (this.plan == null) {
            this.plan = this.createPlan();
        }
        return this.plan;
    }

    protected Plan createPlan() {
        Op op = this.modifyOp(this.queryOp);
        QueryIterator queryIterator = null;
        queryIterator = this.dataset != null ? this.evaluate(op, this.dataset, this.startBinding, this.context) : this.evaluateNoMgt(op, this.dataset, this.startBinding, this.context);
        return new PlanOp(this.getOp(), this, queryIterator);
    }

    protected Op modifyOp(Op op) {
        return op;
    }

    protected Op createOp(Query query2) {
        Op op = Algebra.compile(query2);
        return op;
    }

    @Override
    public final QueryIterator evaluate(Op op, DatasetGraph dsg, Binding binding, Context context) {
        if (this.query != null) {
            Explain.explain("QUERY", this.query, context);
        }
        Explain.explain("ALGEBRA", op, context);
        queryEngineInfo.incQueryCount();
        queryEngineInfo.setLastQueryExecAt();
        queryEngineInfo.setLastQueryString((Query)context.get(ARQConstants.sysCurrentQuery));
        queryEngineInfo.setLastOp(op);
        return this.eval(op, dsg, binding, context);
    }

    private QueryIterator evaluateNoMgt(Op op, DatasetGraph dsg, Binding binding, Context context) {
        return this.eval(op, dsg, binding, context);
    }

    protected abstract QueryIterator eval(Op var1, DatasetGraph var2, Binding var3, Context var4);

    public Op getOp() {
        return this.queryOp;
    }

    protected Binding getStartBinding() {
        return this.startBinding;
    }

    @Override
    public void close() {
    }

    protected void setOp(Op op) {
        this.queryOp = op;
        this.context.put(ARQConstants.sysCurrentAlgebra, op);
    }
}

