/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.PatternLiteral;

public class Rewrite {
    public static Expression rewriteStringMatch(Expression e2) {
        Expression L = e2.getArg(0);
        Expression R = e2.getArg(1);
        PatternLiteral pattern = Rewrite.getPattern(R);
        if (pattern == null) {
            return e2;
        }
        if (Rewrite.isStartsWith(pattern)) {
            return Rewrite.startsWith(L, pattern.getPatternString().substring(1), pattern.getPatternModifiers());
        }
        if (Rewrite.isContains(pattern)) {
            return Rewrite.contains(L, pattern.getPatternString(), pattern.getPatternModifiers());
        }
        if (Rewrite.isEndsWith(pattern)) {
            return Rewrite.endsWith(L, Rewrite.front(pattern.getPatternString()), pattern.getPatternModifiers());
        }
        return e2;
    }

    protected static String front(String s) {
        return s.substring(0, s.length() - 1);
    }

    public static PatternLiteral getPattern(Expression E) {
        PatternLiteral L;
        if (E instanceof PatternLiteral && (L = (PatternLiteral)((Object)E)).getPatternLanguage().equals("http://jena.hpl.hp.com/2003/07/query/RDQL")) {
            return L;
        }
        return null;
    }

    public static Expression endsWith(Expression L, final String content, String modifiers) {
        if (modifiers.equals("i")) {
            return new DyadicLiteral(L, "urn:x-jena:expr:J_endsWithInsensitive", content){
                protected final String lowerContent;
                {
                    super(x0, x1, x2);
                    this.lowerContent = content.toLowerCase();
                }

                @Override
                public boolean evalBool(String l, String r) {
                    return l.toLowerCase().endsWith(this.lowerContent);
                }
            };
        }
        return new DyadicLiteral(L, "urn:x-jena:expr:J_endsWith", content){

            @Override
            public boolean evalBool(String l, String r) {
                return l.endsWith(r);
            }
        };
    }

    public static Expression startsWith(Expression L, final String content, String modifiers) {
        if (modifiers.equals("i")) {
            return new DyadicLiteral(L, "urn:x-jena:expr:J_startsWithInsensitive", content){
                protected final String lowerContent;
                {
                    super(x0, x1, x2);
                    this.lowerContent = content.toLowerCase();
                }

                @Override
                public boolean evalBool(String l, String r) {
                    return l.toLowerCase().startsWith(this.lowerContent);
                }
            };
        }
        return new DyadicLiteral(L, "urn:x-jena:expr:J_startsWith", content){

            @Override
            public boolean evalBool(String l, String r) {
                return l.startsWith(r);
            }
        };
    }

    public static Expression contains(Expression L, final String content, String modifiers) {
        if (modifiers.equals("i")) {
            return new DyadicLiteral(L, "urn:x-jena:expr:J_containsInsensitive", content){
                protected final String lowerContent;
                {
                    super(x0, x1, x2);
                    this.lowerContent = content.toLowerCase();
                }

                @Override
                public boolean evalBool(String l, String r) {
                    return l.toLowerCase().indexOf(this.lowerContent) > -1;
                }
            };
        }
        return new DyadicLiteral(L, "urn:x-jena:expr:J_contains", content){

            @Override
            public boolean evalBool(String l, String r) {
                return l.indexOf(r) > -1;
            }
        };
    }

    public static boolean notSpecial(String pattern) {
        return pattern.matches("[A-Za-z0-9-_:/ ]*");
    }

    public static boolean isContains(PatternLiteral pattern) {
        return Rewrite.notSpecial(pattern.getPatternString()) && Rewrite.iOnly(pattern.getPatternModifiers());
    }

    protected static boolean iOnly(String modifiers) {
        return modifiers.equals("") || modifiers.equals("i");
    }

    public static boolean isStartsWith(PatternLiteral pattern) {
        String s = pattern.getPatternString();
        return s.startsWith("^") && Rewrite.notSpecial(s.substring(1));
    }

    public static boolean isEndsWith(PatternLiteral pattern) {
        String s = pattern.getPatternString();
        return s.endsWith("$") && Rewrite.notSpecial(s.substring(0, s.length() - 1));
    }

    public static abstract class DyadicLiteral
    extends Dyadic {
        public DyadicLiteral(Expression L, String F, String R) {
            super(L, F, new Expression.Fixed(R));
        }

        @Override
        public boolean evalBool(Object l, Object r) {
            return this.evalBool(this.nodeAsString(l), r.toString());
        }

        protected String nodeAsString(Object x) {
            return x instanceof Node_Literal ? ((Node_Literal)x).getLiteralLexicalForm() : x.toString();
        }

        protected abstract boolean evalBool(String var1, String var2);
    }
}

