/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGNodeFactory;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;

public class AGQuerySolution
implements QuerySolution {
    private final BindingSet bs;
    private final AGModel model;

    public AGQuerySolution(BindingSet bs, AGModel model) {
        this.bs = bs;
        this.model = model;
    }

    @Override
    public boolean contains(String varName) {
        return this.bs.hasBinding(varName);
    }

    @Override
    public RDFNode get(String varName) {
        Value val = this.bs.getValue(varName);
        if (val == null) {
            return null;
        }
        Node node = AGNodeFactory.asNode(val);
        return this.model.asRDFNode(node);
    }

    @Override
    public Literal getLiteral(String varName) {
        return (Literal)this.get(varName);
    }

    @Override
    public Resource getResource(String varName) {
        return (Resource)this.get(varName);
    }

    @Override
    public Iterator<String> varNames() {
        return this.bs.getBindingNames().iterator();
    }

    public String toString() {
        return this.bs.toString();
    }
}

