/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xerces.util.XMLChar;
import org.openrdf.model.Namespace;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class AGPrefixMapping
implements PrefixMapping {
    AGGraph graph;
    protected boolean locked;

    public AGPrefixMapping(AGGraph graph) {
        this.graph = graph;
    }

    AGGraph getGraph() {
        return this.graph;
    }

    @Override
    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String uri = this.getNsPrefixURI(prefixed.substring(0, colon));
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            RepositoryResult<Namespace> result = this.getGraph().getConnection().getNamespaces();
            while (result.hasNext()) {
                Namespace ns = result.next();
                map.put(ns.getPrefix(), ns.getName());
            }
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        return map;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        String uri = null;
        try {
            if (prefix != null) {
                uri = this.getGraph().getConnection().getNamespace(prefix);
            }
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        return uri;
    }

    @Override
    public String getNsURIPrefix(String uri) {
        String prefix = null;
        try {
            RepositoryResult<Namespace> result = this.getGraph().getConnection().getNamespaces();
            while (prefix == null && result.hasNext()) {
                Namespace ns = result.next();
                if (!uri.equalsIgnoreCase(ns.getName())) continue;
                prefix = ns.getPrefix();
            }
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        return prefix;
    }

    @Override
    public PrefixMapping lock() {
        this.locked = true;
        return this;
    }

    @Override
    public String qnameFor(String uri) {
        int split = Util.splitNamespace(uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = this.getNsURIPrefix(ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.checkUnlocked();
        try {
            this.getGraph().getConnection().removeNamespace(prefix);
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        return this;
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return ((Object)this.getNsPrefixMap()).equals(other.getNsPrefixMap());
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.checkUnlocked();
        if (prefix.length() > 0 && !XMLChar.isValidNCName(prefix)) {
            throw new PrefixMapping.IllegalPrefixException(prefix);
        }
        if (uri == null) {
            throw new NullPointerException("null URIs are prohibited as arguments to setNsPrefix");
        }
        try {
            this.getGraph().getConnection().setNamespace(prefix, uri);
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        return this;
    }

    protected void checkUnlocked() {
        if (this.locked) {
            throw new PrefixMapping.JenaLockedException(this);
        }
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        this.checkUnlocked();
        for (String key : map.keySet()) {
            this.setNsPrefix(key, map.get(key));
        }
        return this;
    }

    @Override
    public String shortForm(String uri) {
        Map<String, String> map = this.getNsPrefixMap();
        for (Map.Entry<String, String> s : map.entrySet()) {
            if (!uri.startsWith(s.getValue())) continue;
            return s.getKey() + ":" + uri.substring(s.getValue().length());
        }
        return uri;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        Map<String, String> thisMap = this.getNsPrefixMap();
        Map<String, String> otherMap = map.getNsPrefixMap();
        for (String key : otherMap.keySet()) {
            String value = otherMap.get(key);
            if (thisMap.containsKey(key) || thisMap.containsValue(value)) continue;
            this.setNsPrefix(key, value);
        }
        return this;
    }

    public String toString() {
        return this.toString(20);
    }

    public String toString(int max2) {
        int count;
        Map<String, String> map = this.getNsPrefixMap();
        int size = map.size();
        Iterator<String> it = map.keySet().iterator();
        StringBuffer b = new StringBuffer(this.getClass().getSimpleName() + "(size: " + size + "){");
        String gap = "";
        for (count = 0; it.hasNext() && count < max2; ++count) {
            b.append(gap);
            gap = ", ";
            String key = it.next();
            b.append(key + "=" + map.get(key));
        }
        if (count == max2 && it.hasNext()) {
            b.append(",...");
        }
        b.append("}");
        return b.toString();
    }
}

